/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.WorldBorderGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.ranges.RangesKt;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldBorderSettings;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010!\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010\"\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010#\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010$\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010%\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010&\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010'\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010(\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010)\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010*\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010+\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010,\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010-\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010.\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u0010/\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00100\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00101\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00102\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00103\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00104\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00105\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00106\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u0016\u00107\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J\u001c\u00108\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u00109\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0002J$\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010=\u001a\u00020>H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Ltech/bedson/playerworldmanager/commands/WorldBorderCommands;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldBorderGui", "Ltech/bedson/playerworldmanager/gui/WorldBorderGui;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/gui/WorldBorderGui;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "applyWorldBorder", "", "world", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "applyWorldBorderWithTransition", "targetSize", "", "timeSeconds", "", "build", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "getPlayerWorld", "player", "Lorg/bukkit/entity/Player;", "worldName", "", "handleAdd", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "handleAddWithTime", "handleAddWithTimeAndWorld", "handleAddWithWorld", "handleCenter", "handleCenterWithWorld", "handleDamageAmount", "handleDamageAmountWithWorld", "handleDamageBuffer", "handleDamageBufferWithWorld", "handleDefault", "handleGet", "handleGetWithWorld", "handleHelp", "handleMenu", "handleMenuWithWorld", "handleSet", "handleSetWithTime", "handleSetWithTimeAndWorld", "handleSetWithWorld", "handleWarningDistance", "handleWarningDistanceWithWorld", "handleWarningTime", "handleWarningTimeWithWorld", "requireOwnedWorld", "sendPlayerOnlyError", "suggestOwnedWorlds", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldBorderCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldBorderCommands.kt\ntech/bedson/playerworldmanager/commands/WorldBorderCommands\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,754:1\n1#2:755\n1549#3:756\n1620#3,3:757\n766#3:760\n857#3,2:761\n1855#3,2:763\n*S KotlinDebug\n*F\n+ 1 WorldBorderCommands.kt\ntech/bedson/playerworldmanager/commands/WorldBorderCommands\n*L\n747#1:756\n747#1:757,3\n748#1:760\n748#1:761,2\n749#1:763,2\n*E\n"})
public final class WorldBorderCommands {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldBorderGui worldBorderGui;
    @NotNull
    private final DebugLogger debugLogger;

    public WorldBorderCommands(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull DataManager dataManager, @NotNull WorldBorderGui worldBorderGui) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldBorderGui, "worldBorderGui");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.dataManager = dataManager;
        this.worldBorderGui = worldBorderGui;
        this.debugLogger = new DebugLogger(this.plugin, "WorldBorderCommands");
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> build() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldborder").executes(this::handleDefault)).then(((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleGetWithWorld))).executes(this::handleGet))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"size", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)1.0, (double)5.9999968E7))).then(((RequiredArgumentBuilder)Commands.argument((String)"time", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleSetWithTimeAndWorld))).executes(this::handleSetWithTime))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleSetWithWorld))).executes(this::handleSet)))).then(Commands.literal((String)"add").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"size", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7))).then(((RequiredArgumentBuilder)Commands.argument((String)"time", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleAddWithTimeAndWorld))).executes(this::handleAddWithTime))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleAddWithWorld))).executes(this::handleAdd)))).then(Commands.literal((String)"center").then(Commands.argument((String)"x", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg())).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg())).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleCenterWithWorld))).executes(this::handleCenter))))).then(((LiteralArgumentBuilder)Commands.literal((String)"damage").then(Commands.literal((String)"amount").then(((RequiredArgumentBuilder)Commands.argument((String)"damage", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)0.0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleDamageAmountWithWorld))).executes(this::handleDamageAmount)))).then(Commands.literal((String)"buffer").then(((RequiredArgumentBuilder)Commands.argument((String)"distance", (ArgumentType)((ArgumentType)DoubleArgumentType.doubleArg((double)0.0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleDamageBufferWithWorld))).executes(this::handleDamageBuffer))))).then(((LiteralArgumentBuilder)Commands.literal((String)"warning").then(Commands.literal((String)"distance").then(((RequiredArgumentBuilder)Commands.argument((String)"distance", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleWarningDistanceWithWorld))).executes(this::handleWarningDistance)))).then(Commands.literal((String)"time").then(((RequiredArgumentBuilder)Commands.argument((String)"time", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleWarningTimeWithWorld))).executes(this::handleWarningTime))))).then(((LiteralArgumentBuilder)Commands.literal((String)"menu").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnedWorlds).executes(this::handleMenuWithWorld))).executes(this::handleMenu))).then(Commands.literal((String)"help").executes(this::handleHelp))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final int sendPlayerOnlyError(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be run by players!", (TextColor)NamedTextColor.RED));
        return 1;
    }

    private final PlayerWorld getPlayerWorld(Player player, String worldName) {
        PlayerWorld playerWorld;
        if (worldName != null) {
            Object v1;
            block4: {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
                for (Object t : iterable) {
                    PlayerWorld it = (PlayerWorld)t;
                    boolean bl = false;
                    if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            playerWorld = v1;
        } else {
            Object v5;
            block5: {
                World world = player.getWorld();
                Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                World currentWorld = world;
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
                for (Object t : iterable) {
                    PlayerWorld world2 = (PlayerWorld)t;
                    boolean bl = false;
                    World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world2, null, 2, null);
                    if (!Intrinsics.areEqual(bukkitWorld, currentWorld)) continue;
                    v5 = t;
                    break block5;
                }
                v5 = null;
            }
            playerWorld = v5;
        }
        return playerWorld;
    }

    private final PlayerWorld requireOwnedWorld(Player player, String worldName) {
        PlayerWorld world = this.getPlayerWorld(player, worldName);
        if (world == null) {
            if (worldName != null) {
                player.sendMessage(Component.text("You don't own a world named ", (TextColor)NamedTextColor.RED).append(Component.text(worldName, (TextColor)NamedTextColor.GOLD)));
            } else {
                player.sendMessage(Component.text("You are not in one of your own worlds. ", (TextColor)NamedTextColor.RED).append(Component.text("Specify a world name or teleport to your world first.", (TextColor)NamedTextColor.GRAY)));
            }
        }
        return world;
    }

    private final void applyWorldBorder(PlayerWorld world) {
        World world2 = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        if (world2 == null) {
            return;
        }
        World bukkitWorld = world2;
        WorldBorder worldBorder = bukkitWorld.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder border = worldBorder;
        WorldBorderSettings settings = world.getWorldBorder();
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderCommands.applyWorldBorder$lambda$2(border, bukkitWorld, settings, arg_0));
    }

    private final void applyWorldBorderWithTransition(PlayerWorld world, double targetSize, int timeSeconds) {
        World world2 = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
        if (world2 == null) {
            return;
        }
        World bukkitWorld = world2;
        WorldBorder worldBorder = bukkitWorld.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder border = worldBorder;
        WorldBorderSettings settings = world.getWorldBorder();
        Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderCommands.applyWorldBorderWithTransition$lambda$3(border, bukkitWorld, settings, timeSeconds, targetSize, arg_0));
    }

    private final int handleDefault(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld world = this.requireOwnedWorld(player2, null);
        if (world == null) {
            return this.handleHelp(ctx);
        }
        player2.getScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderCommands.handleDefault$lambda$4(this, player2, world, arg_0), null);
        return 1;
    }

    private final int handleGet(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        WorldBorderSettings settings = world.getWorldBorder();
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("World border for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" is currently ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)settings.getSize()), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks wide", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleGetWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        WorldBorderSettings settings = world.getWorldBorder();
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("World border for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" is currently ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)settings.getSize()), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks wide", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleSet(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double size = DoubleArgumentType.getDouble(ctx, (String)"size");
        world.getWorldBorder().setSize(size);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)Component.text("Set world border size to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleSetWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double size = DoubleArgumentType.getDouble(ctx, (String)"size");
        world.getWorldBorder().setSize(size);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border size for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleSetWithTime(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double size = DoubleArgumentType.getDouble(ctx, (String)"size");
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        world.getWorldBorder().setSize(size);
        this.dataManager.saveWorld(world);
        this.applyWorldBorderWithTransition(world, size, time);
        if (time > 0) {
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Setting world border size to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks over ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        } else {
            player2.sendMessage(((TextComponent)Component.text("Set world border size to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        }
        return 1;
    }

    private final int handleSetWithTimeAndWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double size = DoubleArgumentType.getDouble(ctx, (String)"size");
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        world.getWorldBorder().setSize(size);
        this.dataManager.saveWorld(world);
        this.applyWorldBorderWithTransition(world, size, time);
        if (time > 0) {
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("Setting world border size for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks over ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        } else {
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border size for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)size), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        }
        return 1;
    }

    private final int handleAdd(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double amount = DoubleArgumentType.getDouble(ctx, (String)"size");
        double newSize = RangesKt.coerceIn(world.getWorldBorder().getSize() + amount, 1.0, 5.9999968E7);
        world.getWorldBorder().setSize(newSize);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        String verb = amount >= 0.0 ? "Increased" : "Decreased";
        player2.sendMessage(((TextComponent)Component.text(verb + " world border to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleAddWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double amount = DoubleArgumentType.getDouble(ctx, (String)"size");
        double newSize = RangesKt.coerceIn(world.getWorldBorder().getSize() + amount, 1.0, 5.9999968E7);
        world.getWorldBorder().setSize(newSize);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        String verb = amount >= 0.0 ? "Increased" : "Decreased";
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text(verb + " world border for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleAddWithTime(CommandContext<CommandSourceStack> ctx) {
        String verb;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double amount = DoubleArgumentType.getDouble(ctx, (String)"size");
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        double newSize = RangesKt.coerceIn(world.getWorldBorder().getSize() + amount, 1.0, 5.9999968E7);
        world.getWorldBorder().setSize(newSize);
        this.dataManager.saveWorld(world);
        this.applyWorldBorderWithTransition(world, newSize, time);
        String string = verb = amount >= 0.0 ? "Increasing" : "Decreasing";
        if (time > 0) {
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text(verb + " world border to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks over ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        } else {
            String verbPast = amount >= 0.0 ? "Increased" : "Decreased";
            player2.sendMessage(((TextComponent)Component.text(verbPast + " world border to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        }
        return 1;
    }

    private final int handleAddWithTimeAndWorld(CommandContext<CommandSourceStack> ctx) {
        String verb;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double amount = DoubleArgumentType.getDouble(ctx, (String)"size");
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        double newSize = RangesKt.coerceIn(world.getWorldBorder().getSize() + amount, 1.0, 5.9999968E7);
        world.getWorldBorder().setSize(newSize);
        this.dataManager.saveWorld(world);
        this.applyWorldBorderWithTransition(world, newSize, time);
        String string = verb = amount >= 0.0 ? "Increasing" : "Decreasing";
        if (time > 0) {
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text(verb + " world border for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks over ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        } else {
            String verbPast = amount >= 0.0 ? "Increased" : "Decreased";
            player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text(verbPast + " world border for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf((long)newSize), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        }
        return 1;
    }

    private final int handleCenter(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double x = DoubleArgumentType.getDouble(ctx, (String)"x");
        double z = DoubleArgumentType.getDouble(ctx, (String)"z");
        world.getWorldBorder().setCenterX(x);
        world.getWorldBorder().setCenterZ(z);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(Component.text("Set world border center to ", (TextColor)NamedTextColor.GREEN).append(Component.text((long)x + ", " + (long)z, (TextColor)NamedTextColor.YELLOW)));
        return 1;
    }

    private final int handleCenterWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double x = DoubleArgumentType.getDouble(ctx, (String)"x");
        double z = DoubleArgumentType.getDouble(ctx, (String)"z");
        world.getWorldBorder().setCenterX(x);
        world.getWorldBorder().setCenterZ(z);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)Component.text("Set world border center for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text((long)x + ", " + (long)z, (TextColor)NamedTextColor.YELLOW)));
        return 1;
    }

    private final int handleDamageAmount(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double damage = DoubleArgumentType.getDouble(ctx, (String)"damage");
        world.getWorldBorder().setDamageAmount(damage);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)Component.text("Set world border damage to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(damage), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" per block", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleDamageAmountWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double damage = DoubleArgumentType.getDouble(ctx, (String)"damage");
        world.getWorldBorder().setDamageAmount(damage);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border damage for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(damage), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" per block", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleDamageBuffer(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double buffer = DoubleArgumentType.getDouble(ctx, (String)"distance");
        world.getWorldBorder().setDamageBuffer(buffer);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)Component.text("Set world border damage buffer to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(buffer), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleDamageBufferWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        double buffer = DoubleArgumentType.getDouble(ctx, (String)"distance");
        world.getWorldBorder().setDamageBuffer(buffer);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border damage buffer for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(buffer), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleWarningDistance(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        int distance = IntegerArgumentType.getInteger(ctx, (String)"distance");
        world.getWorldBorder().setWarningDistance(distance);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)Component.text("Set world border warning distance to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(distance), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleWarningDistanceWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        int distance = IntegerArgumentType.getInteger(ctx, (String)"distance");
        world.getWorldBorder().setWarningDistance(distance);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border warning distance for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(distance), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" blocks", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleWarningTime(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        world.getWorldBorder().setWarningTime(time);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)Component.text("Set world border warning time to ", (TextColor)NamedTextColor.GREEN).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleWarningTimeWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        int time = IntegerArgumentType.getInteger(ctx, (String)"time");
        world.getWorldBorder().setWarningTime(time);
        this.dataManager.saveWorld(world);
        this.applyWorldBorder(world);
        player2.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Set world border warning time for ", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(String.valueOf(time), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" seconds", (TextColor)NamedTextColor.GREEN)));
        return 1;
    }

    private final int handleMenu(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, null);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        player2.getScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderCommands.handleMenu$lambda$5(this, player2, world, arg_0), null);
        return 1;
    }

    private final int handleMenuWithWorld(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            return this.sendPlayerOnlyError(ctx);
        }
        Player player2 = player;
        String worldName = StringArgumentType.getString(ctx, (String)"world");
        PlayerWorld playerWorld = this.requireOwnedWorld(player2, worldName);
        if (playerWorld == null) {
            return 1;
        }
        PlayerWorld world = playerWorld;
        player2.getScheduler().run((Plugin)this.plugin, arg_0 -> WorldBorderCommands.handleMenuWithWorld$lambda$6(this, player2, world, arg_0), null);
        return 1;
    }

    private final int handleHelp(CommandContext<CommandSourceStack> ctx) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        sender.sendMessage((Component)Component.text("=== World Border Commands ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage(Component.text("/worldborder", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Open border settings GUI", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder get [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Get current border size", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder set <size> [time] [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set border size", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder add <amount> [time] [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Add/subtract from border size", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder center <x> <z> [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set border center", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder damage amount <damage> [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set damage per block", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder damage buffer <distance> [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set damage buffer distance", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder warning distance <blocks> [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set warning distance", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder warning time <seconds> [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Set warning time", (TextColor)NamedTextColor.GRAY)));
        sender.sendMessage(Component.text("/worldborder menu [world]", (TextColor)NamedTextColor.YELLOW).append(Component.text(" - Open border settings GUI", (TextColor)NamedTextColor.GRAY)));
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestOwnedWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (sender instanceof Player) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            UUID uUID = ((Player)sender).getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((PlayerWorld)((Object)it)).getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String string2 = builder.getRemainingLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
                if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl = false;
                builder.suggest(it2);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private static final void applyWorldBorder$lambda$2(WorldBorder $border, World $bukkitWorld, WorldBorderSettings $settings, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($border, "$border");
        Intrinsics.checkNotNullParameter($bukkitWorld, "$bukkitWorld");
        Intrinsics.checkNotNullParameter($settings, "$settings");
        $border.setCenter(new Location($bukkitWorld, $settings.getCenterX(), 0.0, $settings.getCenterZ()));
        $border.setSize($settings.getSize());
        $border.setDamageAmount($settings.getDamageAmount());
        $border.setDamageBuffer($settings.getDamageBuffer());
        $border.setWarningDistance($settings.getWarningDistance());
        $border.setWarningTime($settings.getWarningTime());
    }

    private static final void applyWorldBorderWithTransition$lambda$3(WorldBorder $border, World $bukkitWorld, WorldBorderSettings $settings, int $timeSeconds, double $targetSize, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($border, "$border");
        Intrinsics.checkNotNullParameter($bukkitWorld, "$bukkitWorld");
        Intrinsics.checkNotNullParameter($settings, "$settings");
        $border.setCenter(new Location($bukkitWorld, $settings.getCenterX(), 0.0, $settings.getCenterZ()));
        $border.setDamageAmount($settings.getDamageAmount());
        $border.setDamageBuffer($settings.getDamageBuffer());
        $border.setWarningDistance($settings.getWarningDistance());
        $border.setWarningTime($settings.getWarningTime());
        if ($timeSeconds > 0) {
            $border.setSize($targetSize, (long)$timeSeconds);
        } else {
            $border.setSize($targetSize);
        }
    }

    private static final void handleDefault$lambda$4(WorldBorderCommands this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        this$0.worldBorderGui.open($player, $world);
    }

    private static final void handleMenu$lambda$5(WorldBorderCommands this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.worldBorderGui.open($player, $world);
    }

    private static final void handleMenuWithWorld$lambda$6(WorldBorderCommands this$0, Player $player, PlayerWorld $world, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        this$0.worldBorderGui.open($player, $world);
    }
}

