/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.commands.WorldAdminCommands;
import tech.bedson.playerworldmanager.gui.AdminMenuGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.Result;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.Unit;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntries;
import tech.bedson.playerworldmanager.libs.kotlin.enums.EnumEntriesKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.functions.Function1;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Ref;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.ranges.RangesKt;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001e\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\u001f\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010 \u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010!\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J(\u0010#\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0016\u0010&\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010'\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010(\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010)\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010*\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0016\u0010+\u001a\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010/\u001a\u000200H\u0002J$\u00101\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Ltech/bedson/playerworldmanager/commands/WorldAdminCommands;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "adminMenuGui", "Ltech/bedson/playerworldmanager/gui/AdminMenuGui;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/gui/AdminMenuGui;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "purgeConfirmations", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ltech/bedson/playerworldmanager/commands/WorldAdminCommands$PurgeConfirmation;", "build", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "findWorld", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "handleDelete", "", "handleDisable", "handleEnable", "handleHelp", "handleInfo", "handleList", "handleListPlayer", "handleListPlayerPage", "handleListWithParams", "playerName", "page", "handleMenu", "handlePurge", "handleReload", "handleSetLimit", "handleStats", "handleTeleport", "suggestOwnerWorlds", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "suggestPlayersWithWorlds", "PurgeConfirmation", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nWorldAdminCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldAdminCommands.kt\ntech/bedson/playerworldmanager/commands/WorldAdminCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n1855#2,2:789\n1549#2:791\n1620#2,3:792\n1855#2,2:795\n766#2:797\n857#2,2:798\n1549#2:800\n1620#2,3:801\n1855#2,2:804\n1774#2,4:806\n1774#2,4:810\n1549#2:814\n1620#2,3:815\n766#2:818\n857#2,2:819\n1855#2,2:821\n1549#2:823\n1620#2,3:824\n766#2:827\n857#2,2:828\n1855#2,2:830\n288#2,2:832\n*S KotlinDebug\n*F\n+ 1 WorldAdminCommands.kt\ntech/bedson/playerworldmanager/commands/WorldAdminCommands\n*L\n224#1:789,2\n264#1:791\n264#1:792,3\n425#1:795,2\n538#1:797\n538#1:798,2\n574#1:800\n574#1:801,3\n579#1:804,2\n604#1:806,4\n605#1:810,4\n723#1:814\n723#1:815,3\n724#1:818\n724#1:819,2\n725#1:821,2\n736#1:823\n736#1:824,3\n737#1:827\n737#1:828,2\n738#1:830,2\n769#1:832,2\n*E\n"})
public final class WorldAdminCommands {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final AdminMenuGui adminMenuGui;
    @NotNull
    private final DebugLogger debugLogger;
    @NotNull
    private final ConcurrentHashMap<String, PurgeConfirmation> purgeConfirmations;

    public WorldAdminCommands(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager, @NotNull AdminMenuGui adminMenuGui) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(adminMenuGui, "adminMenuGui");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.adminMenuGui = adminMenuGui;
        this.debugLogger = new DebugLogger(this.plugin, "WorldAdminCommands");
        this.purgeConfirmations = new ConcurrentHashMap();
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> build() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldadmin").requires(WorldAdminCommands::build$lambda$0)).then(((LiteralArgumentBuilder)Commands.literal((String)"list").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"page", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(this::handleListPlayerPage))).executes(this::handleListPlayer))).executes(this::handleList))).then(Commands.literal((String)"info").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleInfo))))).then(Commands.literal((String)"tp").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleTeleport))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleDelete))))).then(Commands.literal((String)"disable").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleDisable))))).then(Commands.literal((String)"enable").then(Commands.argument((String)"owner", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestOwnerWorlds).executes(this::handleEnable))))).then(Commands.literal((String)"setlimit").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestPlayersWithWorlds).then(Commands.argument((String)"limit", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)-1))).executes(this::handleSetLimit))))).then(Commands.literal((String)"purge").then(Commands.argument((String)"days", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(this::handlePurge)))).then(Commands.literal((String)"stats").executes(this::handleStats))).then(Commands.literal((String)"reload").executes(this::handleReload))).then(Commands.literal((String)"menu").executes(this::handleMenu))).then(Commands.literal((String)"help").executes(this::handleHelp))).executes(this::handleHelp)).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final int handleList(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleList", pairArray);
        int result = this.handleListWithParams(ctx, null, 1);
        this.debugLogger.debugMethodExit("handleList", result);
        return result;
    }

    private final int handleListPlayer(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName()), TuplesKt.to("playerName", playerName)};
        this.debugLogger.debugMethodEntry("handleListPlayer", pairArray);
        int result = this.handleListWithParams(ctx, playerName, 1);
        this.debugLogger.debugMethodExit("handleListPlayer", result);
        return result;
    }

    private final int handleListPlayerPage(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        int page = IntegerArgumentType.getInteger(ctx, (String)"page");
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName()), TuplesKt.to("playerName", playerName), TuplesKt.to("page", page)};
        this.debugLogger.debugMethodEntry("handleListPlayerPage", pairArray);
        int result = this.handleListWithParams(ctx, playerName, page);
        this.debugLogger.debugMethodExit("handleListPlayerPage", result);
        return result;
    }

    private final int handleListWithParams(CommandContext<CommandSourceStack> ctx, String playerName, int page) {
        List<PlayerWorld> list;
        Pair[] targetPlayer;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName()), TuplesKt.to("playerName", playerName), TuplesKt.to("page", page)};
        this.debugLogger.debugMethodEntry("handleListWithParams", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: Executing admin list command (player='" + playerName + "', page=" + page + ")");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (playerName != null) {
            this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: Listing worlds for specific player '" + playerName + "'");
            Pair[] pairArray2 = Bukkit.getOfflinePlayer((String)playerName);
            Intrinsics.checkNotNullExpressionValue(pairArray2, "getOfflinePlayer(...)");
            targetPlayer = pairArray2;
            boolean targetExists = targetPlayer.hasPlayedBefore() || targetPlayer.isOnline();
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerName", playerName), TuplesKt.to("exists", targetExists), TuplesKt.to("uuid", targetPlayer.getUniqueId())};
            this.debugLogger.debug("Target player lookup", pairArray3);
            if (!targetExists) {
                this.plugin.getLogger().warning("[WorldAdminCommands] handleListWithParams: Player '" + playerName + "' not found");
                sender.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(playerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
                this.debugLogger.debugMethodExit("handleListWithParams", "player not found");
                return 1;
            }
            UUID uUID = targetPlayer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            list = this.dataManager.getWorldsByOwner(uUID);
        } else {
            this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: Listing all worlds");
            this.debugLogger.debug("Listing all worlds");
            list = this.dataManager.getAllWorlds();
        }
        List<PlayerWorld> worlds = list;
        targetPlayer = new Pair[]{TuplesKt.to("count", worlds.size())};
        this.debugLogger.debug("Worlds retrieved", targetPlayer);
        if (worlds.isEmpty()) {
            this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: No worlds found");
            sender.sendMessage((Component)Component.text("No worlds found", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleListWithParams", "no worlds");
            return 1;
        }
        int pageSize = 10;
        int totalPages = (worlds.size() + pageSize - 1) / pageSize;
        int actualPage = RangesKt.coerceIn(page, 1, totalPages);
        int startIndex = (actualPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, worlds.size());
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("totalWorlds", worlds.size()), TuplesKt.to("pageSize", pageSize), TuplesKt.to("totalPages", totalPages), TuplesKt.to("actualPage", actualPage), TuplesKt.to("startIndex", startIndex), TuplesKt.to("endIndex", endIndex)};
        this.debugLogger.debug("Pagination", pairArray4);
        this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: Displaying " + worlds.size() + " world(s) (page " + actualPage + "/" + totalPages + ")");
        sender.sendMessage((Component)Component.text("=== World List (Page " + actualPage + "/" + totalPages + ") ===", (TextColor)NamedTextColor.DARK_PURPLE));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Iterable $this$forEach$iv = worlds.subList(startIndex, endIndex);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl = false;
            String status = world.isEnabled() ? "Enabled" : "Disabled";
            NamedTextColor statusColor = world.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED;
            String createdDate = dateFormat.format(new Date(world.getCreatedAt()));
            sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("[" + world.getOwnerName() + "] ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(status, (TextColor)statusColor))).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(createdDate, (TextColor)NamedTextColor.YELLOW)));
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleListWithParams: Command completed successfully");
        this.debugLogger.debugMethodExit("handleListWithParams", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int handleInfo(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleInfo", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleInfo: Executing admin info command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        PlayerWorld world = this.findWorld(ctx);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleInfo", "world not found");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleInfo: Retrieving info for world '" + world.getName() + "' owned by " + world.getOwnerName());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("id", world.getId()), TuplesKt.to("name", world.getName()), TuplesKt.to("ownerUuid", world.getOwnerUuid()), TuplesKt.to("isEnabled", world.isEnabled())};
        this.debugLogger.debugState("PlayerWorld", pairArray2);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String createdDate = dateFormat.format(new Date(world.getCreatedAt()));
        List onlinePlayers = new ArrayList();
        for (World.Environment env : EntriesMappings.entries$0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            World bukkitWorld = this.worldManager.getBukkitWorld(world, env);
            if (bukkitWorld == null) continue;
            List list = bukkitWorld.getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            Iterable iterable = list;
            List list2 = onlinePlayers;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Player player = (Player)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                collection.add(string);
            }
            list2.addAll((List)destination$iv$iv);
        }
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("count", onlinePlayers.size()), TuplesKt.to("players", onlinePlayers)};
        this.debugLogger.debug("Online players in world", pairArray3);
        this.plugin.getLogger().info("[WorldAdminCommands] handleInfo: World '" + world.getName() + "' has " + onlinePlayers.size() + " online player(s), " + world.getInvitedPlayers().size() + " invited player(s)");
        sender.sendMessage((Component)Component.text("=== World Info: " + world.getName() + " ===", (TextColor)NamedTextColor.DARK_PURPLE));
        sender.sendMessage(Component.text("Owner: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getOwnerName(), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Type: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.getWorldType().name(), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Created: ", (TextColor)NamedTextColor.GRAY).append(Component.text(createdDate, (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Invited Players: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(world.getInvitedPlayers().size()), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(((TextComponent)Component.text("Online: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(onlinePlayers.size()), (TextColor)NamedTextColor.GOLD))).append(!((Collection)onlinePlayers).isEmpty() ? Component.text(" (" + CollectionsKt.joinToString$default(onlinePlayers, ", ", null, null, 0, null, null, 62, null) + ")", (TextColor)NamedTextColor.YELLOW) : Component.empty()));
        sender.sendMessage(Component.text("Enabled: ", (TextColor)NamedTextColor.GRAY).append(Component.text(world.isEnabled() ? "Yes" : "No", (TextColor)(world.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED))));
        this.plugin.getLogger().info("[WorldAdminCommands] handleInfo: Command completed successfully");
        this.debugLogger.debugMethodExit("handleInfo", 1);
        return 1;
    }

    private final int handleTeleport(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleTeleport", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleTeleport: Executing admin teleport command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("isPlayer", sender instanceof Player), TuplesKt.to("senderType", sender.getClass().getSimpleName())};
        this.debugLogger.debug("Sender type check", pairArray2);
        if (!(sender instanceof Player)) {
            this.plugin.getLogger().warning("[WorldAdminCommands] handleTeleport: Non-player attempted to execute command");
            sender.sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleTeleport", "not a player");
            return 1;
        }
        PlayerWorld world = this.findWorld(ctx);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleTeleport", "world not found");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleTeleport: Admin " + ((Player)sender).getName() + " teleporting to world '" + world.getName() + "'");
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("adminName", ((Player)sender).getName()), TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Teleporting admin", pairArray3);
        sender.sendMessage((Component)Component.text("Teleporting...", (TextColor)NamedTextColor.YELLOW));
        this.worldManager.teleportToWorld((Player)sender, world).thenAccept(arg_0 -> WorldAdminCommands.handleTeleport$lambda$3(new Function1<Boolean, Unit>(this, world, sender){
            final /* synthetic */ WorldAdminCommands this$0;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ CommandSender $sender;
            {
                this.this$0 = $receiver;
                this.$world = $world;
                this.$sender = $sender;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("success", success), TuplesKt.to("worldName", this.$world.getName())};
                WorldAdminCommands.access$getDebugLogger$p(this.this$0).debug("Admin teleport result", pairArray);
                ((Player)this.$sender).getScheduler().run((Plugin)WorldAdminCommands.access$getPlugin$p(this.this$0), arg_0 -> handleTeleport.1.invoke$lambda$0(success, this.this$0, this.$sender, this.$world, arg_0), null);
            }

            private static final void invoke$lambda$0(Boolean $success, WorldAdminCommands this$0, CommandSender $sender, PlayerWorld $world, ScheduledTask scheduledTask) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNull($success);
                if ($success.booleanValue()) {
                    WorldAdminCommands.access$getPlugin$p(this$0).getLogger().info("[WorldAdminCommands] handleTeleport: Admin " + ((Player)$sender).getName() + " teleported successfully to '" + $world.getName() + "'");
                    $sender.sendMessage(Component.text("Teleported to ", (TextColor)NamedTextColor.GREEN).append(Component.text($world.getName(), (TextColor)NamedTextColor.GOLD)));
                } else {
                    WorldAdminCommands.access$getPlugin$p(this$0).getLogger().warning("[WorldAdminCommands] handleTeleport: Failed to teleport admin " + ((Player)$sender).getName() + " to '" + $world.getName() + "'");
                    $sender.sendMessage((Component)Component.text("Failed to teleport", (TextColor)NamedTextColor.RED));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleTeleport", 1);
        return 1;
    }

    private final int handleDelete(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleDelete", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleDelete: Executing admin delete command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        PlayerWorld world = this.findWorld(ctx);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleDelete", "world not found");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleDelete: Admin deleting world '" + world.getName() + "' owned by " + world.getOwnerName());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId()), TuplesKt.to("ownerName", world.getOwnerName())};
        this.debugLogger.debug("Deleting world", pairArray2);
        sender.sendMessage((Component)Component.text("Deleting world...", (TextColor)NamedTextColor.YELLOW));
        this.worldManager.deleteWorld(world).thenAccept(arg_0 -> WorldAdminCommands.handleDelete$lambda$4(new Function1<Result<? extends Unit>, Unit>(this, world, sender){
            final /* synthetic */ WorldAdminCommands this$0;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ CommandSender $sender;
            {
                this.this$0 = $receiver;
                this.$world = $world;
                this.$sender = $sender;
                super(1);
            }

            public final void invoke(Result<? extends Unit> result) {
                block2: {
                    Throwable throwable;
                    Intrinsics.checkNotNull(result);
                    Object object = result.unbox-impl();
                    WorldAdminCommands worldAdminCommands = this.this$0;
                    PlayerWorld playerWorld = this.$world;
                    CommandSender commandSender = this.$sender;
                    if (Result.isSuccess-impl(object)) {
                        Unit it = (Unit)object;
                        boolean bl = false;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName())};
                        WorldAdminCommands.access$getDebugLogger$p(worldAdminCommands).debug("World deletion succeeded", pairArray);
                        WorldAdminCommands.access$getPlugin$p(worldAdminCommands).getLogger().info("[WorldAdminCommands] handleDelete: World '" + playerWorld.getName() + "' deleted successfully");
                        commandSender.sendMessage(((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text(playerWorld.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' deleted", (TextColor)NamedTextColor.GREEN)));
                    }
                    worldAdminCommands = this.this$0;
                    playerWorld = this.$world;
                    commandSender = this.$sender;
                    Throwable throwable2 = Result.exceptionOrNull-impl(object);
                    if (throwable2 == null) break block2;
                    Throwable error = throwable = throwable2;
                    boolean bl = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", playerWorld.getName()), TuplesKt.to("error", error.getMessage())};
                    WorldAdminCommands.access$getDebugLogger$p(worldAdminCommands).debug("World deletion failed", pairArray);
                    WorldAdminCommands.access$getPlugin$p(worldAdminCommands).getLogger().warning("[WorldAdminCommands] handleDelete: Failed to delete world '" + playerWorld.getName() + "': " + error.getMessage());
                    TextComponent textComponent = Component.text("Failed: ", (TextColor)NamedTextColor.RED);
                    String string = error.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    commandSender.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
                }
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleDelete", 1);
        return 1;
    }

    private final int handleDisable(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleDisable", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: Executing admin disable command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        PlayerWorld world = this.findWorld(ctx);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleDisable", "world not found");
            return 1;
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("isEnabled", world.isEnabled())};
        this.debugLogger.debug("World state", pairArray2);
        if (!world.isEnabled()) {
            this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: World '" + world.getName() + "' is already disabled");
            sender.sendMessage((Component)Component.text("World is already disabled", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleDisable", "already disabled");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: Disabling world '" + world.getName() + "' owned by " + world.getOwnerName());
        pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Disabling world", pairArray2);
        world.setEnabled(false);
        this.dataManager.saveWorld(world);
        sender.sendMessage(((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text(world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' disabled", (TextColor)NamedTextColor.GREEN)));
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
        World defaultWorld = (World)CollectionsKt.firstOrNull(list);
        Pair[] pairArray3 = new Pair[1];
        World world2 = defaultWorld;
        pairArray3[0] = TuplesKt.to("defaultWorld", world2 != null ? world2.getName() : null);
        this.debugLogger.debug("Default world for kick", pairArray3);
        if (defaultWorld != null) {
            this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: Kicking players from disabled world '" + world.getName() + "'");
            for (World.Environment env : EntriesMappings.entries$0) {
                World bukkitWorld;
                World world3 = bukkitWorld = this.worldManager.getBukkitWorld(world, env);
                List<Object> list2 = world3 != null ? world3.getPlayers() : null;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List players = list2;
                Pair[] pairArray4 = new Pair[]{TuplesKt.to("environment", env), TuplesKt.to("playerCount", players.size())};
                this.debugLogger.debug("Players in dimension", pairArray4);
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player player = (Player)element$iv;
                    boolean bl = false;
                    Pair[] pairArray5 = new Pair[]{TuplesKt.to("player", player.getName())};
                    this.debugLogger.debug("Kicking player from disabled world", pairArray5);
                    this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: Teleporting " + player.getName() + " out of disabled world");
                    player.teleportAsync(defaultWorld.getSpawnLocation()).thenAccept(arg_0 -> WorldAdminCommands.handleDisable$lambda$6$lambda$5(new Function1<Boolean, Unit>(player){
                        final /* synthetic */ Player $player;
                        {
                            this.$player = $player;
                            super(1);
                        }

                        public final void invoke(Boolean it) {
                            this.$player.sendMessage((Component)Component.text("World disabled by admin", (TextColor)NamedTextColor.RED));
                        }
                    }, arg_0));
                }
            }
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleDisable: World '" + world.getName() + "' disabled successfully");
        this.debugLogger.debugMethodExit("handleDisable", 1);
        return 1;
    }

    private final int handleEnable(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleEnable", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleEnable: Executing admin enable command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        PlayerWorld world = this.findWorld(ctx);
        if (world == null) {
            this.debugLogger.debugMethodExit("handleEnable", "world not found");
            return 1;
        }
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("isEnabled", world.isEnabled())};
        this.debugLogger.debug("World state", pairArray2);
        if (world.isEnabled()) {
            this.plugin.getLogger().info("[WorldAdminCommands] handleEnable: World '" + world.getName() + "' is already enabled");
            sender.sendMessage((Component)Component.text("World is already enabled", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handleEnable", "already enabled");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleEnable: Enabling world '" + world.getName() + "' owned by " + world.getOwnerName());
        pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName()), TuplesKt.to("worldId", world.getId())};
        this.debugLogger.debug("Enabling world", pairArray2);
        world.setEnabled(true);
        this.dataManager.saveWorld(world);
        pairArray2 = new Pair[]{TuplesKt.to("worldName", world.getName())};
        this.debugLogger.debug("Loading world after enable", pairArray2);
        this.worldManager.loadWorld(world).thenAccept(arg_0 -> WorldAdminCommands.handleEnable$lambda$7(new Function1<Boolean, Unit>(this, world, sender){
            final /* synthetic */ WorldAdminCommands this$0;
            final /* synthetic */ PlayerWorld $world;
            final /* synthetic */ CommandSender $sender;
            {
                this.this$0 = $receiver;
                this.$world = $world;
                this.$sender = $sender;
                super(1);
            }

            public final void invoke(Boolean success) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", this.$world.getName()), TuplesKt.to("success", success)};
                WorldAdminCommands.access$getDebugLogger$p(this.this$0).debug("World load result", pairArray);
                Intrinsics.checkNotNull(success);
                if (success.booleanValue()) {
                    WorldAdminCommands.access$getPlugin$p(this.this$0).getLogger().info("[WorldAdminCommands] handleEnable: World '" + this.$world.getName() + "' enabled and loaded successfully");
                } else {
                    WorldAdminCommands.access$getPlugin$p(this.this$0).getLogger().warning("[WorldAdminCommands] handleEnable: World '" + this.$world.getName() + "' enabled but failed to load");
                }
                this.$sender.sendMessage((Component)(success != false ? (TextComponent)((TextComponent)Component.text("World '", (TextColor)NamedTextColor.GREEN).append(Component.text(this.$world.getName(), (TextColor)NamedTextColor.GOLD))).append(Component.text("' enabled and loaded", (TextColor)NamedTextColor.GREEN)) : Component.text("World enabled but failed to load", (TextColor)NamedTextColor.YELLOW)));
            }
        }, arg_0));
        this.debugLogger.debugMethodExit("handleEnable", 1);
        return 1;
    }

    private final int handleSetLimit(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleSetLimit", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleSetLimit: Executing admin setlimit command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        int limit = IntegerArgumentType.getInteger(ctx, (String)"limit");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("playerName", playerName), TuplesKt.to("limit", limit)};
        this.debugLogger.debug("Parsed arguments", pairArray2);
        this.plugin.getLogger().info("[WorldAdminCommands] handleSetLimit: Setting world limit for '" + playerName + "' to " + limit);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer target = offlinePlayer;
        boolean targetExists = target.hasPlayedBefore() || target.isOnline();
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerName", playerName), TuplesKt.to("uuid", target.getUniqueId()), TuplesKt.to("exists", targetExists)};
        this.debugLogger.debug("Target player lookup", pairArray3);
        if (!targetExists) {
            this.plugin.getLogger().warning("[WorldAdminCommands] handleSetLimit: Player '" + playerName + "' not found");
            sender.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(playerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("handleSetLimit", "player not found");
            return 1;
        }
        UUID uUID = target.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Pair[] pairArray4 = target.getName();
        if (pairArray4 == null) {
            pairArray4 = playerName;
        }
        Pair[] pairArray5 = pairArray4;
        Intrinsics.checkNotNull(pairArray5);
        PlayerData playerData = this.dataManager.getOrCreatePlayerData(uUID, (String)pairArray5);
        pairArray5 = new Pair[]{TuplesKt.to("uuid", playerData.getUuid()), TuplesKt.to("currentLimit", playerData.getWorldLimit())};
        this.debugLogger.debug("Player data before update", pairArray5);
        playerData.setWorldLimit(limit);
        this.dataManager.savePlayerData(playerData);
        pairArray5 = new Pair[]{TuplesKt.to("uuid", playerData.getUuid()), TuplesKt.to("newLimit", playerData.getWorldLimit())};
        this.debugLogger.debug("Player data after update", pairArray5);
        String limitText = limit == -1 ? "unlimited" : String.valueOf(limit);
        Logger logger = this.plugin.getLogger();
        String string = target.getName();
        if (string == null) {
            string = playerName;
        }
        logger.info("[WorldAdminCommands] handleSetLimit: World limit set to " + limitText + " for '" + string + "'");
        TextComponent textComponent = Component.text("Set world limit for ", (TextColor)NamedTextColor.GREEN);
        String string2 = target.getName();
        if (string2 == null) {
            string2 = playerName;
        }
        sender.sendMessage(((TextComponent)((TextComponent)textComponent.append(Component.text(string2, (TextColor)NamedTextColor.GOLD))).append(Component.text(" to ", (TextColor)NamedTextColor.GREEN))).append(Component.text(limitText, (TextColor)NamedTextColor.GOLD)));
        this.debugLogger.debugMethodExit("handleSetLimit", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int handlePurge(CommandContext<CommandSourceStack> ctx) {
        Collection<String> collection;
        void $this$map$iv;
        Pair[] $this$filterTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handlePurge", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handlePurge: Executing admin purge command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        int days = IntegerArgumentType.getInteger(ctx, (String)"days");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("days", days)};
        this.debugLogger.debug("Parsed arguments", pairArray2);
        this.plugin.getLogger().info("[WorldAdminCommands] handlePurge: Purging worlds older than " + days + " days");
        long cutoffTime = System.currentTimeMillis() - (long)(days * 24 * 60 * 60) * 1000L;
        Pair[] $this$filter$iv = (Pair[])this.dataManager.getAllWorlds();
        boolean $i$f$filter232 = false;
        Pair[] pairArray3 = $this$filter$iv;
        Pair[] destination$iv$iv = (Pair[])new ArrayList();
        boolean $i$f$filterTo232 = false;
        for (Object t : $this$filterTo$iv$iv) {
            PlayerWorld it = (PlayerWorld)t;
            boolean bl = false;
            if (!(it.getCreatedAt() < cutoffTime)) continue;
            destination$iv$iv.add(t);
        }
        List worldsToDelete = (List)destination$iv$iv;
        $this$filter$iv = new Pair[]{TuplesKt.to("cutoffTime", cutoffTime), TuplesKt.to("worldCount", worldsToDelete.size())};
        this.debugLogger.debug("Worlds to purge", $this$filter$iv);
        String $i$f$filter232 = sender instanceof Player ? ((Player)sender).getUniqueId().toString() : "console";
        Intrinsics.checkNotNull($i$f$filter232);
        String senderKey = $i$f$filter232;
        PurgeConfirmation existingConfirmation = this.purgeConfirmations.get(senderKey);
        $this$filterTo$iv$iv = new Pair[]{TuplesKt.to("senderKey", senderKey), TuplesKt.to("hasExisting", existingConfirmation != null)};
        this.debugLogger.debug("Confirmation check", $this$filterTo$iv$iv);
        boolean needsConfirmation = existingConfirmation == null || existingConfirmation.getDays() != days || System.currentTimeMillis() - existingConfirmation.getTimestamp() > 30000L;
        destination$iv$iv = new Pair[]{TuplesKt.to("needsConfirmation", needsConfirmation)};
        this.debugLogger.debug("Confirmation status", destination$iv$iv);
        if (needsConfirmation) {
            this.plugin.getLogger().info("[WorldAdminCommands] handlePurge: Requesting confirmation to delete " + worldsToDelete.size() + " world(s)");
            ((Map)this.purgeConfirmations).put(senderKey, new PurgeConfirmation(days, worldsToDelete.size(), System.currentTimeMillis()));
            sender.sendMessage(Component.text("WARNING: ", (TextColor)NamedTextColor.RED).append(Component.text("This will delete " + worldsToDelete.size() + " worlds older than " + days + " days", (TextColor)NamedTextColor.YELLOW)));
            sender.sendMessage((Component)Component.text("Run again within 30 seconds to confirm", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handlePurge", "waiting for confirmation");
            return 1;
        }
        this.purgeConfirmations.remove(senderKey);
        this.debugLogger.debug("Confirmation accepted, proceeding with purge");
        if (worldsToDelete.isEmpty()) {
            this.plugin.getLogger().info("[WorldAdminCommands] handlePurge: No worlds to purge");
            sender.sendMessage((Component)Component.text("No worlds to purge", (TextColor)NamedTextColor.YELLOW));
            this.debugLogger.debugMethodExit("handlePurge", "no worlds to purge");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handlePurge: Starting purge of " + worldsToDelete.size() + " world(s)");
        destination$iv$iv = new Pair[2];
        destination$iv$iv[0] = TuplesKt.to("worldCount", worldsToDelete.size());
        Iterable $i$f$filterTo232 = worldsToDelete;
        String string = "worldNames";
        int n = 1;
        Pair[] pairArray4 = destination$iv$iv;
        String string2 = "Starting purge";
        DebugLogger debugLogger = this.debugLogger;
        boolean $i$f$map = false;
        void var13_18 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : var13_18) {
            void it;
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv2;
        pairArray4[n] = TuplesKt.to(string, collection);
        debugLogger.debug(string2, destination$iv$iv);
        sender.sendMessage((Component)Component.text("Purging " + worldsToDelete.size() + " worlds...", (TextColor)NamedTextColor.YELLOW));
        Ref.IntRef deleted = new Ref.IntRef();
        Ref.IntRef failed = new Ref.IntRef();
        Iterable $this$forEach$iv = worldsToDelete;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerWorld world = (PlayerWorld)element$iv;
            boolean bl2 = false;
            this.worldManager.deleteWorld(world).thenAccept(arg_0 -> WorldAdminCommands.handlePurge$lambda$11$lambda$10(new Function1<Result<? extends Unit>, Unit>(deleted, failed, this, world, (List<PlayerWorld>)worldsToDelete, sender){
                final /* synthetic */ Ref.IntRef $deleted;
                final /* synthetic */ Ref.IntRef $failed;
                final /* synthetic */ WorldAdminCommands this$0;
                final /* synthetic */ PlayerWorld $world;
                final /* synthetic */ List<PlayerWorld> $worldsToDelete;
                final /* synthetic */ CommandSender $sender;
                {
                    this.$deleted = $deleted;
                    this.$failed = $failed;
                    this.this$0 = $receiver;
                    this.$world = $world;
                    this.$worldsToDelete = $worldsToDelete;
                    this.$sender = $sender;
                    super(1);
                }

                public final void invoke(Result<? extends Unit> result) {
                    Intrinsics.checkNotNull(result);
                    if (Result.isSuccess-impl(result.unbox-impl())) {
                        var2_2 = this.$deleted.element;
                        this.$deleted.element = var2_2 + 1;
                    } else {
                        var2_2 = this.$failed.element;
                        this.$failed.element = var2_2 + 1;
                    }
                    Pair[] pairArray = new Pair[]{TuplesKt.to("worldName", this.$world.getName()), TuplesKt.to("success", Result.isSuccess-impl(result.unbox-impl())), TuplesKt.to("deleted", this.$deleted.element), TuplesKt.to("failed", this.$failed.element)};
                    WorldAdminCommands.access$getDebugLogger$p(this.this$0).debug("World purge result", pairArray);
                    if (this.$deleted.element + this.$failed.element == this.$worldsToDelete.size()) {
                        WorldAdminCommands.access$getPlugin$p(this.this$0).getLogger().info("[WorldAdminCommands] handlePurge: Purge complete. Deleted: " + this.$deleted.element + ", Failed: " + this.$failed.element);
                        pairArray = new Pair[]{TuplesKt.to("deleted", this.$deleted.element), TuplesKt.to("failed", this.$failed.element)};
                        WorldAdminCommands.access$getDebugLogger$p(this.this$0).debug("Purge complete", pairArray);
                        this.$sender.sendMessage((Component)Component.text("Purge complete. Deleted: " + this.$deleted.element + ", Failed: " + this.$failed.element, (TextColor)NamedTextColor.GREEN));
                    }
                }
            }, arg_0));
        }
        this.debugLogger.debugMethodExit("handlePurge", 1);
        return 1;
    }

    private final int handleStats(CommandContext<CommandSourceStack> ctx) {
        int n;
        int n2;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleStats", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleStats: Executing admin stats command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
        List<PlayerData> allPlayers = this.dataManager.getAllPlayerData();
        Iterable $this$count$iv = allWorlds;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!it.isEnabled() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int enabledCount = n2;
        Iterable $this$count$iv2 = allWorlds;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!(!it.isEnabled()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int disabledCount = n;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("totalWorlds", allWorlds.size()), TuplesKt.to("enabledCount", enabledCount), TuplesKt.to("disabledCount", disabledCount), TuplesKt.to("playerCount", allPlayers.size())};
        this.debugLogger.debug("Statistics", pairArray2);
        this.plugin.getLogger().info("[WorldAdminCommands] handleStats: Total worlds: " + allWorlds.size() + ", Enabled: " + enabledCount + ", Disabled: " + disabledCount + ", Players: " + allPlayers.size());
        sender.sendMessage((Component)Component.text("=== PlayerWorldManager Statistics ===", (TextColor)NamedTextColor.DARK_PURPLE));
        sender.sendMessage(Component.text("Total Worlds: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(allWorlds.size()), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Enabled: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(enabledCount), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Disabled: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(disabledCount), (TextColor)NamedTextColor.GOLD)));
        sender.sendMessage(Component.text("Players with worlds: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(allPlayers.size()), (TextColor)NamedTextColor.GOLD)));
        this.plugin.getLogger().info("[WorldAdminCommands] handleStats: Command completed successfully");
        this.debugLogger.debugMethodExit("handleStats", 1);
        return 1;
    }

    private final int handleReload(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleReload", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleReload: Executing admin reload command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        try {
            this.plugin.getLogger().info("[WorldAdminCommands] handleReload: Reloading plugin configuration");
            this.debugLogger.debug("Reloading config");
            this.plugin.reloadConfig();
            this.debugLogger.debug("Reloading data manager");
            this.dataManager.loadAll();
            DebugLogger.Companion.refreshDebugState();
            this.debugLogger.debug("Config reload complete");
            this.plugin.getLogger().info("[WorldAdminCommands] handleReload: Configuration reloaded successfully");
            sender.sendMessage((Component)Component.text("Configuration reloaded", (TextColor)NamedTextColor.GREEN));
        }
        catch (Exception e) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("error", e.getMessage())};
            this.debugLogger.debug("Config reload failed", pairArray2);
            this.plugin.getLogger().warning("[WorldAdminCommands] handleReload: Failed to reload configuration: " + e.getMessage());
            TextComponent textComponent = Component.text("Failed to reload: ", (TextColor)NamedTextColor.RED);
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown";
            }
            sender.sendMessage(textComponent.append(Component.text(string, (TextColor)NamedTextColor.GOLD)));
        }
        this.debugLogger.debugMethodExit("handleReload", 1);
        return 1;
    }

    private final int handleMenu(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleMenu", pairArray);
        this.plugin.getLogger().info("[WorldAdminCommands] handleMenu: Executing admin menu command");
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("isPlayer", sender instanceof Player), TuplesKt.to("senderType", sender.getClass().getSimpleName())};
        this.debugLogger.debug("Sender type check", pairArray2);
        if (!(sender instanceof Player)) {
            this.plugin.getLogger().warning("[WorldAdminCommands] handleMenu: Non-player attempted to execute command");
            sender.sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleMenu", "not a player");
            return 1;
        }
        this.plugin.getLogger().info("[WorldAdminCommands] handleMenu: Opening admin menu GUI for " + ((Player)sender).getName());
        pairArray2 = new Pair[]{TuplesKt.to("player", ((Player)sender).getName()), TuplesKt.to("playerUuid", ((Player)sender).getUniqueId())};
        this.debugLogger.debug("Opening admin menu GUI", pairArray2);
        this.adminMenuGui.open((Player)sender);
        this.plugin.getLogger().info("[WorldAdminCommands] handleMenu: Command completed for " + ((Player)sender).getName());
        this.debugLogger.debugMethodExit("handleMenu", 1);
        return 1;
    }

    private final int handleHelp(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleHelp", pairArray);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("senderName", sender.getName())};
        this.debugLogger.debug("Displaying help", pairArray2);
        sender.sendMessage((Component)Component.text("=== World Admin Commands ===", (TextColor)NamedTextColor.DARK_PURPLE));
        sender.sendMessage(Component.text("/worldadmin list [player] [page]", (TextColor)NamedTextColor.GRAY).append(Component.text(" - List worlds", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin info <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - World info", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin tp <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Teleport", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin delete <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Delete", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin disable/enable <owner> <world>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Toggle", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin setlimit <player> <amount>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Set limit", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin purge <days>", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Delete old", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin stats", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Statistics", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin reload", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Reload config", (TextColor)NamedTextColor.YELLOW)));
        sender.sendMessage(Component.text("/worldadmin menu", (TextColor)NamedTextColor.GRAY).append(Component.text(" - Open GUI", (TextColor)NamedTextColor.YELLOW)));
        this.debugLogger.debugMethodExit("handleHelp", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestPlayersWithWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.dataManager.getAllPlayerData();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerData playerData = (PlayerData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((PlayerData)((Object)it)).getUsername());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestOwnerWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String ownerName = StringArgumentType.getString(ctx, (String)"owner");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer owner = offlinePlayer;
        UUID uUID = owner.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((PlayerWorld)((Object)it)).getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(string, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final PlayerWorld findWorld(CommandContext<CommandSourceStack> ctx) {
        Object v2;
        Pair[] pairArray;
        OfflinePlayer owner;
        CommandSender sender;
        String worldName;
        String ownerName;
        block4: {
            void $this$firstOrNull$iv;
            ownerName = StringArgumentType.getString(ctx, (String)"owner");
            worldName = StringArgumentType.getString(ctx, (String)"world");
            sender = ((CommandSourceStack)ctx.getSource()).getSender();
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debugMethodEntry("findWorld", pairArray2);
            this.plugin.getLogger().info("[WorldAdminCommands] findWorld: Looking up world '" + worldName + "' owned by '" + ownerName + "'");
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ownerName);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            owner = offlinePlayer;
            boolean ownerExists = owner.hasPlayedBefore() || owner.isOnline();
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("exists", ownerExists)};
            this.debugLogger.debug("Owner lookup", pairArray3);
            if (!ownerExists) {
                this.plugin.getLogger().warning("[WorldAdminCommands] findWorld: Owner '" + ownerName + "' not found");
                sender.sendMessage(((TextComponent)Component.text("Player '", (TextColor)NamedTextColor.RED).append(Component.text(ownerName, (TextColor)NamedTextColor.GOLD))).append(Component.text("' not found", (TextColor)NamedTextColor.RED)));
                this.debugLogger.debugMethodExit("findWorld", null);
                return null;
            }
            UUID uUID = owner.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            pairArray = (Pair[])this.dataManager.getWorldsByOwner(uUID);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        PlayerWorld world = v2;
        pairArray = new Pair[]{TuplesKt.to("ownerUuid", owner.getUniqueId()), TuplesKt.to("worldName", worldName), TuplesKt.to("found", world != null)};
        this.debugLogger.debug("World lookup", pairArray);
        if (world == null) {
            this.plugin.getLogger().warning("[WorldAdminCommands] findWorld: World '" + worldName + "' not found for owner '" + ownerName + "'");
            sender.sendMessage(((TextComponent)Component.text(ownerName + " doesn't own a world named '", (TextColor)NamedTextColor.RED).append(Component.text(worldName, (TextColor)NamedTextColor.GOLD))).append(Component.text("'", (TextColor)NamedTextColor.RED)));
            this.debugLogger.debugMethodExit("findWorld", null);
        } else {
            this.plugin.getLogger().info("[WorldAdminCommands] findWorld: Found world '" + world.getName() + "' (ID: " + world.getId() + ")");
            this.debugLogger.debugMethodExit("findWorld", world.getName());
        }
        return world;
    }

    private static final boolean build$lambda$0(CommandSourceStack it) {
        return it.getSender().hasPermission("playerworldmanager.admin");
    }

    private static final void handleTeleport$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleDelete$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleDisable$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleEnable$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handlePurge$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ DebugLogger access$getDebugLogger$p(WorldAdminCommands $this) {
        return $this.debugLogger;
    }

    public static final /* synthetic */ JavaPlugin access$getPlugin$p(WorldAdminCommands $this) {
        return $this.plugin;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<World.Environment> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])World.Environment.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Ltech/bedson/playerworldmanager/commands/WorldAdminCommands$PurgeConfirmation;", "", "days", "", "worldCount", "timestamp", "", "(IIJ)V", "getDays", "()I", "getTimestamp", "()J", "getWorldCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "PlayerWorldManager"})
    private static final class PurgeConfirmation {
        private final int days;
        private final int worldCount;
        private final long timestamp;

        public PurgeConfirmation(int days, int worldCount, long timestamp) {
            this.days = days;
            this.worldCount = worldCount;
            this.timestamp = timestamp;
        }

        public final int getDays() {
            return this.days;
        }

        public final int getWorldCount() {
            return this.worldCount;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final int component1() {
            return this.days;
        }

        public final int component2() {
            return this.worldCount;
        }

        public final long component3() {
            return this.timestamp;
        }

        @NotNull
        public final PurgeConfirmation copy(int days, int worldCount, long timestamp) {
            return new PurgeConfirmation(days, worldCount, timestamp);
        }

        public static /* synthetic */ PurgeConfirmation copy$default(PurgeConfirmation purgeConfirmation, int n, int n2, long l, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = purgeConfirmation.days;
            }
            if ((n3 & 2) != 0) {
                n2 = purgeConfirmation.worldCount;
            }
            if ((n3 & 4) != 0) {
                l = purgeConfirmation.timestamp;
            }
            return purgeConfirmation.copy(n, n2, l);
        }

        @NotNull
        public String toString() {
            return "PurgeConfirmation(days=" + this.days + ", worldCount=" + this.worldCount + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.days);
            result = result * 31 + Integer.hashCode(this.worldCount);
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PurgeConfirmation)) {
                return false;
            }
            PurgeConfirmation purgeConfirmation = (PurgeConfirmation)other;
            if (this.days != purgeConfirmation.days) {
                return false;
            }
            if (this.worldCount != purgeConfirmation.worldCount) {
                return false;
            }
            return this.timestamp == purgeConfirmation.timestamp;
        }
    }
}

