/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.gui.WorldStatsGui;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.StatsManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.models.WorldStatistics;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0002J\u0016\u0010#\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0002J\u0016\u0010$\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0002J\u0016\u0010%\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltech/bedson/playerworldmanager/commands/StatsCommands;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "statsManager", "Ltech/bedson/playerworldmanager/managers/StatsManager;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "worldStatsGui", "Ltech/bedson/playerworldmanager/gui/WorldStatsGui;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/StatsManager;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/DataManager;Ltech/bedson/playerworldmanager/gui/WorldStatsGui;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "build", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "displayWorldStats", "", "player", "Lorg/bukkit/entity/Player;", "worldName", "", "stats", "Ltech/bedson/playerworldmanager/models/WorldStatistics;", "formatDuration", "millis", "", "formatNumber", "number", "handleCurrentWorld", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "handleOpenGui", "handleOpenGuiWithWorld", "handleSpecificWorld", "suggestWorlds", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nStatsCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsCommands.kt\ntech/bedson/playerworldmanager/commands/StatsCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n288#2,2:282\n288#2,2:284\n1549#2:286\n1620#2,3:287\n766#2:290\n857#2,2:291\n1855#2,2:293\n*S KotlinDebug\n*F\n+ 1 StatsCommands.kt\ntech/bedson/playerworldmanager/commands/StatsCommands\n*L\n108#1:282,2\n174#1:284,2\n252#1:286\n252#1:287,3\n253#1:290\n253#1:291,2\n254#1:293,2\n*E\n"})
public final class StatsCommands {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final StatsManager statsManager;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final WorldStatsGui worldStatsGui;
    @NotNull
    private final DebugLogger debugLogger;

    public StatsCommands(@NotNull JavaPlugin plugin, @NotNull StatsManager statsManager, @NotNull WorldManager worldManager, @NotNull DataManager dataManager, @NotNull WorldStatsGui worldStatsGui) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(statsManager, "statsManager");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        Intrinsics.checkNotNullParameter(worldStatsGui, "worldStatsGui");
        this.plugin = plugin;
        this.statsManager = statsManager;
        this.worldManager = worldManager;
        this.dataManager = dataManager;
        this.worldStatsGui = worldStatsGui;
        this.debugLogger = new DebugLogger(this.plugin, "StatsCommands");
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> build() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stats").executes(this::handleCurrentWorld)).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestWorlds).executes(this::handleSpecificWorld))).then(((LiteralArgumentBuilder)Commands.literal((String)"gui").then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestWorlds).executes(this::handleOpenGuiWithWorld))).executes(this::handleOpenGui))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final int handleCurrentWorld(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleCurrentWorld", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            return 1;
        }
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        WorldStatistics worldStats = this.statsManager.getWorldStatsByBukkitWorld(world);
        if (worldStats == null) {
            player.sendMessage(((TextComponent)Component.text("You are not in a player world. Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/stats <worldname>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to view specific world stats.", (TextColor)NamedTextColor.YELLOW)));
            return 1;
        }
        World world2 = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world2);
        Object object = playerWorld;
        if (object == null || (object = ((PlayerWorld)object).getName()) == null) {
            object = "Unknown";
        }
        this.displayWorldStats(player, (String)object, worldStats);
        this.debugLogger.debugMethodExit("handleCurrentWorld", 1);
        return 1;
    }

    private final int handleSpecificWorld(CommandContext<CommandSourceStack> ctx) {
        Object v2;
        String worldName;
        Player player;
        block3: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
            this.debugLogger.debugMethodEntry("handleSpecificWorld", pairArray);
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
            if (player == null) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
                return 1;
            }
            worldName = StringArgumentType.getString(ctx, (String)"world");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Looking up world", pairArray2);
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            List<PlayerWorld> ownedWorlds = this.dataManager.getWorldsByOwner(uUID);
            Iterable $this$firstOrNull$iv = ownedWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        PlayerWorld playerWorld = v2;
        if (playerWorld == null) {
            player.sendMessage((Component)Component.text("World '" + worldName + "' not found or you don't own it.", (TextColor)NamedTextColor.RED));
            return 1;
        }
        WorldStatistics worldStats = this.statsManager.getWorldStats(playerWorld.getId());
        this.displayWorldStats(player, playerWorld.getName(), worldStats);
        this.debugLogger.debugMethodExit("handleSpecificWorld", 1);
        return 1;
    }

    private final int handleOpenGui(CommandContext<CommandSourceStack> ctx) {
        Player player;
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleOpenGui", pairArray);
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            return 1;
        }
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(world);
        if (playerWorld == null) {
            player.sendMessage(((TextComponent)Component.text("You are not in a player world. Use ", (TextColor)NamedTextColor.YELLOW).append(Component.text("/stats gui <worldname>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to view specific world stats.", (TextColor)NamedTextColor.YELLOW)));
            return 1;
        }
        this.worldStatsGui.open(player, playerWorld);
        this.debugLogger.debugMethodExit("handleOpenGui", 1);
        return 1;
    }

    private final int handleOpenGuiWithWorld(CommandContext<CommandSourceStack> ctx) {
        Object v2;
        String worldName;
        Player player;
        block3: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
            this.debugLogger.debugMethodEntry("handleOpenGuiWithWorld", pairArray);
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Player player2 = player = commandSender instanceof Player ? (Player)commandSender : null;
            if (player == null) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
                return 1;
            }
            worldName = StringArgumentType.getString(ctx, (String)"world");
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("worldName", worldName)};
            this.debugLogger.debug("Looking up world", pairArray2);
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            List<PlayerWorld> ownedWorlds = this.dataManager.getWorldsByOwner(uUID);
            Iterable $this$firstOrNull$iv = ownedWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld it = (PlayerWorld)element$iv;
                boolean bl = false;
                if (!StringsKt.equals(it.getName(), worldName, true)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        PlayerWorld playerWorld = v2;
        if (playerWorld == null) {
            player.sendMessage((Component)Component.text("World '" + worldName + "' not found or you don't own it.", (TextColor)NamedTextColor.RED));
            return 1;
        }
        this.worldStatsGui.open(player, playerWorld);
        this.debugLogger.debugMethodExit("handleOpenGuiWithWorld", 1);
        return 1;
    }

    private final void displayWorldStats(Player player, String worldName, WorldStatistics stats) {
        player.sendMessage((Component)Component.empty());
        player.sendMessage(((TextComponent)Component.text("=== Statistics for ", (TextColor)NamedTextColor.GOLD).append(Component.text(worldName, (TextColor)NamedTextColor.YELLOW))).append(Component.text(" ===", (TextColor)NamedTextColor.GOLD)));
        player.sendMessage((Component)Component.empty());
        player.sendMessage(Component.text("  Blocks Placed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getBlocksPlaced()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Blocks Broken: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getBlocksBroken()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Mobs Killed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getMobsKilled()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Animals Killed: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getAnimalsKilled()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Player Kills: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getPlayerKills()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Player Deaths: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getPlayerDeaths()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Items Crafted: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatNumber(stats.getItemsCrafted()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("  Time Played: ", (TextColor)NamedTextColor.GRAY).append(Component.text(this.formatDuration(stats.getTimePlayed()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage((Component)Component.empty());
        player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.GRAY).append(Component.text("/stats gui", (TextColor)NamedTextColor.GOLD))).append(Component.text(" for a detailed view", (TextColor)NamedTextColor.GRAY)));
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestWorlds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        if (player == null) {
            CompletableFuture completableFuture = builder.buildFuture();
            Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
            return completableFuture;
        }
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Iterable iterable = this.dataManager.getWorldsByOwner(uUID);
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerWorld playerWorld = (PlayerWorld)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((PlayerWorld)((Object)it)).getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            builder.suggest(it2);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final String formatNumber(long number) {
        String string = "%,d";
        Object[] objectArray = new Object[]{number};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private final String formatDuration(long millis) {
        if (millis == 0L) {
            return "0 minutes";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % (long)60;
        return hours > 0L ? hours + " hours, " + minutes + " minutes" : minutes + " minutes";
    }
}

