/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.ChatManager;
import tech.bedson.playerworldmanager.models.ChatMode;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltech/bedson/playerworldmanager/commands/ChatCommands;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "chatManager", "Ltech/bedson/playerworldmanager/managers/ChatManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/ChatManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "build", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "handleSetMode", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "handleShowMode", "suggestChatModes", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nChatCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCommands.kt\ntech/bedson/playerworldmanager/commands/ChatCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n766#2:151\n857#2,2:152\n1855#2,2:154\n*S KotlinDebug\n*F\n+ 1 ChatCommands.kt\ntech/bedson/playerworldmanager/commands/ChatCommands\n*L\n145#1:151\n145#1:152,2\n146#1:154,2\n*E\n"})
public final class ChatCommands {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final ChatManager chatManager;
    @NotNull
    private final DebugLogger debugLogger;

    public ChatCommands(@NotNull JavaPlugin plugin, @NotNull ChatManager chatManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(chatManager, "chatManager");
        this.plugin = plugin;
        this.chatManager = chatManager;
        this.debugLogger = new DebugLogger(this.plugin, "ChatCommands");
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> build() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chat").then(Commands.argument((String)"mode", (ArgumentType)((ArgumentType)StringArgumentType.word())).suggests(this::suggestChatModes).executes(this::handleSetMode))).executes(this::handleShowMode)).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final int handleShowMode(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleShowMode", pairArray);
        this.plugin.getLogger().info("[ChatCommands] handleShowMode: Executing chat show mode command");
        Pair[] pairArray2 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray2 instanceof Player ? (Player)pairArray2 : null;
        pairArray2 = new Pair[2];
        pairArray2[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray2[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray2);
        if (player == null) {
            this.plugin.getLogger().warning("[ChatCommands] handleShowMode: Non-player attempted to execute command");
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleShowMode", "player-only error");
            return 1;
        }
        this.plugin.getLogger().info("[ChatCommands] handleShowMode: Player " + player.getName() + " checking current chat mode");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        ChatMode currentMode = this.chatManager.getChatMode(uUID);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("mode", currentMode)};
        this.debugLogger.debug("Current chat mode", pairArray3);
        this.plugin.getLogger().info("[ChatCommands] handleShowMode: Player " + player.getName() + " current mode is " + currentMode);
        player.sendMessage(Component.text("Your current chat mode is: ", (TextColor)NamedTextColor.YELLOW).append(Component.text(currentMode.name(), (TextColor)NamedTextColor.GOLD)));
        player.sendMessage(((TextComponent)Component.text("Use ", (TextColor)NamedTextColor.GRAY).append(Component.text("/chat <global|world>", (TextColor)NamedTextColor.GOLD))).append(Component.text(" to change modes", (TextColor)NamedTextColor.GRAY)));
        this.plugin.getLogger().info("[ChatCommands] handleShowMode: Command completed successfully for " + player.getName());
        this.debugLogger.debugMethodExit("handleShowMode", 1);
        return 1;
    }

    private final int handleSetMode(CommandContext<CommandSourceStack> ctx) {
        Pair[] pairArray;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("sender", ((CommandSourceStack)ctx.getSource()).getSender().getName())};
        this.debugLogger.debugMethodEntry("handleSetMode", pairArray2);
        this.plugin.getLogger().info("[ChatCommands] handleSetMode: Executing chat set mode command");
        Pair[] pairArray3 = ((CommandSourceStack)ctx.getSource()).getSender();
        Player player = pairArray3 instanceof Player ? (Player)pairArray3 : null;
        pairArray3 = new Pair[2];
        pairArray3[0] = TuplesKt.to("isPlayer", player != null);
        Player player2 = player;
        pairArray3[1] = TuplesKt.to("playerName", player2 != null ? player2.getName() : null);
        this.debugLogger.debug("Player check", pairArray3);
        if (player == null) {
            this.plugin.getLogger().warning("[ChatCommands] handleSetMode: Non-player attempted to execute command");
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text("This command can only be used by players", (TextColor)NamedTextColor.RED));
            this.debugLogger.debugMethodExit("handleSetMode", "player-only error");
            return 1;
        }
        String string = StringArgumentType.getString(ctx, (String)"mode");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String modeString = string2;
        Pair[] pairArray4 = new Pair[]{TuplesKt.to("modeString", modeString)};
        this.debugLogger.debug("Parsed arguments", pairArray4);
        this.plugin.getLogger().info("[ChatCommands] handleSetMode: Player " + player.getName() + " attempting to set mode to '" + modeString + "'");
        try {
            pairArray = ChatMode.valueOf(modeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Pair[] pairArray5 = new Pair[]{TuplesKt.to("modeString", modeString)};
            this.debugLogger.debug("Invalid chat mode", pairArray5);
            this.plugin.getLogger().warning("[ChatCommands] handleSetMode: Player " + player.getName() + " provided invalid mode '" + modeString + "'");
            player.sendMessage(Component.text("Invalid chat mode. Valid modes: ", (TextColor)NamedTextColor.RED).append(Component.text("global, world", (TextColor)NamedTextColor.GOLD)));
            this.debugLogger.debugMethodExit("handleSetMode", "invalid mode");
            return 1;
        }
        Pair[] mode = pairArray;
        pairArray = new Pair[]{TuplesKt.to("modeString", modeString), TuplesKt.to("mode", mode)};
        this.debugLogger.debug("Parsed chat mode", pairArray);
        this.plugin.getLogger().info("[ChatCommands] handleSetMode: Setting chat mode for " + player.getName() + " to " + (ChatMode)mode);
        pairArray = new Pair[]{TuplesKt.to("playerUuid", player.getUniqueId()), TuplesKt.to("mode", mode)};
        this.debugLogger.debug("Calling chatManager.setChatMode", pairArray);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.chatManager.setChatMode(uUID, (ChatMode)mode);
        player.sendMessage(Component.text("Chat mode set to ", (TextColor)NamedTextColor.GREEN).append(Component.text(mode.name(), (TextColor)NamedTextColor.GOLD)));
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                Pair[] pairArray6 = new Pair[]{TuplesKt.to("mode", "GLOBAL"), TuplesKt.to("description", "visible to all players")};
                this.debugLogger.debug("Mode description", pairArray6);
                this.plugin.getLogger().info("[ChatCommands] handleSetMode: Player " + player.getName() + " set to GLOBAL mode");
                player.sendMessage((Component)Component.text("Your messages will be visible to all players in global chat", (TextColor)NamedTextColor.GRAY));
                break;
            }
            case 2: {
                Pair[] pairArray7 = new Pair[]{TuplesKt.to("mode", "WORLD"), TuplesKt.to("description", "visible to world players only")};
                this.debugLogger.debug("Mode description", pairArray7);
                this.plugin.getLogger().info("[ChatCommands] handleSetMode: Player " + player.getName() + " set to WORLD mode");
                player.sendMessage((Component)Component.text("Your messages will only be visible to players in your current world", (TextColor)NamedTextColor.GRAY));
            }
        }
        this.plugin.getLogger().info("[ChatCommands] handleSetMode: Command completed successfully for " + player.getName());
        this.debugLogger.debugMethodExit("handleSetMode", 1);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<Suggestions> suggestChatModes(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"global", "world"};
        Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = builder.getRemainingLowerCase();
            Intrinsics.checkNotNullExpressionValue(string, "getRemainingLowerCase(...)");
            if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.suggest(it);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatMode.values().length];
            try {
                nArray[ChatMode.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatMode.WORLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

