/*
 * Decompiled with CFR 0.152.
 */
package tech.bedson.playerworldmanager;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.bedson.playerworldmanager.libs.kotlin.Metadata;
import tech.bedson.playerworldmanager.libs.kotlin.Pair;
import tech.bedson.playerworldmanager.libs.kotlin.TuplesKt;
import tech.bedson.playerworldmanager.libs.kotlin.collections.CollectionsKt;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.Intrinsics;
import tech.bedson.playerworldmanager.libs.kotlin.jvm.internal.SourceDebugExtension;
import tech.bedson.playerworldmanager.libs.kotlin.text.StringsKt;
import tech.bedson.playerworldmanager.managers.DataManager;
import tech.bedson.playerworldmanager.managers.InviteManager;
import tech.bedson.playerworldmanager.managers.WorldManager;
import tech.bedson.playerworldmanager.models.PlayerData;
import tech.bedson.playerworldmanager.models.PlayerWorld;
import tech.bedson.playerworldmanager.utils.DebugLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/bedson/playerworldmanager/PWMPlaceholderExpansion;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "worldManager", "Ltech/bedson/playerworldmanager/managers/WorldManager;", "inviteManager", "Ltech/bedson/playerworldmanager/managers/InviteManager;", "dataManager", "Ltech/bedson/playerworldmanager/managers/DataManager;", "(Lorg/bukkit/plugin/java/JavaPlugin;Ltech/bedson/playerworldmanager/managers/WorldManager;Ltech/bedson/playerworldmanager/managers/InviteManager;Ltech/bedson/playerworldmanager/managers/DataManager;)V", "debugLogger", "Ltech/bedson/playerworldmanager/utils/DebugLogger;", "findWorldByFullName", "Ltech/bedson/playerworldmanager/models/PlayerWorld;", "fullName", "", "findWorldByOwnerAndName", "ownerName", "worldName", "getAuthor", "getIdentifier", "getVersion", "onRequest", "player", "Lorg/bukkit/OfflinePlayer;", "params", "persist", "", "PlayerWorldManager"})
@SourceDebugExtension(value={"SMAP\nPWMPlaceholderExpansion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PWMPlaceholderExpansion.kt\ntech/bedson/playerworldmanager/PWMPlaceholderExpansion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1#2:240\n1774#3,4:241\n288#3,2:245\n288#3,2:247\n*S KotlinDebug\n*F\n+ 1 PWMPlaceholderExpansion.kt\ntech/bedson/playerworldmanager/PWMPlaceholderExpansion\n*L\n165#1:241,4\n217#1:245,2\n231#1:247,2\n*E\n"})
public final class PWMPlaceholderExpansion
extends PlaceholderExpansion {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final WorldManager worldManager;
    @NotNull
    private final InviteManager inviteManager;
    @NotNull
    private final DataManager dataManager;
    @NotNull
    private final DebugLogger debugLogger;

    public PWMPlaceholderExpansion(@NotNull JavaPlugin plugin, @NotNull WorldManager worldManager, @NotNull InviteManager inviteManager, @NotNull DataManager dataManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(worldManager, "worldManager");
        Intrinsics.checkNotNullParameter(inviteManager, "inviteManager");
        Intrinsics.checkNotNullParameter(dataManager, "dataManager");
        this.plugin = plugin;
        this.worldManager = worldManager;
        this.inviteManager = inviteManager;
        this.dataManager = dataManager;
        this.debugLogger = new DebugLogger(this.plugin, "PWMPlaceholderExpansion");
        Pair[] pairArray = new Pair[]{TuplesKt.to("identifier", "pwm"), TuplesKt.to("version", this.plugin.getPluginMeta().getVersion())};
        this.debugLogger.debug("PWMPlaceholderExpansion initialized", pairArray);
    }

    @NotNull
    public String getIdentifier() {
        return "pwm";
    }

    @NotNull
    public String getAuthor() {
        return "prorickey";
    }

    @NotNull
    public String getVersion() {
        String string = this.plugin.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        return string;
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        Object object;
        Intrinsics.checkNotNullParameter(params, "params");
        Object object2 = new Pair[2];
        OfflinePlayer offlinePlayer = player;
        object2[0] = TuplesKt.to("player", offlinePlayer != null ? offlinePlayer.getName() : null);
        object2[1] = TuplesKt.to("params", params);
        this.debugLogger.debugMethodEntry("onRequest", (Pair<String, ? extends Object>)object2);
        object2 = params;
        if (Intrinsics.areEqual(object2, "total_worlds")) {
            String result = String.valueOf(this.dataManager.getAllWorlds().size());
            this.debugLogger.debugMethodExit("onRequest", result);
            return result;
        }
        if (Intrinsics.areEqual(object2, "total_players")) {
            String result = String.valueOf(this.dataManager.getAllPlayerData().size());
            this.debugLogger.debugMethodExit("onRequest", result);
            return result;
        }
        if (player == null || !player.isOnline()) {
            Object object3;
            this.debugLogger.debug("Player is null or offline, handling limited placeholders");
            if (StringsKt.startsWith$default(params, "world_", false, 2, null) && StringsKt.endsWith$default(params, "_players", false, 2, null)) {
                String worldName = StringsKt.removeSuffix(StringsKt.removePrefix(params, (CharSequence)"world_"), (CharSequence)"_players");
                world = this.findWorldByFullName(worldName);
                if (world != null) {
                    World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, (PlayerWorld)world, null, 2, null);
                    object3 = bukkitWorld;
                    if (object3 == null || (object3 = object3.getPlayers()) == null || (object3 = Integer.valueOf(object3.size()).toString()) == null) {
                        object3 = "0";
                    }
                } else {
                    object3 = "0";
                }
            } else if (StringsKt.startsWith$default(params, "online_players_", false, 2, null)) {
                world = new String[]{"_"};
                List parts = StringsKt.split$default((CharSequence)StringsKt.removePrefix(params, (CharSequence)"online_players_"), world, false, 2, 2, null);
                if (parts.size() == 2) {
                    String worldName;
                    String ownerName = (String)parts.get(0);
                    PlayerWorld world = this.findWorldByOwnerAndName(ownerName, worldName = (String)parts.get(1));
                    if (world != null) {
                        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world, null, 2, null);
                        object3 = bukkitWorld;
                        if (object3 == null || (object3 = object3.getPlayers()) == null || (object3 = Integer.valueOf(object3.size()).toString()) == null) {
                            object3 = "0";
                        }
                    } else {
                        object3 = "0";
                    }
                } else {
                    object3 = "0";
                }
            } else {
                object3 = "N/A";
            }
            String result = object3;
            this.debugLogger.debugMethodExit("onRequest", result);
            return result;
        }
        Player parts = player.getPlayer();
        if (parts == null) {
            PWMPlaceholderExpansion $this$onRequest_u24lambda_u240 = this;
            boolean bl = false;
            $this$onRequest_u24lambda_u240.debugLogger.debugMethodExit("onRequest", "N/A (player.player is null)");
            return "N/A";
        }
        Player onlinePlayer = parts;
        World world = onlinePlayer.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World currentWorld = world;
        PlayerWorld playerWorld = this.worldManager.getPlayerWorldFromBukkitWorld(currentWorld);
        Pair[] $this$onRequest_u24lambda_u240 = new Pair[]{TuplesKt.to("world", currentWorld.getName()), TuplesKt.to("isPlayerWorld", playerWorld != null)};
        this.debugLogger.debug("Processing placeholder for online player", $this$onRequest_u24lambda_u240);
        switch (params) {
            case "world": {
                object = playerWorld;
                if (object != null) {
                    Object it = object;
                    boolean bl = false;
                    String string = (((PlayerWorld)it).getOwnerName() + "_" + ((PlayerWorld)it).getName()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    object = string;
                    if (string != null) break;
                }
                object = "N/A";
                break;
            }
            case "world_display": {
                object = playerWorld;
                if (object != null && (object = ((PlayerWorld)object).getName()) != null) break;
                object = "N/A";
                break;
            }
            case "world_owner": {
                object = playerWorld;
                if (object != null && (object = ((PlayerWorld)object).getOwnerName()) != null) break;
                object = "N/A";
                break;
            }
            case "world_type": {
                object = playerWorld;
                if (object != null && (object = ((PlayerWorld)object).getWorldType()) != null && (object = ((Enum)object).name()) != null) break;
                object = "N/A";
                break;
            }
            case "world_environment": {
                if (playerWorld != null) {
                    object = currentWorld.getEnvironment().name();
                    break;
                }
                object = "N/A";
                break;
            }
            case "world_players": {
                if (playerWorld != null) {
                    object = String.valueOf(currentWorld.getPlayers().size());
                    break;
                }
                object = "0";
                break;
            }
            case "is_owner": {
                if (playerWorld != null) {
                    object = String.valueOf(Intrinsics.areEqual(playerWorld.getOwnerUuid(), onlinePlayer.getUniqueId()));
                    break;
                }
                object = "false";
                break;
            }
            case "can_build": {
                if (playerWorld != null) {
                    UUID uUID = onlinePlayer.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    object = String.valueOf(this.inviteManager.hasAccess(uUID, playerWorld));
                    break;
                }
                object = "false";
                break;
            }
            case "is_invited": {
                if (playerWorld != null) {
                    UUID uUID = onlinePlayer.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    object = String.valueOf(this.inviteManager.isInvited(uUID, playerWorld) && !Intrinsics.areEqual(playerWorld.getOwnerUuid(), onlinePlayer.getUniqueId()));
                    break;
                }
                object = "false";
                break;
            }
            case "owned_worlds": {
                UUID uUID = onlinePlayer.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                object = String.valueOf(this.dataManager.getWorldsByOwner(uUID).size());
                break;
            }
            case "world_limit": {
                PlayerData playerData;
                UUID uUID = onlinePlayer.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                PlayerData playerData2 = playerData = this.dataManager.loadPlayerData(uUID);
                object = String.valueOf(playerData2 != null ? playerData2.getWorldLimit() : 3);
                break;
            }
            case "invited_to": {
                int n;
                Iterable $this$count$iv = this.dataManager.getAllWorlds();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        PlayerWorld world2 = (PlayerWorld)element$iv;
                        boolean bl = false;
                        UUID uUID = onlinePlayer.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                        if (!this.inviteManager.isInvited(uUID, world2) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int invitedCount = n;
                object = String.valueOf(invitedCount);
                break;
            }
            default: {
                Object world3;
                if (StringsKt.startsWith$default(params, "world_", false, 2, null) && StringsKt.endsWith$default(params, "_players", false, 2, null)) {
                    String worldName = StringsKt.removeSuffix(StringsKt.removePrefix(params, (CharSequence)"world_"), (CharSequence)"_players");
                    world3 = this.findWorldByFullName(worldName);
                    if (world3 != null) {
                        World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, (PlayerWorld)world3, null, 2, null);
                        object = bukkitWorld;
                        if (object != null && (object = object.getPlayers()) != null && (object = Integer.valueOf(object.size()).toString()) != null) break;
                        object = "0";
                        break;
                    }
                    object = "0";
                    break;
                }
                if (StringsKt.startsWith$default(params, "online_players_", false, 2, null)) {
                    world3 = new String[]{"_"};
                    List parts2 = StringsKt.split$default((CharSequence)StringsKt.removePrefix(params, (CharSequence)"online_players_"), world3, false, 2, 2, null);
                    if (parts2.size() == 2) {
                        String worldName;
                        String ownerName = (String)parts2.get(0);
                        PlayerWorld world4 = this.findWorldByOwnerAndName(ownerName, worldName = (String)parts2.get(1));
                        if (world4 != null) {
                            World bukkitWorld = WorldManager.getBukkitWorld$default(this.worldManager, world4, null, 2, null);
                            object = bukkitWorld;
                            if (object != null && (object = object.getPlayers()) != null && (object = Integer.valueOf(object.size()).toString()) != null) break;
                            object = "0";
                            break;
                        }
                        object = "0";
                        break;
                    }
                    object = "0";
                    break;
                }
                object = null;
            }
        }
        Object result = object;
        this.debugLogger.debugMethodExit("onRequest", result);
        return result;
    }

    private final PlayerWorld findWorldByFullName(String fullName) {
        PlayerWorld result;
        Object object;
        Object v2;
        block2: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("fullName", fullName)};
            this.debugLogger.debugMethodEntry("findWorldByFullName", pairArray);
            List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
            Iterable $this$firstOrNull$iv = allWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld world = (PlayerWorld)element$iv;
                boolean bl = false;
                String string = (world.getOwnerName() + "_" + world.getName()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                String expectedName = StringsKt.replace$default(string, " ", "_", false, 4, null);
                String string2 = fullName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (!Intrinsics.areEqual(expectedName, string2)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        if ((object = (result = (PlayerWorld)v2)) == null || (object = ((PlayerWorld)object).getName()) == null) {
            object = "null";
        }
        this.debugLogger.debugMethodExit("findWorldByFullName", object);
        return result;
    }

    private final PlayerWorld findWorldByOwnerAndName(String ownerName, String worldName) {
        PlayerWorld result;
        Object object;
        Object v1;
        block2: {
            Pair[] pairArray = new Pair[]{TuplesKt.to("ownerName", ownerName), TuplesKt.to("worldName", worldName)};
            this.debugLogger.debugMethodEntry("findWorldByOwnerAndName", pairArray);
            List<PlayerWorld> allWorlds = this.dataManager.getAllWorlds();
            Iterable $this$firstOrNull$iv = allWorlds;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PlayerWorld world = (PlayerWorld)element$iv;
                boolean bl = false;
                boolean bl2 = StringsKt.equals(world.getOwnerName(), ownerName, true) && StringsKt.equals(world.getName(), worldName, true);
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((object = (result = (PlayerWorld)v1)) == null || (object = ((PlayerWorld)object).getName()) == null) {
            object = "null";
        }
        this.debugLogger.debugMethodExit("findWorldByOwnerAndName", object);
        return result;
    }
}

