/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.scheduler;

import de.peachbiscuit174.peachlib.PeachLib;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LibraryScheduler {
    private static boolean instantiated = false;
    private final Plugin libraryOwner;
    private final ThreadPoolExecutor asyncExecutor;
    private final ScheduledExecutorService timerService;
    private final Queue<Runnable> syncQueue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final BukkitTask syncTask;
    private static final long MAX_TICK_BUDGET_NANOS = 25000000L;
    private static final long MAX_SHUTDOWN_SYNC_TIME_NANOS = 10000000000L;

    @ApiStatus.Internal
    public LibraryScheduler(@NotNull Plugin libraryOwner) {
        if (instantiated) {
            throw new IllegalStateException("LibraryScheduler has already been instantiated! Use API.getSchedulerManager().getScheduler() instead of creating a new one.");
        }
        if (libraryOwner != PeachLib.getPlugin()) {
            throw new IllegalStateException("Only the PeachLib Plugin can initialize this!");
        }
        this.libraryOwner = libraryOwner;
        instantiated = true;
        ThreadFactory asyncFactory = new ThreadFactory(this){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "PPL-Async-" + this.counter.getAndIncrement());
            }
        };
        this.asyncExecutor = new ThreadPoolExecutor(2, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), asyncFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.timerService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "PPL-Timer"));
        this.syncTask = Bukkit.getScheduler().runTaskTimer(libraryOwner, () -> this.processSyncQueue(25000000L), 1L, 1L);
    }

    public void runSync(@NotNull Runnable runnable) {
        if (!this.isShutdown.get()) {
            this.syncQueue.add(runnable);
        }
    }

    public void runAsync(@NotNull Runnable runnable) {
        if (!this.isShutdown.get()) {
            this.asyncExecutor.execute(runnable);
        }
    }

    public ScheduledFuture<?> runSyncDelayed(Runnable runnable, long delay, TimeUnit unit) {
        if (this.isShutdown.get()) {
            return null;
        }
        return this.timerService.schedule(() -> this.runSync(runnable), delay, unit);
    }

    public ScheduledFuture<?> runAsyncDelayed(Runnable runnable, long delay, TimeUnit unit) {
        if (this.isShutdown.get()) {
            return null;
        }
        return this.timerService.schedule(() -> this.runAsync(runnable), delay, unit);
    }

    public ScheduledFuture<?> runSyncRepeating(Runnable runnable, long delay, long period, TimeUnit unit) {
        if (this.isShutdown.get()) {
            return null;
        }
        return this.timerService.scheduleAtFixedRate(() -> this.runSync(runnable), delay, period, unit);
    }

    public ScheduledFuture<?> runAsyncRepeating(Runnable runnable, long delay, long period, TimeUnit unit) {
        if (this.isShutdown.get()) {
            return null;
        }
        return this.timerService.scheduleAtFixedRate(() -> this.runAsync(runnable), delay, period, unit);
    }

    public void runSafe(@NotNull UUID uuid, @NotNull Consumer<Player> task) {
        this.runSync(() -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null && player.isOnline()) {
                task.accept(player);
            }
        });
    }

    private void processSyncQueue(long maxBudgetNanos) {
        Runnable task;
        if (this.syncQueue.isEmpty()) {
            return;
        }
        long startTime = System.nanoTime();
        while ((task = this.syncQueue.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                this.libraryOwner.getLogger().severe("Error in PPL Sync Task: " + e.getMessage());
                e.printStackTrace();
            }
            if (System.nanoTime() - startTime <= maxBudgetNanos) continue;
            if (this.syncQueue.size() <= 1000 && maxBudgetNanos <= 1000000000L) break;
            this.libraryOwner.getLogger().warning("PPL Sync Queue budget exceeded! Stopped processing. Pending: " + this.syncQueue.size());
            break;
        }
    }

    public void shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        if (this.syncTask != null && !this.syncTask.isCancelled()) {
            this.syncTask.cancel();
        }
        this.timerService.shutdown();
        this.asyncExecutor.shutdown();
        try {
            if (!this.timerService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.timerService.shutdownNow();
            }
            if (!this.asyncExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.asyncExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.timerService.shutdownNow();
            this.asyncExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.processSyncQueue(10000000000L);
        instantiated = false;
    }
}

