/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.gui;

import de.peachbiscuit174.peachlib.gui.GUIButton;
import de.peachbiscuit174.peachlib.items.ItemBuilder;
import de.peachbiscuit174.peachlib.items.ItemTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final Map<Integer, GUIButton> slotMap = new HashMap<Integer, GUIButton>();
    private final Map<String, GUIButton> idMap = new HashMap<String, GUIButton>();
    private static final MiniMessage MM = MiniMessage.miniMessage();
    private String[] shape;
    private final Map<Character, GUIButton> charMapping = new HashMap<Character, GUIButton>();
    public static final String PROTECTED_TAG = "gui_protected_pl";
    public static final String GUI_ID_TAG = "gui_action_id_pl";

    public InventoryGUI(int rows, String titleMiniMessage) {
        int finalRows = Math.max(1, Math.min(6, rows));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(finalRows * 9), (Component)MM.deserialize((Object)titleMiniMessage));
    }

    public InventoryGUI setButton(int slot, @NotNull GUIButton button) {
        this.slotMap.put(slot, button);
        this.idMap.put(button.getActionId(), button);
        this.updateSlot(slot);
        return this;
    }

    public InventoryGUI removeButton(int slot) {
        GUIButton btn = this.slotMap.remove(slot);
        if (btn != null) {
            this.idMap.remove(btn.getActionId());
            this.inventory.setItem(slot, null);
        }
        return this;
    }

    public InventoryGUI moveButton(int fromSlot, int toSlot) {
        GUIButton button = this.slotMap.get(fromSlot);
        if (button != null) {
            this.slotMap.remove(fromSlot);
            this.inventory.setItem(fromSlot, null);
            this.setButton(toSlot, button);
        }
        return this;
    }

    @Nullable
    public GUIButton getButtonWithID(@NotNull String actionId) {
        return this.idMap.get(actionId);
    }

    public Collection<GUIButton> getAllButtonsFromIdMap() {
        return this.idMap.values();
    }

    public InventoryGUI updateSlot(int slot) {
        GUIButton button = this.slotMap.get(slot);
        if (button != null) {
            ItemStack itemStack = button.getItemBuilder().build();
            ItemTag.setItemTag(itemStack, PROTECTED_TAG);
            ItemTag.setItemStringTag(itemStack, GUI_ID_TAG, button.getActionId());
            this.inventory.setItem(slot, itemStack);
        }
        return this;
    }

    public InventoryGUI setPlaceholder(int slot, @NotNull ItemBuilder builder, @NotNull String id) {
        this.setButton(slot, new GUIButton(builder, id, null));
        return this;
    }

    public InventoryGUI fillEmptySlots(@NotNull ItemBuilder builder, @NotNull String id) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.setPlaceholder(i, builder.copy(), id);
        }
        return this;
    }

    public InventoryGUI shape(String ... rows) {
        this.shape = rows;
        this.applyShape();
        return this;
    }

    public InventoryGUI map(char key, GUIButton button) {
        this.charMapping.put(Character.valueOf(key), button);
        this.applyShape();
        return this;
    }

    public InventoryGUI mapPlaceholder(char key, @NotNull ItemBuilder builder, @NotNull String id) {
        this.charMapping.put(Character.valueOf(key), new GUIButton(builder, id, null));
        this.applyShape();
        return this;
    }

    private void applyShape() {
        if (this.shape == null || this.shape.length == 0) {
            return;
        }
        int maxRowsInInv = this.inventory.getSize() / 9;
        for (int row = 0; row < Math.min(maxRowsInInv, this.shape.length); ++row) {
            String rowString = this.shape[row];
            for (int col = 0; col < Math.min(9, rowString.length()); ++col) {
                char c = rowString.charAt(col);
                if (!this.charMapping.containsKey(Character.valueOf(c))) continue;
                int slot = row * 9 + col;
                this.setButton(slot, this.charMapping.get(Character.valueOf(c)));
            }
        }
    }

    public void open(@NotNull Player player) {
        player.openInventory(this.inventory);
    }

    public Map<Integer, GUIButton> getButtons() {
        return this.slotMap;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

