/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.gui;

import de.peachbiscuit174.peachlib.api.player.PlayerManagerAPI;
import de.peachbiscuit174.peachlib.gui.GUIButton;
import de.peachbiscuit174.peachlib.gui.InventoryGUI;
import de.peachbiscuit174.peachlib.items.ItemTag;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GUIListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        if (ItemTag.isItemTag(clickedItem, "gui_protected_pl")) {
            event.setCancelled(true);
        }
        if ((inventoryHolder = event.getInventory().getHolder()) instanceof InventoryGUI) {
            GUIButton button;
            InventoryGUI gui = (InventoryGUI)inventoryHolder;
            String actionID = ItemTag.getItemStringTag(clickedItem, "gui_action_id_pl");
            if (actionID != null && (button = gui.getButtonWithID(actionID)) != null) {
                if (button.isGiveToPlayerOnClick()) {
                    PlayerManagerAPI api = new PlayerManagerAPI(player);
                    ItemStack cleanItem = button.getItemBuilder().build();
                    api.giveOrDropItem(cleanItem);
                }
                button.onClick(event);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Object object = event.getInventory().getHolder();
        if (!(object instanceof InventoryGUI)) {
            return;
        }
        InventoryGUI gui = (InventoryGUI)object;
        object = event.getRawSlots().iterator();
        while (object.hasNext()) {
            int rawSlot = (Integer)object.next();
            if (rawSlot >= event.getInventory().getSize()) continue;
            event.setCancelled(true);
            break;
        }
    }
}

