/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.items;

import de.peachbiscuit174.peachlib.PeachLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemTag {
    private static final Plugin plugin = PeachLib.getPlugin();
    private static final Map<String, NamespacedKey> keyCache = new ConcurrentHashMap<String, NamespacedKey>();

    private static NamespacedKey getKey(String key) {
        return keyCache.computeIfAbsent(key, k -> new NamespacedKey(plugin, k.toLowerCase().replace(" ", "_")));
    }

    public static ItemStack setItemTag(ItemStack itemStack, String key) {
        NamespacedKey namespacedKey;
        ItemMeta meta;
        if (itemStack != null && itemStack.getType().isItem() && key != null && !ItemTag.isItemTag(itemStack, key) && (meta = itemStack.getItemMeta()) != null && (namespacedKey = ItemTag.getKey(key)) != null) {
            meta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BOOLEAN, (Object)true);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static boolean isItemTag(ItemStack itemStack, String key) {
        boolean value;
        NamespacedKey namespacedKey;
        ItemMeta meta;
        boolean check = false;
        if (itemStack != null && itemStack.getType().isItem() && key != null && (meta = itemStack.getItemMeta()) != null && (namespacedKey = ItemTag.getKey(key)) != null && (value = meta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.BOOLEAN))) {
            check = true;
        }
        return check;
    }

    public static List<NamespacedKey> getAllKeysfromItem(ItemStack itemStack) {
        ItemMeta meta;
        ArrayList<NamespacedKey> return_list = new ArrayList<NamespacedKey>();
        if (itemStack != null && itemStack.getType().isItem() && (meta = itemStack.getItemMeta()) != null) {
            return_list.addAll(meta.getPersistentDataContainer().getKeys());
        }
        return return_list;
    }

    public static ItemStack removeItemTag(ItemStack itemStack, String key) {
        NamespacedKey namespacedKey;
        ItemMeta meta;
        if (itemStack != null && itemStack.getType().isItem() && key != null && ItemTag.isItemTag(itemStack, key) && (meta = itemStack.getItemMeta()) != null && (namespacedKey = ItemTag.getKey(key)) != null) {
            meta.getPersistentDataContainer().remove(namespacedKey);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static ItemStack setItemStringTag(ItemStack itemStack, String key, String value) {
        if (itemStack == null || !itemStack.getType().isItem() || key == null || value == null) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey namespacedKey = ItemTag.getKey(key);
            meta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)value);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static boolean isItemStringTag(ItemStack itemStack, String key) {
        boolean value;
        NamespacedKey namespacedKey;
        ItemMeta meta;
        boolean check = false;
        if (itemStack != null && itemStack.getType().isItem() && key != null && (meta = itemStack.getItemMeta()) != null && (namespacedKey = ItemTag.getKey(key)) != null && (value = meta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.STRING))) {
            check = true;
        }
        return check;
    }

    public static String getItemStringTag(ItemStack itemStack, String key) {
        if (itemStack == null || !itemStack.getType().isItem() || key == null) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            NamespacedKey namespacedKey = ItemTag.getKey(key);
            if (meta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.STRING)) {
                return (String)meta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.STRING);
            }
        }
        return null;
    }
}

