/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.items;

import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSerializer {
    public static byte[] serializeToBytes(@NotNull ItemStack item) {
        return item.serializeAsBytes();
    }

    @NotNull
    public static ItemStack deserializeFromBytes(byte[] bytes) {
        return ItemStack.deserializeBytes((byte[])bytes);
    }

    @NotNull
    public static String serializeToBase64(@NotNull ItemStack item) {
        byte[] bytes = item.serializeAsBytes();
        return Base64.getEncoder().encodeToString(bytes);
    }

    @Nullable
    public static ItemStack deserializeFromBase64(@NotNull String base64) {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            return ItemStack.deserializeBytes((byte[])bytes);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

