/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.items;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import de.peachbiscuit174.peachlib.items.ItemLore;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeads {
    public static ItemStack getCustomHead(@NotNull String base64_texture) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (base64_texture == null) {
            return head;
        }
        if (meta == null) {
            return head;
        }
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
        ProfileProperty profileProperty = new ProfileProperty("textures", base64_texture);
        playerProfile.setProperty(profileProperty);
        meta.setPlayerProfile(playerProfile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull String base64_texture, @NotNull String display_name) {
        ItemStack head = CustomHeads.getCustomHead(base64_texture);
        head = CustomHeads.renameItem(head, display_name, null);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull String base64_texture, @NotNull String display_name, @NotNull ItemLore lore) {
        ItemStack head = CustomHeads.getCustomHead(base64_texture);
        head = CustomHeads.renameItem(head, display_name, lore);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URI uri) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (uri == null) {
            return head;
        }
        if (meta == null) {
            return head;
        }
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
        PlayerTextures playerTextures = playerProfile.getTextures();
        URL url = null;
        if (playerTextures == null) {
            return head;
        }
        try {
            url = uri.toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (url == null) {
            return head;
        }
        playerTextures.setSkin(url);
        playerProfile.setTextures(playerTextures);
        meta.setPlayerProfile(playerProfile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URI uri, @NotNull String display_name) {
        ItemStack head = CustomHeads.getCustomHead(uri);
        head = CustomHeads.renameItem(head, display_name, null);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URI uri, @NotNull String display_name, @NotNull ItemLore lore) {
        ItemStack head = CustomHeads.getCustomHead(uri);
        head = CustomHeads.renameItem(head, display_name, lore);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URL url) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (url == null) {
            return head;
        }
        if (meta == null) {
            return head;
        }
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)UUID.randomUUID());
        PlayerTextures playerTextures = playerProfile.getTextures();
        if (playerTextures == null) {
            return head;
        }
        playerTextures.setSkin(url);
        playerProfile.setTextures(playerTextures);
        meta.setPlayerProfile(playerProfile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URL url, @NotNull String display_name) {
        ItemStack head = CustomHeads.getCustomHead(url);
        head = CustomHeads.renameItem(head, display_name, null);
        return head;
    }

    public static ItemStack getCustomHead(@NotNull URL url, @NotNull String display_name, @NotNull ItemLore lore) {
        ItemStack head = CustomHeads.getCustomHead(url);
        head = CustomHeads.renameItem(head, display_name, lore);
        return head;
    }

    private static ItemStack renameItem(@NotNull ItemStack item, @Nullable String display_name, @Nullable ItemLore lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        if (display_name != null) {
            meta.displayName(CustomHeads.parseComponent(display_name));
        }
        if (lore != null) {
            meta.lore(lore.build());
        }
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    private static Component parseComponent(@NotNull String input) {
        return MiniMessage.miniMessage().deserialize((Object)input);
    }
}

