/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.other;

import de.peachbiscuit174.peachlib.PeachLib;
import de.peachbiscuit174.peachlib.scheduler.LibraryScheduler;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class ReloadSafetyListener
implements Listener {
    private final LibraryScheduler scheduler;

    public ReloadSafetyListener(Plugin plugin, LibraryScheduler scheduler) {
        this.scheduler = scheduler;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        if (message.equals("/reload") || message.equals("/rl") || message.startsWith("/reload ") || message.startsWith("/rl ")) {
            if (!event.getPlayer().hasPermission("bukkit.command.reload")) {
                return;
            }
            event.setCancelled(true);
            this.performSafeRestart(event.getPlayer().getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onConsoleCommand(ServerCommandEvent event) {
        String message = event.getCommand().toLowerCase();
        if (message.equals("reload") || message.equals("rl") || message.startsWith("reload ") || message.startsWith("rl ")) {
            event.setCancelled(true);
            this.performSafeRestart("Console");
        }
    }

    private void performSafeRestart(String initiator) {
        PeachLib.getPlugin().getLogger().warning("!!! UNSAFE RELOAD ATTEMPTED BY " + initiator + " !!!");
        PeachLib.getPlugin().getLogger().warning("Initiating safe shutdown to prevent plugin corruption...");
        BuildableComponent kickReason = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"\u26a0 SERVER RESTART \u26a0", (TextColor)NamedTextColor.RED))).append((Component)Component.newline())).append((Component)Component.newline())).append((Component)Component.text((String)"The server is restarting to apply changes safely.", (TextColor)NamedTextColor.GRAY))).append((Component)Component.newline())).append((Component)Component.text((String)"Please do not use /reload, as it breaks plugins.", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.newline())).append((Component)Component.text((String)"You can rejoin in a few moments!", (TextColor)NamedTextColor.GREEN))).build();
        Bukkit.getOnlinePlayers().forEach(arg_0 -> ReloadSafetyListener.lambda$performSafeRestart$0((Component)kickReason, arg_0));
        this.scheduler.runSyncDelayed(() -> Bukkit.shutdown(), 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$performSafeRestart$0(Component kickReason, Player player) {
        player.kick(kickReason);
    }
}

