/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib;

import de.peachbiscuit174.peachlib.Commands.PeachLibSettings;
import de.peachbiscuit174.peachlib.bstats.bukkit.Metrics;
import de.peachbiscuit174.peachlib.configstuff.ConfigData;
import de.peachbiscuit174.peachlib.configstuff.CustomConfig2;
import de.peachbiscuit174.peachlib.configstuff.SetupConfig;
import de.peachbiscuit174.peachlib.gui.GUIListener;
import de.peachbiscuit174.peachlib.other.HolidayGreetingListener;
import de.peachbiscuit174.peachlib.other.ReloadSafetyListener;
import de.peachbiscuit174.peachlib.scheduler.LibraryScheduler;
import de.peachbiscuit174.peachlib.updatecheck.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PeachLib
extends JavaPlugin {
    private static Plugin plugin;
    private static UpdateChecker updateChecker;
    private static LibraryScheduler scheduler;
    private Metrics metrics;
    private static CustomConfig2 cfg;

    public static CustomConfig2 getCfg() {
        return cfg;
    }

    public static LibraryScheduler getScheduler() {
        return scheduler;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        cfg = new CustomConfig2("settings.yml");
        SetupConfig.setup();
        ConfigData.reloadData();
        int pluginId = 29074;
        this.metrics = new Metrics((Plugin)this, pluginId);
        scheduler = new LibraryScheduler(plugin);
        updateChecker = new UpdateChecker(this);
        updateChecker.bootstrap();
        new ReloadSafetyListener((Plugin)this, scheduler);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new GUIListener(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new HolidayGreetingListener(), (Plugin)this);
        PluginCommand cmd = this.getCommand("peachLibSettings");
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)new PeachLibSettings());
            this.getLogger().info("PeachLibSettings Command registriert :D");
        }
        this.getLogger().info("----------------------------------");
        this.getLogger().info("PeachLib has been loaded successfully.");
        this.getLogger().info("Version: " + this.getPluginMeta().getVersion());
        this.getLogger().info("Developed by PeachBiscuit174");
        this.getLogger().info("Thank you for using PeachLib (PPL) :D");
        this.getLogger().info("----------------------------------");
    }

    public void onDisable() {
        if (scheduler != null) {
            scheduler.shutdown();
        }
        scheduler = null;
        updateChecker = null;
        this.metrics = null;
        cfg = null;
        this.getLogger().info("PeachLib disabled.");
        plugin = null;
    }
}

