/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.updatecheck;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.peachbiscuit174.peachlib.PeachLib;
import de.peachbiscuit174.peachlib.other.ConfigData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.HexFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String githubRepo = "PeachBiscuit174/PeachLib";
    private String latestVersion;
    private String downloadUrl;
    private String checksumUrl;
    private String remoteFileName;
    private volatile boolean isUpdateAvailable = false;
    private final HttpClient httpClient;

    public UpdateChecker(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void bootstrap() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        if (PeachLib.getScheduler() != null) {
            PeachLib.getScheduler().runAsyncRepeating(this::checkUpdates, 0L, 12L, TimeUnit.HOURS);
        } else {
            this.plugin.getLogger().severe("Could not start UpdateChecker: LibraryScheduler is null! Ensure correct initialization order in Main class.");
        }
    }

    private void checkUpdates() {
        if (!ConfigData.getAutoUpdateStatus()) {
            return;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/PeachBiscuit174/PeachLib/releases/latest")).header("Accept", "application/vnd.github.v3+json").header("User-Agent", "PeachLib-UpdateChecker").timeout(Duration.ofSeconds(10L)).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                this.plugin.getLogger().warning("Update check failed. HTTP Status Code: " + response.statusCode());
                return;
            }
            JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
            this.latestVersion = json.get("tag_name").getAsString().replace("v", "").trim();
            if (this.isNewerVersionAvailable()) {
                JsonArray assets = json.getAsJsonArray("assets");
                this.parseAssets(assets);
                String currentApiVersion = this.plugin.getPluginMeta().getAPIVersion();
                if (this.isApiVersionCompatible(currentApiVersion)) {
                    this.handleDownloadProcess();
                } else {
                    this.plugin.getLogger().info("Update check skipped: A new version is available (" + this.latestVersion + "), but it is not compatible with your server version.");
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Update check failed due to an exception.", e);
        }
    }

    private void parseAssets(JsonArray assets) {
        this.downloadUrl = null;
        this.checksumUrl = null;
        for (int i = 0; i < assets.size(); ++i) {
            JsonObject asset = assets.get(i).getAsJsonObject();
            String name = asset.get("name").getAsString();
            String url = asset.get("browser_download_url").getAsString();
            if (name.endsWith(".jar") && name.contains("PeachLib")) {
                this.downloadUrl = url;
                this.remoteFileName = name;
                continue;
            }
            if (!name.endsWith("checksum.txt") && !name.endsWith("sha256")) continue;
            this.checksumUrl = url;
        }
    }

    private boolean isNewerVersionAvailable() {
        String current = this.plugin.getPluginMeta().getVersion().trim();
        return !current.equalsIgnoreCase(this.latestVersion);
    }

    private boolean isApiVersionCompatible(String apiVersion) {
        if (apiVersion == null) {
            return true;
        }
        String serverVersion = Bukkit.getMinecraftVersion();
        return serverVersion.startsWith(apiVersion);
    }

    private void handleDownloadProcess() {
        if (this.downloadUrl == null || this.remoteFileName == null) {
            this.plugin.getLogger().warning("New version detected, but no valid JAR file was found in the GitHub assets.");
            return;
        }
        File updateFolder = Bukkit.getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdirs()) {
            this.plugin.getLogger().severe("Could not create update folder. Update aborted.");
            return;
        }
        File finalTargetFile = new File(updateFolder, this.remoteFileName);
        File tempFile = new File(updateFolder, this.remoteFileName + ".tmp");
        this.cleanupOldVersions(updateFolder);
        String remoteHash = this.fetchRemoteHash();
        if (remoteHash.isEmpty()) {
            this.plugin.getLogger().warning("Update verification failed: Checksum not found or empty on remote. Aborting for security.");
            return;
        }
        if (finalTargetFile.exists()) {
            if (this.isValidFile(finalTargetFile, remoteHash)) {
                this.isUpdateAvailable = true;
                return;
            }
            try {
                Files.delete(finalTargetFile.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.downloadAndVerify(tempFile, remoteHash)) {
            if (this.verifyRemoteJarApi(tempFile)) {
                try {
                    Files.move(tempFile.toPath(), finalTargetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    this.isUpdateAvailable = true;
                    this.plugin.getLogger().info("Successfully downloaded and verified update: " + this.remoteFileName);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Failed to move update file into place: " + e.getMessage());
                    try {
                        Files.deleteIfExists(tempFile.toPath());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.plugin.getLogger().severe("Update rejected: Downloaded JAR API version is not compatible with this server.");
                try {
                    Files.deleteIfExists(tempFile.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void cleanupOldVersions(File updateFolder) {
        File[] files = updateFolder.listFiles((dir, name) -> name.endsWith(".jar") && name.startsWith("PeachLib"));
        if (files != null) {
            for (File file : files) {
                if (file.getName().equals(this.remoteFileName)) continue;
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isValidFile(File file, String hash) {
        return this.calculateSHA256(file).equalsIgnoreCase(hash) && this.verifyRemoteJarApi(file);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean verifyRemoteJarApi(File jarFile) {
        try (ZipFile zip = new ZipFile(jarFile);){
            boolean bl;
            block15: {
                ZipEntry entry = zip.getEntry("plugin.yml");
                if (entry == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                InputStream is = zip.getInputStream(entry);
                try {
                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(is));
                    String apiVersion = yaml.getString("api-version");
                    bl = this.isApiVersionCompatible(apiVersion);
                    if (is == null) break block15;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return bl;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not read API version from downloaded JAR: " + e.getMessage());
            return false;
        }
    }

    private String fetchRemoteHash() {
        if (this.checksumUrl == null) {
            return "";
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.checksumUrl)).header("User-Agent", "PeachLib-UpdateChecker").timeout(Duration.ofSeconds(10L)).GET().build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return response.body().trim().split("\\s+")[0];
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to fetch checksum: " + e.getMessage());
        }
        return "";
    }

    private boolean downloadAndVerify(File targetFile, String expectedHash) {
        try {
            this.plugin.getLogger().info("Downloading update: " + this.remoteFileName);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.downloadUrl)).header("User-Agent", "PeachLib-UpdateChecker").timeout(Duration.ofMinutes(2L)).GET().build();
            HttpResponse<Path> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofFile(targetFile.toPath()));
            if (response.statusCode() != 200) {
                this.plugin.getLogger().warning("Download failed with HTTP " + response.statusCode());
                Files.deleteIfExists(targetFile.toPath());
                return false;
            }
            String localHash = this.calculateSHA256(targetFile);
            if (localHash.equalsIgnoreCase(expectedHash)) {
                return true;
            }
            this.plugin.getLogger().severe("Checksum mismatch! The downloaded file is corrupt or compromised.");
            Files.deleteIfExists(targetFile.toPath());
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Download error: " + e.getMessage());
            try {
                Files.deleteIfExists(targetFile.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private String calculateSHA256(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
            }
            return HexFormat.of().formatHex(digest.digest());
        }
        catch (Exception e) {
            return "error";
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() && this.isUpdateAvailable) {
            Component message = MiniMessage.miniMessage().deserialize((Object)"<newline><gold>PeachLib</gold> <gray>\u00bb</gray> <green>A verified update is ready!</green><newline><gray>Restart the server to apply the changes.</gray><newline>");
            player.sendMessage(message);
        }
    }
}

