/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.items;

import de.peachbiscuit174.peachlib.items.ItemLore;
import de.peachbiscuit174.peachlib.items.ItemTag;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private final ItemStack itemStack;
    private final ItemMeta itemMeta;
    private int amount = 1;
    private int customModelDataLegacy = -1;
    private float customModelData = -1.0f;
    private String item_tag;
    private List<String> item_tag_list = new ArrayList<String>();
    private static final MiniMessage MM = MiniMessage.miniMessage();

    public ItemBuilder(@NotNull Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack.clone();
        this.itemMeta = this.itemStack.getItemMeta();
    }

    private ItemBuilder(@NotNull ItemStack itemStack, int customModelDataint, float customModelDatafloat, String item_tag, List<String> item_tag_list, int amount) {
        this.itemStack = itemStack.clone();
        this.itemMeta = this.itemStack.getItemMeta().clone();
        if (customModelDataint == -1 && customModelDatafloat != -1.0f) {
            this.customModelData = customModelDatafloat;
        } else if (customModelDataint != -1 && customModelDatafloat == -1.0f) {
            this.customModelDataLegacy = customModelDataint;
        } else if (customModelDataint != -1 && customModelDatafloat != -1.0f) {
            this.customModelData = customModelDatafloat;
        }
        if (item_tag != null) {
            this.item_tag = item_tag;
        }
        if (item_tag_list != null && !item_tag_list.isEmpty()) {
            this.item_tag_list = new ArrayList<String>(item_tag_list);
        }
        this.amount = amount;
    }

    @NotNull
    public ItemBuilder copy() {
        return new ItemBuilder(this.buildWithoutData(), this.customModelDataLegacy, this.customModelData, this.item_tag, this.item_tag_list, this.amount);
    }

    public ItemBuilder setAmount(int amount) {
        if (amount >= 1 && amount <= 64) {
            this.amount = amount;
        }
        return this;
    }

    public ItemBuilder setDisplayName(@NotNull String displayName) {
        if (this.itemMeta != null) {
            this.itemMeta.displayName(MM.deserialize((Object)displayName).decoration(TextDecoration.ITALIC, false));
        }
        return this;
    }

    public ItemBuilder lore(@NotNull ItemLore itemLore) {
        if (this.itemMeta != null) {
            List<Component> lore_list = itemLore.build();
            ArrayList<Component> finalLore = new ArrayList<Component>();
            for (Component lore : lore_list) {
                lore = lore.decoration(TextDecoration.ITALIC, false);
                finalLore.add(lore);
            }
            this.itemMeta.lore(finalLore);
        }
        return this;
    }

    public ItemBuilder lore(@NotNull List<Component> components) {
        if (this.itemMeta != null) {
            ArrayList<Component> finalLore = new ArrayList<Component>();
            for (Component lore : components) {
                lore = lore.decoration(TextDecoration.ITALIC, false);
                finalLore.add(lore);
            }
            this.itemMeta.lore(finalLore);
        }
        return this;
    }

    public ItemBuilder enchant(@NotNull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        if (this.itemMeta != null) {
            this.itemMeta.addEnchant(enchantment, level, ignoreLevelRestriction);
        }
        return this;
    }

    public ItemBuilder flags(ItemFlag ... flags) {
        if (this.itemMeta != null) {
            this.itemMeta.addItemFlags(flags);
        }
        return this;
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        if (this.itemMeta != null) {
            this.itemMeta.setUnbreakable(unbreakable);
        }
        return this;
    }

    @ApiStatus.Experimental
    public ItemBuilder setCustomModelData(float customModelData) {
        if (customModelData >= 0.0f) {
            this.customModelData = customModelData;
        }
        return this;
    }

    @Deprecated
    public ItemBuilder setCustomModelData(int customModelData) {
        if (customModelData >= 0) {
            this.customModelDataLegacy = customModelData;
        }
        return this;
    }

    public <T extends ItemMeta> ItemBuilder editMeta(@NotNull Class<T> metaClass, @NotNull Consumer<T> consumer) {
        if (metaClass.isInstance(this.itemMeta)) {
            consumer.accept((ItemMeta)metaClass.cast(this.itemMeta));
        }
        return this;
    }

    @Deprecated
    public ItemBuilder setItemTag(@NotNull String item_tag) {
        this.item_tag = item_tag;
        return this;
    }

    public ItemBuilder addItemTag(@NotNull String item_tag) {
        if (!this.item_tag_list.contains(item_tag)) {
            this.item_tag_list.add(item_tag);
        }
        return this;
    }

    @NotNull
    public ItemStack build() {
        ItemStack buildItemStack = this.itemStack.clone();
        ItemMeta buildItemMeta = this.itemMeta.clone();
        ArrayList<String> build_item_tag_list = new ArrayList<String>(this.item_tag_list);
        if (this.customModelData != -1.0f) {
            buildItemStack.setItemMeta(buildItemMeta);
            if (!buildItemStack.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
                buildItemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addFloat(this.customModelData).addFlag(true).build()));
            }
        } else if (this.customModelDataLegacy != -1) {
            if (!buildItemMeta.hasCustomModelData()) {
                buildItemMeta.setCustomModelData(Integer.valueOf(this.customModelDataLegacy));
            }
            buildItemStack.setItemMeta(buildItemMeta);
        } else {
            buildItemStack.setItemMeta(buildItemMeta);
        }
        if (this.item_tag != null && !build_item_tag_list.contains(this.item_tag)) {
            build_item_tag_list.add(this.item_tag);
        }
        if (!build_item_tag_list.isEmpty()) {
            for (String key : build_item_tag_list) {
                ItemTag.setItemTag(buildItemStack, key);
            }
        }
        if (this.amount >= 1 && this.amount <= 64) {
            buildItemStack.setAmount(this.amount);
        }
        return buildItemStack;
    }

    @NotNull
    private ItemStack buildWithoutData() {
        ItemStack buildItemStack = this.itemStack.clone();
        ItemMeta buildItemMeta = this.itemMeta.clone();
        buildItemStack.setItemMeta(buildItemMeta);
        return buildItemStack;
    }
}

