/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.player;

import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerManaging {
    private final Player player;

    public PlayerManaging(@NotNull Player player) {
        this.player = player;
    }

    public void sendMessage(@NotNull String message) {
        this.player.sendMessage(PlayerManaging.parseComponent(message));
    }

    public void setDisplayName(@NotNull String displayName) {
        this.player.displayName(PlayerManaging.parseComponent(displayName));
    }

    @Deprecated
    public void setDisplayNameLegacy(@NotNull String displayNameLegacy) {
        this.player.setDisplayName(displayNameLegacy);
    }

    public Component getDisplayName() {
        return this.player.displayName();
    }

    @Deprecated
    public String getDisplayNameLegacy() {
        return this.player.getDisplayName();
    }

    public boolean giveOrDropItem(@NotNull ItemStack itemStack) {
        HashMap remainingItems = this.player.getInventory().addItem(new ItemStack[]{itemStack});
        if (!remainingItems.isEmpty()) {
            Location dropLocation = this.player.getLocation();
            World world = this.player.getWorld();
            for (ItemStack remaining : remainingItems.values()) {
                world.dropItem(dropLocation, remaining);
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Component parseComponent(@NotNull String input) {
        return MiniMessage.miniMessage().deserialize((Object)input);
    }
}

