/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.gui;

import de.peachbiscuit174.peachlib.gui.GUIButton;
import de.peachbiscuit174.peachlib.gui.InventoryGUI;
import de.peachbiscuit174.peachlib.items.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PaginatedGUI {
    private final String title;
    private final int rows;
    private final List<GUIButton> contentButtons = new ArrayList<GUIButton>();
    private final Map<Integer, GUIButton> customToolbarButtons = new HashMap<Integer, GUIButton>();
    private boolean useToolbarBackground = true;
    private int prevSlot = 0;
    private int nextSlot = 8;
    private int closeSlot = -1;
    private ItemBuilder nextIcon = new ItemBuilder(Material.ARROW).setDisplayName("<green>Next Page \u00bb");
    private ItemBuilder prevIcon = new ItemBuilder(Material.ARROW).setDisplayName("<yellow>\u00ab Previous Page");
    private ItemBuilder closeIcon = new ItemBuilder(Material.BARRIER).setDisplayName("<red>Close");
    private ItemBuilder backgroundIcon = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setDisplayName(" ");

    public PaginatedGUI(int rows, String titleMiniMessage) {
        this.rows = Math.max(2, Math.min(6, rows));
        this.title = titleMiniMessage;
    }

    public PaginatedGUI addButton(@NotNull GUIButton button) {
        this.contentButtons.add(button);
        return this;
    }

    public PaginatedGUI addButtons(@NotNull List<GUIButton> buttons) {
        this.contentButtons.addAll(buttons);
        return this;
    }

    public PaginatedGUI setNavigationSlots(int prevSlot, int nextSlot, int closeSlot) {
        this.prevSlot = prevSlot;
        this.nextSlot = nextSlot;
        this.closeSlot = closeSlot;
        return this;
    }

    public PaginatedGUI setToolbarButton(int toolbarSlot, @NotNull GUIButton button) {
        if (toolbarSlot >= 0 && toolbarSlot <= 8) {
            this.customToolbarButtons.put(toolbarSlot, button);
        }
        return this;
    }

    public PaginatedGUI setToolbarBackgroundEnabled(boolean enabled) {
        this.useToolbarBackground = enabled;
        return this;
    }

    public PaginatedGUI setNextIcon(@NotNull ItemBuilder builder) {
        this.nextIcon = builder;
        return this;
    }

    public PaginatedGUI setPreviousIcon(@NotNull ItemBuilder builder) {
        this.prevIcon = builder;
        return this;
    }

    public PaginatedGUI setCloseIcon(@NotNull ItemBuilder builder) {
        this.closeIcon = builder;
        return this;
    }

    public PaginatedGUI setToolbarBackground(@NotNull ItemBuilder builder) {
        this.backgroundIcon = builder;
        return this;
    }

    public void open(@NotNull Player player) {
        this.open(player, 0);
    }

    private void open(@NotNull Player player, int page) {
        int contentRows = this.rows - 1;
        int slotsPerPage = contentRows * 9;
        int totalItems = this.contentButtons.size();
        int totalPages = (int)Math.ceil((double)totalItems / (double)slotsPerPage);
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages && totalPages > 0) {
            page = totalPages - 1;
        }
        String pageTitle = this.title + " <dark_gray>(" + (page + 1) + "/" + Math.max(1, totalPages) + ")";
        InventoryGUI gui = new InventoryGUI(this.rows, pageTitle);
        int startIndex = page * slotsPerPage;
        int endIndex = Math.min(startIndex + slotsPerPage, totalItems);
        for (int i = startIndex; i < endIndex; ++i) {
            gui.setButton(i - startIndex, this.contentButtons.get(i));
        }
        int toolbarStartIdx = contentRows * 9;
        if (this.useToolbarBackground) {
            for (int i = 0; i < 9; ++i) {
                gui.setPlaceholder(toolbarStartIdx + i, this.backgroundIcon.copy(), "toolbar_bg");
            }
        }
        for (Map.Entry<Integer, GUIButton> entry : this.customToolbarButtons.entrySet()) {
            gui.setButton(toolbarStartIdx + entry.getKey(), entry.getValue());
        }
        int finalPage = page;
        if (this.prevSlot >= 0 && page > 0) {
            gui.setButton(toolbarStartIdx + this.prevSlot, new GUIButton(this.prevIcon.copy(), "prev_page", event -> this.open(player, finalPage - 1)));
        }
        if (this.nextSlot >= 0 && page < totalPages - 1) {
            gui.setButton(toolbarStartIdx + this.nextSlot, new GUIButton(this.nextIcon.copy(), "next_page", event -> this.open(player, finalPage + 1)));
        }
        if (this.closeSlot >= 0) {
            gui.setButton(toolbarStartIdx + this.closeSlot, new GUIButton(this.closeIcon.copy(), "close_gui", event -> player.closeInventory()));
        }
        gui.open(player);
    }
}

