/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.gui;

import de.peachbiscuit174.peachlib.gui.GUIButton;
import de.peachbiscuit174.peachlib.items.ItemBuilder;
import de.peachbiscuit174.peachlib.items.ItemTag;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryGUI
implements InventoryHolder {
    private final Inventory inventory;
    private final Map<Integer, GUIButton> buttons = new HashMap<Integer, GUIButton>();
    private static final MiniMessage MM = MiniMessage.miniMessage();
    private String[] shape;
    private final Map<Character, GUIButton> charMapping = new HashMap<Character, GUIButton>();
    public static final String PROTECTED_TAG = "gui_protected_ppl";

    public InventoryGUI(int rows, String titleMiniMessage) {
        int finalRows = Math.max(1, Math.min(6, rows));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(finalRows * 9), (Component)MM.deserialize((Object)titleMiniMessage));
    }

    public void setButton(int slot, @NotNull GUIButton button) {
        this.buttons.put(slot, button);
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        GUIButton button = this.buttons.get(slot);
        if (button != null) {
            ItemStack itemStack = button.getItemBuilder().build();
            ItemTag.setItemTag(itemStack, PROTECTED_TAG);
            ItemTag.setItemTag(itemStack, button.getActionId());
            this.inventory.setItem(slot, itemStack);
        }
    }

    public void setPlaceholder(int slot, @NotNull ItemBuilder builder, @NotNull String id) {
        this.setButton(slot, new GUIButton(builder, id, null));
    }

    public void fillEmptySlots(@NotNull ItemBuilder builder, @NotNull String id) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.setPlaceholder(i, builder.copy(), id);
        }
    }

    public InventoryGUI shape(String ... rows) {
        this.shape = rows;
        this.applyShape();
        return this;
    }

    public InventoryGUI map(char key, GUIButton button) {
        this.charMapping.put(Character.valueOf(key), button);
        this.applyShape();
        return this;
    }

    public InventoryGUI mapPlaceholder(char key, @NotNull ItemBuilder builder, @NotNull String id) {
        this.charMapping.put(Character.valueOf(key), new GUIButton(builder, id, null));
        this.applyShape();
        return this;
    }

    private void applyShape() {
        if (this.shape == null || this.shape.length == 0) {
            return;
        }
        int maxRowsInInv = this.inventory.getSize() / 9;
        for (int row = 0; row < Math.min(maxRowsInInv, this.shape.length); ++row) {
            String rowString = this.shape[row];
            for (int col = 0; col < Math.min(9, rowString.length()); ++col) {
                char c = rowString.charAt(col);
                if (!this.charMapping.containsKey(Character.valueOf(c))) continue;
                int slot = row * 9 + col;
                this.setButton(slot, this.charMapping.get(Character.valueOf(c)));
            }
        }
    }

    public void open(@NotNull Player player) {
        player.openInventory(this.inventory);
    }

    public Map<Integer, GUIButton> getButtons() {
        return this.buttons;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }
}

