/*
 * Decompiled with CFR 0.152.
 */
package de.peachbiscuit174.peachlib.other;

import de.peachbiscuit174.peachlib.other.CustomConfig2;
import java.time.LocalDate;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class HolidayGreetingListener
implements Listener {
    private final CustomConfig2 configWrapper;
    private final FileConfiguration config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public HolidayGreetingListener() {
        this.configWrapper = new CustomConfig2("holidays.yml");
        this.config = this.configWrapper.getConfig();
        this.setupDefaults();
    }

    private void setupDefaults() {
        this.config.addDefault("enabled", (Object)true);
        this.config.addDefault("messages.new_year", (Object)"<yellow><bold>Happy New Year %year%!</bold></yellow> Welcome to a fresh start!");
        this.config.addDefault("messages.valentines_day", (Object)"<red>Happy Valentine's Day %year%!</red> <dark_red>\u2764</dark_red>");
        this.config.addDefault("messages.st_patricks_day", (Object)"<green>Happy St. Patrick's Day %year%!</green> <dark_green>\u2618</dark_green>");
        this.config.addDefault("messages.easter", (Object)"<green>Happy Easter %year%!</green> Have a wonderful day!");
        this.config.addDefault("messages.halloween", (Object)"<gold>Happy Halloween %year%!</gold> <dark_purple>\u2620</dark_purple>");
        this.config.addDefault("messages.christmas", (Object)"<red>Merry Christmas %year%!</red> <green>Enjoy the holidays!</green>");
        this.config.addDefault("messages.new_year_eve", (Object)"<gold>Happy New Year's Eve %year%!</gold> Celebrate safely!");
        this.config.options().copyDefaults(true);
        this.configWrapper.save();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String message;
        if (!this.config.getBoolean("enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        LocalDate today = LocalDate.now();
        String holidayKey = this.getHolidayKey(today);
        if (holidayKey != null && (message = this.config.getString("messages." + holidayKey)) != null && !message.isEmpty()) {
            String processedMessage = message.replace("%year%", String.valueOf(today.getYear()));
            player.sendMessage(this.miniMessage.deserialize((Object)processedMessage));
        }
    }

    private String getHolidayKey(LocalDate date) {
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        if (month == 1 && day == 1) {
            return "new_year";
        }
        if (month == 2 && day == 14) {
            return "valentines_day";
        }
        if (month == 3 && day == 17) {
            return "st_patricks_day";
        }
        if (this.isEasterSunday(date)) {
            return "easter";
        }
        if (month == 10 && day == 31) {
            return "halloween";
        }
        if (month == 12 && day >= 24 && day <= 26) {
            return "christmas";
        }
        if (month == 12 && day == 31) {
            return "new_year_eve";
        }
        return null;
    }

    private boolean isEasterSunday(LocalDate date) {
        int n;
        int c;
        int b;
        int e;
        int q;
        int k;
        int p;
        int m;
        int year = date.getYear();
        int a = year % 19;
        int d = (19 * a + (m = (15 - (p = (13 + 8 * (k = year / 100)) / 25) + k - (q = k / 4)) % 30)) % 30;
        int easterDay = 22 + d + (e = (2 * (b = year % 4) + 4 * (c = year % 7) + 6 * d + (n = (4 + k - q) % 7)) % 7);
        LocalDate easterDate = easterDay > 31 ? LocalDate.of(year, 4, easterDay - 31) : LocalDate.of(year, 3, easterDay);
        return date.equals(easterDate);
    }
}

