/*
 * Decompiled with CFR 0.152.
 */
package me.prdis.swapper.plugin.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.prdis.swapper.plugin.SwapperPlugin;
import me.prdis.swapper.plugin.config.SwapperConfig;
import me.prdis.swapper.plugin.data.SwapperData;
import me.prdis.swapper.plugin.data.SwapperSuccessionData;
import me.prdis.swapper.plugin.name.NameManager;
import me.prdis.swapper.plugin.objects.SwapperConsts;
import me.prdis.swapper.plugin.objects.SwapperGameManager;
import me.prdis.swapper.plugin.tasks.SwapperTimer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0018J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u000fJ\b\u0010'\u001a\u00020\u000fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001c\u0010(\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b)*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lme/prdis/swapper/plugin/objects/SwapperImpl;", "", "<init>", "()V", "numberedPlayers", "", "Ljava/util/UUID;", "getNumberedPlayers", "()Ljava/util/List;", "bypassExclusions", "", "getBypassExclusions", "meltedPlayers", "getMeltedPlayers", "grantPlayerNumbers", "", "clearPlayerNumbers", "initializeViewerPlayer", "assignPlayerNames", "revokePlayerNames", "initializeScoreboard", "destroyScoreboard", "swapPlayers", "createSuccessionData", "Lme/prdis/swapper/plugin/data/SwapperSuccessionData;", "player", "Lorg/bukkit/entity/Player;", "applySuccession", "to", "successionData", "getViewerPlayers", "", "checkWinningCriteria", "", "getNextIndex", "", "num", "updateConfigPlayers", "setupStartupTask", "setupWorldSettings", "toPlayer", "Lorg/jetbrains/annotations/Nullable;", "getToPlayer", "(Ljava/util/UUID;)Lorg/bukkit/entity/Player;", "swapper"})
@SourceDebugExtension(value={"SMAP\nSwapperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwapperImpl.kt\nme/prdis/swapper/plugin/objects/SwapperImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n1586#2:339\n1661#2,3:340\n1915#2,2:343\n1924#2,3:345\n1915#2,2:348\n1924#2,3:350\n1915#2,2:353\n777#2:355\n873#2,2:356\n777#2:358\n873#2,2:359\n1786#2,3:361\n*S KotlinDebug\n*F\n+ 1 SwapperImpl.kt\nme/prdis/swapper/plugin/objects/SwapperImpl\n*L\n70#1:339\n70#1:340,3\n85#1:343,2\n101#1:345,3\n121#1:348,2\n168#1:350,3\n204#1:353,2\n257#1:355\n257#1:356,2\n264#1:358\n264#1:359,2\n283#1:361,3\n*E\n"})
public final class SwapperImpl {
    @NotNull
    public static final SwapperImpl INSTANCE = new SwapperImpl();
    @NotNull
    private static final List<UUID> numberedPlayers = new ArrayList();
    @NotNull
    private static final List<String> bypassExclusions;
    @NotNull
    private static final List<String> meltedPlayers;

    private SwapperImpl() {
    }

    @NotNull
    public final List<UUID> getNumberedPlayers() {
        return numberedPlayers;
    }

    @NotNull
    public final List<String> getBypassExclusions() {
        return bypassExclusions;
    }

    @NotNull
    public final List<String> getMeltedPlayers() {
        return meltedPlayers;
    }

    /*
     * WARNING - void declaration
     */
    public final void grantPlayerNumbers() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List viewerPlayers = CollectionsKt.shuffled((Iterable)this.getViewerPlayers());
        Iterable iterable = viewerPlayers;
        List<UUID> list = numberedPlayers;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            collection.add(uUID);
        }
        list.addAll((List)destination$iv$iv);
        this.updateConfigPlayers();
    }

    public final void clearPlayerNumbers() {
        numberedPlayers.clear();
    }

    public final void initializeViewerPlayer() {
        Iterable $this$forEach$iv = this.getViewerPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            player.closeInventory();
            player.setGameMode(GameMode.SURVIVAL);
            player.setHealth(20.0);
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            player.clearActivePotionEffects();
            player.closeInventory();
            player.getInventory().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void assignPlayerNames() {
        Iterable $this$forEachIndexed$iv = numberedPlayers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void uuid;
            Player player;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            UUID uUID = (UUID)item$iv;
            int index = n;
            boolean bl = false;
            Player player2 = player = INSTANCE.getToPlayer((UUID)uuid);
            boolean bl2 = player2 != null ? player2.isConnected() : false;
            if (!bl2) continue;
            String value = String.valueOf(index + 1);
            NameManager.INSTANCE.setFakeName(player, value);
            NameManager.INSTANCE.setOriginalName(player, player.getName());
            NameManager.INSTANCE.modifyProfile(player, value);
            player.displayName((Component)Component.text((String)value));
            player.sendMessage((Component)Component.text((String)("\ub2f9\uc2e0\uc740 " + value + "\ubc88 \ud50c\ub808\uc774\uc5b4\uc785\ub2c8\ub2e4."), (TextColor)((TextColor)NamedTextColor.GREEN)));
        }
    }

    public final void revokePlayerNames() {
        Iterable $this$forEach$iv = numberedPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            Player player2 = player = INSTANCE.getToPlayer(uuid);
            boolean bl2 = player2 != null ? player2.isConnected() : false;
            if (!bl2) continue;
            String string = NameManager.INSTANCE.getOriginalName(player);
            if (string == null) {
                String string2 = player.getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            }
            String originalName = string;
            NameManager.INSTANCE.setFakeName(player, null);
            NameManager.INSTANCE.modifyProfile(player, originalName);
            player.displayName((Component)Component.text((String)originalName));
            NameManager.INSTANCE.setOriginalName(player, null);
        }
    }

    public final void initializeScoreboard() {
        Scoreboard scoreboard = SwapperConsts.INSTANCE.getServer().getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"getMainScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = scoreboard2.getObjective("swapper");
        if (objective == null) {
            Objective objective2 = scoreboard2.registerNewObjective("swapper", Criteria.DUMMY, (Component)Component.text((String)"60.0\ucd08"));
            objective = objective2;
            Intrinsics.checkNotNullExpressionValue((Object)objective2, (String)"registerNewObjective(...)");
        }
        Objective swapperObjective = objective;
        swapperObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
        SwapperTimer.INSTANCE.setSwapperObjective(swapperObjective);
    }

    public final void destroyScoreboard() {
        Objective swapperObjective;
        Scoreboard scoreboard = SwapperConsts.INSTANCE.getServer().getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue((Object)scoreboard, (String)"getMainScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = swapperObjective = scoreboard2.getObjective("swapper");
        if (objective != null) {
            objective.unregister();
        }
        SwapperTimer.INSTANCE.setSwapperObjective(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void swapPlayers() {
        List reorderList = new ArrayList();
        Iterable $this$forEachIndexed$iv = numberedPlayers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void uuid;
            Player player;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            UUID uUID = (UUID)item$iv;
            int index = n;
            boolean bl = false;
            Player player2 = player = INSTANCE.getToPlayer((UUID)uuid);
            boolean bl2 = player2 != null ? player2.isConnected() : false;
            if (!bl2) continue;
            int searchIndex = INSTANCE.getNextIndex(index);
            player.closeInventory();
            player.updateInventory();
            if (searchIndex != -1) {
                Player targetPlayer;
                Player player3 = targetPlayer = INSTANCE.getToPlayer(numberedPlayers.get(searchIndex));
                boolean bl3 = player3 != null ? player3.isConnected() : false;
                if (bl3) {
                    targetPlayer.closeInventory();
                    targetPlayer.updateInventory();
                    SwapperSuccessionData succession = INSTANCE.createSuccessionData(targetPlayer);
                    String string = targetPlayer.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Location location = targetPlayer.getLocation().clone();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
                    reorderList.add(new SwapperData(searchIndex, player, targetPlayer, string, succession, location));
                    continue;
                }
                player.sendMessage((Component)Component.text((String)"\uc624\ub958: \uad50\uccb4\ud560 \ud50c\ub808\uc774\uc5b4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. [TP_NOT_CONNECTED]", (TextColor)((TextColor)NamedTextColor.RED)));
                continue;
            }
            player.sendMessage((Component)Component.text((String)"\uc624\ub958: \uad50\uccb4\ud560 \ud50c\ub808\uc774\uc5b4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. [IDX_ERR]", (TextColor)((TextColor)NamedTextColor.RED)));
        }
        Iterable $this$forEach$iv = reorderList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SwapperData data = (SwapperData)element$iv;
            boolean bl = false;
            data.getPlayer().closeInventory();
            data.getPlayer().updateInventory();
            INSTANCE.applySuccession(data.getPlayer(), data.getSuccessionData());
            data.getPlayer().updateInventory();
            data.getPlayer().teleportAsync(data.getTargetLocation());
        }
        this.updateConfigPlayers();
    }

    @NotNull
    public final SwapperSuccessionData createSuccessionData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack[] itemStackArray = player.getInventory().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        ItemStack[] itemStackArray2 = player.getInventory().getArmorContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray2, (String)"getArmorContents(...)");
        double d = player.getHealth();
        int n = player.getFoodLevel();
        float f = player.getSaturation();
        float f2 = player.getExhaustion();
        int n2 = player.getLevel();
        float f3 = player.getExp();
        GameMode gameMode = player.getGameMode();
        Intrinsics.checkNotNullExpressionValue((Object)gameMode, (String)"getGameMode(...)");
        Collection collection = player.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActivePotionEffects(...)");
        return new SwapperSuccessionData(itemStackArray, itemStackArray2, d, n, f, f2, n2, f3, gameMode, collection);
    }

    public final void applySuccession(@NotNull Player to, @NotNull SwapperSuccessionData successionData) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)successionData, (String)"successionData");
        to.getInventory().setContents(successionData.getInventory());
        to.getInventory().setArmorContents(successionData.getArmorContents());
        to.setHealth(successionData.getHealth());
        to.setFoodLevel(successionData.getFoodLevel());
        to.setSaturation(successionData.getSaturation());
        to.setExhaustion(successionData.getExhaustion());
        to.setLevel(successionData.getLevel());
        to.setExp(successionData.getExp());
        to.setGameMode(successionData.getGameMode());
        to.clearActivePotionEffects();
        to.addPotionEffects(successionData.getPotionEffects());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> getViewerPlayers() {
        void $this$filterTo$iv$iv;
        Collection collection = SwapperConsts.INSTANCE.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(it != null && !SwapperGameManager.INSTANCE.isHunter(it) && !it.isOp())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkWinningCriteria() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getViewerPlayers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!it.isConnected()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List viewerPlayers = (List)destination$iv$iv;
        return viewerPlayers.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int getNextIndex(int num) {
        try {
            Player targetPlayer;
            boolean bl;
            int targetNum = (num - 1) % numberedPlayers.size();
            if (targetNum < 0) {
                targetNum = CollectionsKt.getLastIndex(numberedPlayers);
            }
            Iterable $this$all$iv = numberedPlayers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return -1;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                block12: {
                    block11: {
                        if (!iterator.hasNext()) return -1;
                        Object element$iv = iterator.next();
                        UUID it = (UUID)element$iv;
                        boolean bl2 = false;
                        if (INSTANCE.getToPlayer(it) == null) break block11;
                        Player player = INSTANCE.getToPlayer(it);
                        boolean bl3 = player != null ? !player.isConnected() : false;
                        if (!bl3) break block12;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            } while (bl);
            boolean bl4 = false;
            if (bl4) {
                return -1;
            }
            Player player = targetPlayer = this.getToPlayer(numberedPlayers.get(targetNum));
            boolean bl5 = player != null ? player.isConnected() : false;
            if (bl5) {
                return targetNum;
            }
            targetNum = (targetNum - 1) % numberedPlayers.size();
            return this.getNextIndex(targetNum + 1);
        }
        catch (IndexOutOfBoundsException e) {
            SwapperPlugin.Companion.getInstance().getComponentLogger().error("[getNextIndex] \ud50c\ub808\uc774\uc5b4 \uc778\ub371\uc2a4 \ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            SwapperPlugin.Companion.getInstance().getComponentLogger().error("[getNextIndex] \uc54c \uc218 \uc5c6\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            e.printStackTrace();
            return -1;
        }
    }

    public final void updateConfigPlayers() {
        SwapperConfig.INSTANCE.setNumberedPlayers(numberedPlayers);
    }

    public final void setupStartupTask() {
        this.setupWorldSettings();
    }

    private final void setupWorldSettings() {
        for (World world : SwapperPlugin.Companion.getInstance().getServer().getWorlds()) {
            world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
            world.setGameRule(GameRule.REDUCED_DEBUG_INFO, (Object)true);
            world.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
            world.setDifficulty(Difficulty.EASY);
        }
    }

    @Nullable
    public final Player getToPlayer(@NotNull UUID $this$toPlayer) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlayer, (String)"<this>");
        return SwapperConsts.INSTANCE.getServer().getPlayer($this$toPlayer);
    }

    static {
        Object[] objectArray = new String[]{"389c4c9b-6342-42fc-beb3-922a7d7a72f9", "d5226a1c-d720-456a-a0ba-a642ad07ef02", "762dea11-9c45-4b18-95fc-a86aab3b39ee", "07b373d1-d7b7-49a3-bc87-4ed74271da72"};
        bypassExclusions = CollectionsKt.mutableListOf((Object[])objectArray);
        meltedPlayers = new ArrayList();
    }
}

