/*
 * Decompiled with CFR 0.152.
 */
package me.prdis.swapper.plugin.objects;

import io.papermc.paper.ban.BanListType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.prdis.swapper.plugin.config.SwapperConfig;
import me.prdis.swapper.plugin.objects.SwapperConsts;
import me.prdis.swapper.plugin.objects.SwapperImpl;
import me.prdis.swapper.plugin.tasks.SwapperTimer;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00020\u0005*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lme/prdis/swapper/plugin/objects/SwapperGameManager;", "", "<init>", "()V", "isGameRunning", "", "()Z", "setGameRunning", "(Z)V", "isResumeNeeded", "setResumeNeeded", "isGameFrozen", "setGameFrozen", "hunterUUID", "", "getHunterUUID", "()Ljava/lang/String;", "setHunterUUID", "(Ljava/lang/String;)V", "isHunter", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)Z", "startGame", "", "resumeGame", "stopGame", "stopWithNextResume", "swapper"})
@SourceDebugExtension(value={"SMAP\nSwapperGameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwapperGameManager.kt\nme/prdis/swapper/plugin/objects/SwapperGameManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1915#2,2:103\n1915#2,2:105\n*S KotlinDebug\n*F\n+ 1 SwapperGameManager.kt\nme/prdis/swapper/plugin/objects/SwapperGameManager\n*L\n79#1:103,2\n85#1:105,2\n*E\n"})
public final class SwapperGameManager {
    @NotNull
    public static final SwapperGameManager INSTANCE = new SwapperGameManager();
    private static boolean isGameRunning;
    private static boolean isResumeNeeded;
    private static boolean isGameFrozen;
    @NotNull
    private static String hunterUUID;

    private SwapperGameManager() {
    }

    public final boolean isGameRunning() {
        return isGameRunning;
    }

    public final void setGameRunning(boolean bl) {
        isGameRunning = bl;
    }

    public final boolean isResumeNeeded() {
        return isResumeNeeded;
    }

    public final void setResumeNeeded(boolean bl) {
        isResumeNeeded = bl;
    }

    public final boolean isGameFrozen() {
        return isGameFrozen;
    }

    public final void setGameFrozen(boolean bl) {
        isGameFrozen = bl;
    }

    @NotNull
    public final String getHunterUUID() {
        return hunterUUID;
    }

    public final void setHunterUUID(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        hunterUUID = string;
    }

    public final boolean isHunter(@NotNull Player $this$isHunter) {
        Intrinsics.checkNotNullParameter((Object)$this$isHunter, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isHunter.getUniqueId().toString(), (Object)hunterUUID);
    }

    public final void startGame() {
        isGameRunning = true;
        SwapperConfig.INSTANCE.setIsGameRunning(true);
        SwapperImpl.INSTANCE.initializeViewerPlayer();
        SwapperImpl.INSTANCE.setupStartupTask();
        SwapperImpl.INSTANCE.grantPlayerNumbers();
        SwapperImpl.INSTANCE.assignPlayerNames();
        SwapperImpl.INSTANCE.initializeScoreboard();
        SwapperTimer.INSTANCE.initiate();
    }

    public final void resumeGame() {
        isGameRunning = true;
        isResumeNeeded = false;
        SwapperConfig.INSTANCE.setIsGameRunning(true);
        SwapperImpl.INSTANCE.initializeScoreboard();
    }

    public final void stopGame(boolean stopWithNextResume) {
        isGameRunning = false;
        isResumeNeeded = stopWithNextResume;
        isGameFrozen = false;
        hunterUUID = "";
        SwapperConfig.INSTANCE.setIsGameRunning(stopWithNextResume);
        if (!stopWithNextResume) {
            SwapperImpl.INSTANCE.revokePlayerNames();
            SwapperImpl.INSTANCE.clearPlayerNumbers();
            Object object = SwapperConsts.INSTANCE.getPlugin().getConfig().getConfigurationSection("name");
            if (object != null && (object = object.getKeys(true)) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    SwapperConsts.INSTANCE.getPlugin().getConfig().set("name." + it, null);
                }
            }
            BanList banList = SwapperConsts.INSTANCE.getServer().getBanList(BanListType.PROFILE);
            Intrinsics.checkNotNullExpressionValue((Object)banList, (String)"getBanList(...)");
            ProfileBanList banlist = (ProfileBanList)banList;
            Set set = banlist.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getEntries(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BanEntry it = (BanEntry)element$iv;
                boolean bl = false;
                it.remove();
            }
            SwapperConfig.INSTANCE.setNumberedPlayers(null);
            SwapperConfig.INSTANCE.setRemainingTicks(1200);
            SwapperConfig.INSTANCE.setHunterUUIDString(null);
        } else {
            SwapperConfig.INSTANCE.setNumberedPlayers(SwapperImpl.INSTANCE.getNumberedPlayers());
            SwapperConfig.INSTANCE.setRemainingTicks(SwapperTimer.INSTANCE.getRemainingTick());
        }
        SwapperImpl.INSTANCE.destroyScoreboard();
        SwapperTimer.INSTANCE.destroy();
        SwapperConsts.INSTANCE.getPlugin().saveConfig();
    }

    public static /* synthetic */ void stopGame$default(SwapperGameManager swapperGameManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        swapperGameManager.stopGame(bl);
    }

    static {
        hunterUUID = "";
    }
}

