/*
 * Decompiled with CFR 0.152.
 */
package me.prdis.swapper.plugin;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.prdis.swapper.plugin.commands.SwapperCommand;
import me.prdis.swapper.plugin.config.SwapperConfig;
import me.prdis.swapper.plugin.events.SwapperEvent;
import me.prdis.swapper.plugin.objects.SwapperConsts;
import me.prdis.swapper.plugin.objects.SwapperGameManager;
import me.prdis.swapper.plugin.objects.SwapperImpl;
import me.prdis.swapper.plugin.tasks.SwapperTimer;
import net.kyori.adventure.text.Component;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lme/prdis/swapper/plugin/SwapperPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "onEnable", "", "onDisable", "Companion", "swapper"})
public final class SwapperPlugin
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static SwapperPlugin instance;

    public void onEnable() {
        instance = this;
        if (SwapperConfig.INSTANCE.getIsGameRunning()) {
            SwapperGameManager.INSTANCE.setGameRunning(true);
            SwapperGameManager.INSTANCE.setResumeNeeded(true);
            List<UUID> configNumPlayers = SwapperConfig.INSTANCE.getNumberedPlayers();
            if (configNumPlayers == null) {
                SwapperConsts.INSTANCE.getPlugin().getComponentLogger().error((Component)Component.text((String)"An error occurred while resuming the game: config numberedPlayers is null"));
                return;
            }
            SwapperImpl.INSTANCE.getNumberedPlayers().addAll((Collection<UUID>)configNumPlayers);
            String hunterUUIDString = SwapperConfig.INSTANCE.getHunterUUIDString();
            if (hunterUUIDString == null) {
                SwapperConsts.INSTANCE.getPlugin().getComponentLogger().error((Component)Component.text((String)"An error occurred while resuming the game: config hunterUUID is null"));
                return;
            }
            SwapperGameManager.INSTANCE.setHunterUUID(hunterUUIDString);
            SwapperTimer.INSTANCE.setRemainingTick(SwapperConfig.INSTANCE.getRemainingTicks());
            SwapperTimer.INSTANCE.initiate();
        }
        this.getServer().getPluginManager().registerEvents((Listener)SwapperEvent.INSTANCE, (Plugin)this);
        SwapperCommand.INSTANCE.registerCommands();
        SwapperImpl.INSTANCE.setupStartupTask();
    }

    public void onDisable() {
        SwapperGameManager.INSTANCE.stopGame(SwapperGameManager.INSTANCE.isGameRunning());
        this.saveConfig();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/prdis/swapper/plugin/SwapperPlugin$Companion;", "", "<init>", "()V", "value", "Lme/prdis/swapper/plugin/SwapperPlugin;", "instance", "getInstance", "()Lme/prdis/swapper/plugin/SwapperPlugin;", "swapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SwapperPlugin getInstance() {
            SwapperPlugin swapperPlugin = instance;
            if (swapperPlugin != null) {
                return swapperPlugin;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

