/*
 * Decompiled with CFR 0.152.
 */
package me.prdis.hardcore.plugin.objects;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.ban.BanListType;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.prdis.hardcore.plugin.config.HardcoreCorpseData;
import me.prdis.hardcore.plugin.events.HardcoreEvent;
import me.prdis.hardcore.plugin.objects.HardcoreConsts;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.BanEntry;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020!H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lme/prdis/hardcore/plugin/objects/HardcoreImpl;", "", "<init>", "()V", "isRunning", "", "()Z", "setRunning", "(Z)V", "linkedInventory", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lorg/bukkit/inventory/Inventory;", "getLinkedInventory", "()Ljava/util/HashMap;", "corpses", "Ljava/util/ArrayList;", "Lme/prdis/hardcore/plugin/config/HardcoreCorpseData;", "Lkotlin/collections/ArrayList;", "getCorpses", "()Ljava/util/ArrayList;", "usableUnbans", "", "getUsableUnbans", "()I", "setUsableUnbans", "(I)V", "completedRootAdvancements", "", "", "getCompletedRootAdvancements", "()Ljava/util/List;", "start", "", "resumption", "stop", "setupWorlds", "createCorpseNpcFromData", "corpseData", "createCorpseInventory", "player", "Lorg/bukkit/entity/Player;", "createCorpseNPC", "deathLocation", "Lorg/bukkit/Location;", "hardcore"})
@SourceDebugExtension(value={"SMAP\nHardcoreImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HardcoreImpl.kt\nme/prdis/hardcore/plugin/objects/HardcoreImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2:150\n774#2:151\n865#2,2:152\n1869#2,2:154\n1870#2:156\n1869#2,2:157\n1869#2,2:159\n*S KotlinDebug\n*F\n+ 1 HardcoreImpl.kt\nme/prdis/hardcore/plugin/objects/HardcoreImpl\n*L\n76#1:150\n77#1:151\n77#1:152,2\n79#1:154,2\n76#1:156\n84#1:157,2\n100#1:159,2\n*E\n"})
public final class HardcoreImpl {
    @NotNull
    public static final HardcoreImpl INSTANCE = new HardcoreImpl();
    private static boolean isRunning;
    @NotNull
    private static final HashMap<UUID, Inventory> linkedInventory;
    @NotNull
    private static final ArrayList<HardcoreCorpseData> corpses;
    private static int usableUnbans;
    @NotNull
    private static final List<String> completedRootAdvancements;

    private HardcoreImpl() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    @NotNull
    public final HashMap<UUID, Inventory> getLinkedInventory() {
        return linkedInventory;
    }

    @NotNull
    public final ArrayList<HardcoreCorpseData> getCorpses() {
        return corpses;
    }

    public final int getUsableUnbans() {
        return usableUnbans;
    }

    public final void setUsableUnbans(int n) {
        usableUnbans = n;
    }

    @NotNull
    public final List<String> getCompletedRootAdvancements() {
        return completedRootAdvancements;
    }

    public final void start(boolean resumption) {
        this.setupWorlds();
        HardcoreConsts.INSTANCE.getServer().getPluginManager().registerEvents((Listener)HardcoreEvent.INSTANCE, (Plugin)HardcoreConsts.INSTANCE.getPlugin());
        if (!resumption) {
            isRunning = true;
            usableUnbans = 0;
            corpses.clear();
            completedRootAdvancements.clear();
            HardcoreConsts.INSTANCE.getPlugin().getConfig().set("isRunning", (Object)true);
            HardcoreConsts.INSTANCE.getPlugin().getConfig().set("usableUnbans", (Object)0);
            HardcoreConsts.INSTANCE.getPlugin().getConfig().set("completedRootAdvancements", (Object)CollectionsKt.emptyList());
            HardcoreConsts.INSTANCE.getPlugin().saveConfig();
        }
    }

    public static /* synthetic */ void start$default(HardcoreImpl hardcoreImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        hardcoreImpl.start(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void stop() {
        World it;
        HandlerList.unregisterAll((Listener)HardcoreEvent.INSTANCE);
        List list = HardcoreConsts.INSTANCE.getServer().getWorlds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWorlds(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            it = (World)element$iv;
            boolean bl = false;
            List list2 = it.getEntities();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntities(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entity e = (Entity)element$iv$iv;
                boolean bl2 = false;
                if (!(e instanceof Mannequin && ((Mannequin)e).getPersistentDataContainer().has(HardcoreConsts.INSTANCE.getHARDCORE_NPC_KEY()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Entity e = (Entity)element$iv2;
                boolean bl3 = false;
                e.remove();
            }
        }
        Set set = ((ProfileBanList)HardcoreConsts.INSTANCE.getServer().getBanList(BanListType.PROFILE)).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getEntries(...)");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (BanEntry)element$iv;
            boolean bl = false;
            it.remove();
        }
        usableUnbans = 0;
        corpses.clear();
        completedRootAdvancements.clear();
        HardcoreConsts.INSTANCE.getPlugin().getConfig().set("isRunning", (Object)false);
        HardcoreConsts.INSTANCE.getPlugin().getConfig().set("corpses", null);
        HardcoreConsts.INSTANCE.getPlugin().getConfig().set("usableUnbans", (Object)0);
        HardcoreConsts.INSTANCE.getPlugin().getConfig().set("completedRootAdvancements", null);
        HardcoreConsts.INSTANCE.getPlugin().saveConfig();
    }

    private final void setupWorlds() {
        List list = HardcoreConsts.INSTANCE.getServer().getWorlds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWorlds(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            World it = (World)element$iv;
            boolean bl = false;
            it.setGameRule(GameRule.KEEP_INVENTORY, (Object)true);
            it.setGameRule(GameRule.REDUCED_DEBUG_INFO, (Object)true);
            it.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
            it.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
        }
    }

    private final void createCorpseNpcFromData(HardcoreCorpseData corpseData) {
        World world = corpseData.getLocation().getWorld();
        Entity entity = world.spawn(corpseData.getLocation(), Mannequin.class);
        Mannequin $this$createCorpseNpcFromData_u24lambda_u240 = (Mannequin)entity;
        boolean bl = false;
        $this$createCorpseNpcFromData_u24lambda_u240.setProfile(ResolvableProfile.resolvableProfile((PlayerProfile)$this$createCorpseNpcFromData_u24lambda_u240.getServer().createProfileExact(corpseData.getUniqueId(), corpseData.getName())));
        $this$createCorpseNpcFromData_u24lambda_u240.customName((Component)Component.text((String)(corpseData.getName() + "\uc758 \uc2dc\uccb4")));
        $this$createCorpseNpcFromData_u24lambda_u240.setDescription(null);
        $this$createCorpseNpcFromData_u24lambda_u240.setPose(Pose.SLEEPING, true);
        $this$createCorpseNpcFromData_u24lambda_u240.setInvulnerable(true);
        $this$createCorpseNpcFromData_u24lambda_u240.setImmovable(true);
        $this$createCorpseNpcFromData_u24lambda_u240.getPersistentDataContainer().set(HardcoreConsts.INSTANCE.getHARDCORE_NPC_KEY(), PersistentDataType.BOOLEAN, (Object)true);
        Entity entity2 = entity;
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"apply(...)");
        Mannequin npc = (Mannequin)entity2;
        ((Map)linkedInventory).put(npc.getUniqueId(), corpseData.getInventory());
        ((Collection)corpses).add(HardcoreCorpseData.Companion.from(npc, corpseData.getUniqueId(), corpseData.getName()));
        HardcoreConsts.INSTANCE.getPlugin().getConfig().set("corpses", corpses);
        HardcoreConsts.INSTANCE.getPlugin().saveConfig();
    }

    private final Inventory createCorpseInventory(Player player) {
        Inventory inventory;
        Inventory inventory2 = HardcoreConsts.INSTANCE.getServer().createInventory(null, 45, (Component)Component.text((String)(player.getName() + "\uc758 \uc2dc\uccb4"), (TextColor)((TextColor)NamedTextColor.DARK_GRAY)));
        Intrinsics.checkNotNullExpressionValue((Object)inventory2, (String)"createInventory(...)");
        Inventory $this$createCorpseInventory_u24lambda_u240 = inventory = inventory2;
        boolean bl = false;
        ItemStack[] itemStackArray = new ItemStack[45];
        Inventory inventory3 = $this$createCorpseInventory_u24lambda_u240;
        for (int i = 0; i < 45; ++i) {
            int n = i;
            itemStackArray[n] = n < 41 ? player.getInventory().getContents()[n] : new ItemStack(Material.AIR);
        }
        inventory3.setContents(itemStackArray);
        return inventory;
    }

    public final void createCorpseNPC(@NotNull Player player, @NotNull Location deathLocation) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)deathLocation, (String)"deathLocation");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        Inventory inventory = this.createCorpseInventory(player);
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.createCorpseNpcFromData(new HardcoreCorpseData(deathLocation, uUID, inventory, string));
    }

    static {
        linkedInventory = new HashMap();
        corpses = new ArrayList();
        completedRootAdvancements = new ArrayList();
    }
}

