/*
 * Decompiled with CFR 0.152.
 */
package me.prdis.chasingtails.plugin.objects;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import me.prdis.chasingtails.plugin.objects.ChasingtailsConsts;
import me.prdis.chasingtails.plugin.objects.ChasingtailsImpl;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020.J\u0018\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020\u00002\b\b\u0002\u0010F\u001a\u00020\u001aJ\u000e\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020A2\u0006\u0010H\u001a\u00020=J\u000e\u0010K\u001a\u00020A2\u0006\u0010L\u001a\u00020.J\u000e\u0010M\u001a\u00020A2\u0006\u0010E\u001a\u00020\u0003J\b\u0010N\u001a\u00020AH\u0002J\f\u0010O\u001a\u00020P*\u00020PH\u0002J\u0013\u0010Q\u001a\u00020\u001a2\b\u0010R\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010S\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00008FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020(\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0018\u00103\u001a\t\u0018\u000104\u00a2\u0006\u0002\b58F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u0002098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006T"}, d2={"Lme/prdis/chasingtails/plugin/objects/GamePlayer;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "uniqueId", "Ljava/util/UUID;", "Lorg/jetbrains/annotations/NotNull;", "getUniqueId", "()Ljava/util/UUID;", "offlinePlayer", "Lorg/bukkit/OfflinePlayer;", "getOfflinePlayer", "()Lorg/bukkit/OfflinePlayer;", "target", "getTarget", "()Lme/prdis/chasingtails/plugin/objects/GamePlayer;", "setTarget", "(Lme/prdis/chasingtails/plugin/objects/GamePlayer;)V", "master", "getMaster", "setMaster", "farAwayWithMaster", "", "getFarAwayWithMaster", "()Z", "setFarAwayWithMaster", "(Z)V", "isTemporaryDeath", "deathTimer", "Lorg/bukkit/entity/TextDisplay;", "getDeathTimer", "()Lorg/bukkit/entity/TextDisplay;", "setDeathTimer", "(Lorg/bukkit/entity/TextDisplay;)V", "lastGameDamageData", "Lkotlin/Pair;", "", "getLastGameDamageData", "()Lkotlin/Pair;", "setLastGameDamageData", "(Lkotlin/Pair;)V", "tempDeathDuration", "", "getTempDeathDuration", "()I", "setTempDeathDuration", "(I)V", "team", "Lorg/bukkit/scoreboard/Team;", "Lorg/jetbrains/annotations/Nullable;", "getTeam", "()Lorg/bukkit/scoreboard/Team;", "color", "Lnet/kyori/adventure/text/format/TextColor;", "getColor", "()Lnet/kyori/adventure/text/format/TextColor;", "koreanColor", "", "getKoreanColor", "()Ljava/lang/String;", "revive", "", "deathTimerUpdate", "value", "enslave", "slave", "inherited", "sendMessage", "message", "Lnet/kyori/adventure/text/ComponentLike;", "alert", "temporaryDeath", "duration", "equipSlaveArmor", "initializeAsSlave", "applyColorToArmor", "Lorg/bukkit/inventory/ItemStack;", "equals", "other", "hashCode", "chasing-tails"})
@SourceDebugExtension(value={"SMAP\nGamePlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GamePlayer.kt\nme/prdis/chasingtails/plugin/objects/GamePlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,202:1\n1#2:203\n1869#3,2:204\n1788#3,4:206\n1869#3,2:210\n37#4,2:212\n*S KotlinDebug\n*F\n+ 1 GamePlayer.kt\nme/prdis/chasingtails/plugin/objects/GamePlayer\n*L\n121#1:204,2\n143#1:206,4\n159#1:210,2\n194#1:212,2\n*E\n"})
public final class GamePlayer {
    @NotNull
    private final Player player;
    @NotNull
    private final UUID uniqueId;
    @NotNull
    private GamePlayer target;
    @Nullable
    private GamePlayer master;
    private boolean farAwayWithMaster;
    @Nullable
    private TextDisplay deathTimer;
    @Nullable
    private Pair<GamePlayer, Long> lastGameDamageData;
    private int tempDeathDuration;

    public GamePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        this.uniqueId = uUID;
        this.target = this;
        this.tempDeathDuration = -1;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final UUID getUniqueId() {
        return this.uniqueId;
    }

    @NotNull
    public final OfflinePlayer getOfflinePlayer() {
        OfflinePlayer offlinePlayer = ChasingtailsConsts.INSTANCE.getServer().getOfflinePlayer(this.player.getUniqueId());
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
        return offlinePlayer;
    }

    @NotNull
    public final GamePlayer getTarget() {
        GamePlayer gamePlayer = this.master;
        if (gamePlayer == null || (gamePlayer = gamePlayer.getTarget()) == null) {
            gamePlayer = this.target;
        }
        return gamePlayer;
    }

    public final void setTarget(@NotNull GamePlayer gamePlayer) {
        Intrinsics.checkNotNullParameter((Object)gamePlayer, (String)"<set-?>");
        this.target = gamePlayer;
    }

    @Nullable
    public final GamePlayer getMaster() {
        return this.master;
    }

    public final void setMaster(@Nullable GamePlayer gamePlayer) {
        this.master = gamePlayer;
    }

    public final boolean getFarAwayWithMaster() {
        return this.farAwayWithMaster;
    }

    public final void setFarAwayWithMaster(boolean bl) {
        this.farAwayWithMaster = bl;
    }

    public final boolean isTemporaryDeath() {
        return this.tempDeathDuration > 0;
    }

    @Nullable
    public final TextDisplay getDeathTimer() {
        return this.deathTimer;
    }

    public final void setDeathTimer(@Nullable TextDisplay textDisplay) {
        this.deathTimer = textDisplay;
    }

    @Nullable
    public final Pair<GamePlayer, Long> getLastGameDamageData() {
        return this.lastGameDamageData;
    }

    public final void setLastGameDamageData(@Nullable Pair<GamePlayer, Long> pair) {
        this.lastGameDamageData = pair;
    }

    public final int getTempDeathDuration() {
        return this.tempDeathDuration;
    }

    public final void setTempDeathDuration(int n) {
        this.tempDeathDuration = n;
    }

    @Nullable
    public final Team getTeam() {
        return ChasingtailsImpl.INSTANCE.getScoreboard().getPlayerTeam(this.getOfflinePlayer());
    }

    @NotNull
    public final TextColor getColor() {
        Team team = this.getTeam();
        if (team == null) {
            NamedTextColor namedTextColor = NamedTextColor.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"WHITE");
            return (TextColor)namedTextColor;
        }
        Team team2 = team;
        if (!team2.hasColor()) {
            NamedTextColor namedTextColor = NamedTextColor.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"WHITE");
            return (TextColor)namedTextColor;
        }
        TextColor textColor = team2.color();
        Intrinsics.checkNotNullExpressionValue((Object)textColor, (String)"color(...)");
        return textColor;
    }

    @NotNull
    public final String getKoreanColor() {
        String string = (String)((Map)ChasingtailsImpl.INSTANCE.getMappedColors()).get(this.getColor());
        if (string == null) {
            string = "\ud558\uc580\uc0c9";
        }
        return string;
    }

    public final void revive() {
        Location masterLocation;
        TextDisplay textDisplay = this.deathTimer;
        if (textDisplay != null) {
            textDisplay.remove();
        }
        this.deathTimer = null;
        this.player.playEffect(EntityEffect.PROTECTED_FROM_DEATH);
        Object[] objectArray = new PotionEffect[]{new PotionEffect(PotionEffectType.RESISTANCE, 100, 1, false, false, false), new PotionEffect(PotionEffectType.REGENERATION, 900, 1, false, false, false), new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 800, 0, false, false, false)};
        this.player.addPotionEffects((Collection)CollectionsKt.listOf((Object[])objectArray));
        TextComponent textComponent = Component.text((String)"\ubd80\ud65c\ud558\uc168\uc2b5\ub2c8\ub2e4!");
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        this.sendMessage((ComponentLike)textComponent);
        GamePlayer gamePlayer = this.master;
        Location location = gamePlayer != null && (gamePlayer = gamePlayer.player) != null ? gamePlayer.getLocation() : (masterLocation = null);
        if (masterLocation != null) {
            this.initializeAsSlave();
            this.player.teleport(masterLocation);
        }
    }

    public final void deathTimerUpdate(int value) {
        String string;
        Entity entity;
        TextDisplay textDisplay = this.deathTimer;
        if (textDisplay == null) {
            entity = this.player.getWorld().spawn(this.player.getLocation().add(0.0, 2.3, 0.0), TextDisplay.class, arg_0 -> GamePlayer.deathTimerUpdate$lambda$1(arg_0 -> GamePlayer.deathTimerUpdate$lambda$0(this, arg_0), arg_0));
            TextDisplay it = (TextDisplay)entity;
            boolean bl = false;
            this.deathTimer = it;
            string = entity;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"also(...)");
            textDisplay = (TextDisplay)string;
        }
        TextDisplay deathTimer = textDisplay;
        string = "%.1f";
        entity = new Entity[]{Double.valueOf((double)value / 20.0)};
        String string2 = String.format(string, Arrays.copyOf(entity, ((Entity)entity).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        deathTimer.text((Component)Component.text((String)("\ubd80\ud65c\uae4c\uc9c0 " + string2 + "\ucd08"), (TextColor)((TextColor)NamedTextColor.YELLOW)));
    }

    /*
     * WARNING - void declaration
     */
    public final void enslave(@NotNull GamePlayer slave, boolean inherited) {
        block8: {
            int n;
            Intrinsics.checkNotNullParameter((Object)slave, (String)"slave");
            this.target = slave.getTarget();
            slave.master = this;
            this.equipSlaveArmor(slave.player);
            if (!inherited) {
                ItemStack[] $this$forEach$iv = (ItemStack[])ChasingtailsImpl.INSTANCE.getGamePlayers();
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    GamePlayer it = (GamePlayer)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.master, (Object)slave)) continue;
                    this.enslave(it, true);
                }
                slave.initializeAsSlave();
                slave.player.playEffect(EntityEffect.PROTECTED_FROM_DEATH);
                slave.player.sendMessage(((TextComponent)Component.text((String)"\ucc98\uce58\ub2f9\ud558\uc168\uc2b5\ub2c8\ub2e4! \uc55e\uc73c\ub85c ").append((Component)Component.text((String)this.player.getName(), (TextColor)this.getColor()))).append((Component)Component.text((String)"\ub2d8\uc758 \uaf2c\ub9ac\uac00 \ub429\ub2c8\ub2e4.", (TextColor)((TextColor)NamedTextColor.WHITE))));
                $this$forEach$iv = new ItemStack[]{new ItemStack(Material.COMPASS)};
                slave.player.getInventory().addItem($this$forEach$iv);
                Component component = ((TextComponent)Component.text((String)"\ubaa9\ud45c\ub97c \ucc98\uce58\ud558\ub294\ub370 \uc131\uacf5\ud558\uc168\uc2b5\ub2c8\ub2e4! ").append((Component)Component.text((String)slave.player.getName(), (TextColor)slave.getColor()))).append((Component)Component.text((String)"\ub2d8\uc774 \uaf2c\ub9ac\uac00 \ub429\ub2c8\ub2e4."));
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"append(...)");
                this.sendMessage((ComponentLike)component);
            }
            Team team = ChasingtailsImpl.INSTANCE.getScoreboard().getPlayerTeam(slave.getOfflinePlayer());
            if (team != null) {
                team.unregister();
            }
            Team team2 = ChasingtailsImpl.INSTANCE.getScoreboard().getPlayerTeam(this.getOfflinePlayer());
            if (team2 != null) {
                team2.addEntry(slave.player.getName());
            }
            Iterable $this$count$iv = ChasingtailsImpl.INSTANCE.getGamePlayers();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var6_11;
                boolean bl = false;
                for (Object element$iv : $this$count$iv) {
                    GamePlayer it = (GamePlayer)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.master, (Object)this) || ++var6_11 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var6_11;
            }
            int slaves = n;
            AttributeInstance attributeInstance = this.player.getAttribute(Attribute.MAX_HEALTH);
            if (attributeInstance != null) {
                attributeInstance.setBaseValue((double)RangesKt.coerceAtLeast((int)(20 - slaves * 2), (int)1));
            }
            TextDisplay textDisplay = slave.deathTimer;
            if (textDisplay == null) break block8;
            textDisplay.remove();
        }
    }

    public static /* synthetic */ void enslave$default(GamePlayer gamePlayer, GamePlayer gamePlayer2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        gamePlayer.enslave(gamePlayer2, bl);
    }

    public final void sendMessage(@NotNull ComponentLike message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.player.sendMessage(message);
    }

    public final void alert(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TextComponent textComponent = Component.text((String)message, (TextColor)((TextColor)NamedTextColor.RED));
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        this.sendMessage((ComponentLike)textComponent);
    }

    public final void temporaryDeath(int duration) {
        Player player;
        Player $this$temporaryDeath_u24lambda_u240 = player = this.player;
        boolean bl = false;
        AttributeInstance attributeInstance = $this$temporaryDeath_u24lambda_u240.getAttribute(Attribute.MAX_HEALTH);
        $this$temporaryDeath_u24lambda_u240.setHealth(attributeInstance != null ? attributeInstance.getValue() : 20.0);
        $this$temporaryDeath_u24lambda_u240.setFoodLevel(20);
        $this$temporaryDeath_u24lambda_u240.setSaturation(3.0f);
        $this$temporaryDeath_u24lambda_u240.setExhaustion(0.0f);
        Collection collection = $this$temporaryDeath_u24lambda_u240.getWorld().getNearbyLivingEntities($this$temporaryDeath_u24lambda_u240.getLocation(), 30.0);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNearbyLivingEntities(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl2 = false;
            if (!(it instanceof Mob)) continue;
            LivingEntity livingEntity = ((Mob)it).getTarget();
            if (!Intrinsics.areEqual((Object)(livingEntity != null ? livingEntity.getUniqueId() : null), (Object)$this$temporaryDeath_u24lambda_u240.getUniqueId())) continue;
            ((Mob)it).setTarget(null);
        }
        this.tempDeathDuration = duration;
        this.farAwayWithMaster = false;
    }

    public final void equipSlaveArmor(@NotNull Player slave) {
        PlayerInventory playerInventory;
        Intrinsics.checkNotNullParameter((Object)slave, (String)"slave");
        PlayerInventory $this$equipSlaveArmor_u24lambda_u240 = playerInventory = slave.getInventory();
        boolean bl = false;
        $this$equipSlaveArmor_u24lambda_u240.setHelmet(this.applyColorToArmor(new ItemStack(Material.LEATHER_HELMET)));
        $this$equipSlaveArmor_u24lambda_u240.setChestplate(this.applyColorToArmor(new ItemStack(Material.LEATHER_CHESTPLATE)));
        $this$equipSlaveArmor_u24lambda_u240.setLeggings(this.applyColorToArmor(new ItemStack(Material.LEATHER_LEGGINGS)));
        $this$equipSlaveArmor_u24lambda_u240.setBoots(this.applyColorToArmor(new ItemStack(Material.LEATHER_BOOTS)));
    }

    private final void initializeAsSlave() {
        Player player;
        Player $this$initializeAsSlave_u24lambda_u240 = player = this.player;
        boolean bl = false;
        $this$initializeAsSlave_u24lambda_u240.setHealth(10.0);
        AttributeInstance attributeInstance = $this$initializeAsSlave_u24lambda_u240.getAttribute(Attribute.MAX_HEALTH);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(10.0);
        }
        $this$initializeAsSlave_u24lambda_u240.setFoodLevel(20);
        $this$initializeAsSlave_u24lambda_u240.setSaturation(3.0f);
        $this$initializeAsSlave_u24lambda_u240.setExhaustion(0.0f);
    }

    private final ItemStack applyColorToArmor(ItemStack $this$applyColorToArmor) {
        ItemStack itemStack;
        ItemStack $this$applyColorToArmor_u24lambda_u240 = itemStack = $this$applyColorToArmor;
        boolean bl = false;
        $this$applyColorToArmor_u24lambda_u240.editMeta(arg_0 -> GamePlayer.applyColorToArmor$lambda$0$1(arg_0 -> GamePlayer.applyColorToArmor$lambda$0$0(this, arg_0), arg_0));
        return itemStack;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GamePlayer && Intrinsics.areEqual((Object)((GamePlayer)other).uniqueId, (Object)this.uniqueId);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    private static final Unit deathTimerUpdate$lambda$0(GamePlayer this$0, TextDisplay it) {
        it.setPersistent(true);
        it.setAlignment(TextDisplay.TextAlignment.CENTER);
        it.setBillboard(Display.Billboard.CENTER);
        this$0.player.addPassenger((Entity)it);
        return Unit.INSTANCE;
    }

    private static final void deathTimerUpdate$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit applyColorToArmor$lambda$0$0(GamePlayer this$0, ItemMeta it) {
        if (it instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)it).setColor(Color.fromRGB((int)this$0.getColor().value()));
        }
        it.setUnbreakable(true);
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ItemFlag[] itemFlagArray = thisCollection$iv.toArray(new ItemFlag[0]);
        it.addItemFlags(Arrays.copyOf(itemFlagArray, itemFlagArray.length));
        it.addEnchant(Enchantment.BINDING_CURSE, 1, true);
        return Unit.INSTANCE;
    }

    private static final void applyColorToArmor$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ItemFlag> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ItemFlag.values()));
        }
    }
}

