/*
 * Decompiled with CFR 0.152.
 */
package com.pandadevv.VelocityShield.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pandadevv.VelocityShield.VelocityShield;
import com.pandadevv.VelocityShield.config.PluginConfig;
import com.pandadevv.VelocityShield.util.IPCache;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class VPNChecker {
    private final PluginConfig config;
    private final IPCache ipCache;
    private static final String PROXYCHECK_URL = "http://proxycheck.io/v2/%s?key=%s&vpn=1";
    private static final String IP_API_URL = "http://ip-api.com/json/%s?fields=status,isp,org,proxy,query";
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int READ_TIMEOUT = 3000;
    private static final int MAX_REQUESTS_PER_SECOND = 10;
    private final AtomicInteger requestCount = new AtomicInteger(0);
    private final AtomicLong lastResetTime = new AtomicLong(System.currentTimeMillis());
    private final ExecutorService executorService;
    private static final JsonParser jsonParser = new JsonParser();

    public VPNChecker(PluginConfig config, Path dataDirectory) {
        this.config = config;
        this.ipCache = new IPCache(config.getCacheDuration(), TimeUnit.valueOf(config.getCacheTimeUnit().toUpperCase()), dataDirectory);
        this.executorService = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public CompletableFuture<Boolean> isVPN(String ip) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean cachedResult;
            if (this.config.isEnableCache() && (cachedResult = this.ipCache.getCachedResult(ip)) != null) {
                if (this.config.isEnableDebug()) {
                    VelocityShield.getInstance().getLogger().info("Using cached result for IP: " + ip + " - VPN: " + cachedResult);
                }
                return cachedResult;
            }
            try {
                this.waitForRateLimit();
                Boolean mainCheckResult = this.checkWithMainService(ip);
                if (mainCheckResult != null) {
                    if (this.config.isEnableCache()) {
                        this.ipCache.cacheResult(ip, mainCheckResult);
                    }
                    return mainCheckResult;
                }
                if (this.config.isEnableFallbackService()) {
                    this.waitForRateLimit();
                    Boolean fallbackResult = this.checkWithFallbackService(ip);
                    if (fallbackResult != null) {
                        if (this.config.isEnableCache()) {
                            this.ipCache.cacheResult(ip, fallbackResult);
                        }
                        return fallbackResult;
                    }
                }
                if (this.config.isAllowJoinOnApiFailure()) {
                    if (this.config.isEnableDebug()) {
                        VelocityShield.getInstance().getLogger().warn("Both VPN checks failed for IP: " + ip + " - Allowing connection due to allow-join-on-api-failure setting");
                    }
                    return false;
                }
                if (this.config.isEnableDebug()) {
                    VelocityShield.getInstance().getLogger().warn("Both VPN checks failed for IP: " + ip + " - Blocking connection due to allow-join-on-api-failure setting");
                }
                return true;
            }
            catch (Exception e) {
                VelocityShield.getInstance().getLogger().error("Error checking VPN status for IP: " + ip, (Throwable)e);
                return !this.config.isAllowJoinOnApiFailure();
            }
        }, this.executorService);
    }

    private void waitForRateLimit() {
        long lastReset;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastReset = this.lastResetTime.get()) >= 1000L) {
            this.requestCount.set(0);
            this.lastResetTime.set(currentTime);
        }
        while (this.requestCount.get() >= 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.requestCount.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean checkWithMainService(String ip) {
        try {
            String url = this.config.isUseProxycheckAsPrimary() ? String.format(PROXYCHECK_URL, ip, this.config.getProxycheckApiKey()) : String.format(IP_API_URL, ip);
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("User-Agent", "VelocityShield/1.0");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                int read;
                StringBuilder response = new StringBuilder();
                char[] buffer = new char[1024];
                while ((read = reader.read(buffer)) != -1) {
                    response.append(buffer, 0, read);
                }
                JsonObject jsonResponse = jsonParser.parse(response.toString()).getAsJsonObject();
                if (this.config.isUseProxycheckAsPrimary()) {
                    if (!jsonResponse.has("status")) return null;
                    if (!jsonResponse.get("status").getAsString().equals("ok")) return null;
                    JsonObject ipData = jsonResponse.getAsJsonObject(ip);
                    if (ipData == null) return null;
                    if (!ipData.has("proxy")) return null;
                    Boolean bl = ipData.get("proxy").getAsString().equals("yes");
                    return bl;
                }
                if (!jsonResponse.has("status")) return null;
                if (!jsonResponse.get("status").getAsString().equals("success")) return null;
                Boolean bl = jsonResponse.has("proxy") && jsonResponse.get("proxy").getAsBoolean();
                return bl;
            }
        }
        catch (Exception e) {
            if (!this.config.isEnableDebug()) return null;
            VelocityShield.getInstance().getLogger().error("Error with main VPN check for IP: " + ip, (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean checkWithFallbackService(String ip) {
        try {
            String url = !this.config.isUseProxycheckAsPrimary() ? String.format(PROXYCHECK_URL, ip, this.config.getProxycheckApiKey()) : String.format(IP_API_URL, ip);
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("User-Agent", "VelocityShield/1.0");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                int read;
                StringBuilder response = new StringBuilder();
                char[] buffer = new char[1024];
                while ((read = reader.read(buffer)) != -1) {
                    response.append(buffer, 0, read);
                }
                JsonObject jsonResponse = jsonParser.parse(response.toString()).getAsJsonObject();
                if (!this.config.isUseProxycheckAsPrimary()) {
                    if (!jsonResponse.has("status")) return null;
                    if (!jsonResponse.get("status").getAsString().equals("ok")) return null;
                    JsonObject ipData = jsonResponse.getAsJsonObject(ip);
                    if (ipData == null) return null;
                    if (!ipData.has("proxy")) return null;
                    Boolean bl = ipData.get("proxy").getAsString().equals("yes");
                    return bl;
                }
                if (!jsonResponse.has("status")) return null;
                if (!jsonResponse.get("status").getAsString().equals("success")) return null;
                Boolean bl = jsonResponse.has("proxy") && jsonResponse.get("proxy").getAsBoolean();
                return bl;
            }
        }
        catch (Exception e) {
            if (!this.config.isEnableDebug()) return null;
            VelocityShield.getInstance().getLogger().error("Error with fallback VPN check for IP: " + ip, (Throwable)e);
        }
        return null;
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

