/*
 * Decompiled with CFR 0.152.
 */
package com.pandadevv.VelocityShield.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pandadevv.VelocityShield.VelocityShield;
import com.velocitypowered.api.proxy.Player;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class UpdateChecker {
    private static final String CURRENT_VERSION = "1.0";
    private boolean updateAvailable = false;
    private String latestVersion = "";
    private final VelocityShield plugin;

    public UpdateChecker(VelocityShield plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        this.plugin.getLogger().info("Checking for VelocityShield updates...");
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            try {
                String line;
                URL url = new URL("https://api.pandadevv.dev/checkupdate/velocityshield/1.0");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.plugin.getLogger().warn("Failed to check for updates. Response code: " + responseCode);
                    return;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonObject jsonResponse = JsonParser.parseString(response.toString()).getAsJsonObject();
                this.updateAvailable = jsonResponse.get("update").getAsBoolean();
                this.latestVersion = jsonResponse.get("currentVersion").getAsString();
                if (this.updateAvailable) {
                    this.plugin.getLogger().warn("==========================================");
                    this.plugin.getLogger().warn("VelocityShield Update Available!");
                    this.plugin.getLogger().warn("Current Version: 1.0");
                    this.plugin.getLogger().warn("Latest Version: " + this.latestVersion);
                    this.plugin.getLogger().warn("Download at: https://builtbybit.com/resources/velocityshield.66897/");
                    this.plugin.getLogger().warn("==========================================");
                    this.plugin.getServer().getAllPlayers().stream().filter(player -> player.hasPermission("velocityshield.admin")).forEach(this::sendUpdateMessage);
                } else {
                    this.plugin.getLogger().info("VelocityShield is up to date! (Version: 1.0)");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).schedule();
    }

    private void sendUpdateMessage(Player player) {
        Object message = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("[VelocityShield] ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text("An update is available! Current version: ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text(CURRENT_VERSION, (TextColor)NamedTextColor.RED))).append((Component)Component.text(" Latest version: ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text(this.latestVersion, (TextColor)NamedTextColor.GREEN))).build();
        player.sendMessage((Component)message);
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

