/*
 * Decompiled with CFR 0.152.
 */
package com.pandadevv.VelocityShield.config;

import com.pandadevv.VelocityShield.VelocityShield;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class PluginConfig {
    private final Path configPath;
    private final Path whitelistPath;
    private final Path logPath;
    private String proxycheckApiKey;
    private String kickMessageTitle;
    private String kickMessageBody;
    private boolean useProxycheckAsPrimary;
    private boolean enableFallbackService;
    private boolean allowJoinOnApiFailure;
    private boolean enableCache;
    private boolean enableDebug;
    private Set<String> whitelistedIps;
    private long cacheDuration;
    private String cacheTimeUnit;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public PluginConfig(Path dataDirectory) {
        this.configPath = dataDirectory.resolve("config.yml");
        this.whitelistPath = dataDirectory.resolve("whitelist.txt");
        this.logPath = dataDirectory.resolve("log.txt");
        try {
            Files.createDirectories(dataDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            VelocityShield.getInstance().getLogger().error("Failed to create plugin directory", (Throwable)e);
        }
        this.loadConfig();
        this.loadWhitelist();
    }

    private void loadConfig() {
        try {
            Map currentConfig;
            String defaultConfigContent;
            try (InputStream in = this.getClass().getResourceAsStream("/config.yml");){
                if (in == null) {
                    VelocityShield.getInstance().getLogger().error("Could not find default config.yml in resources");
                    return;
                }
                defaultConfigContent = new String(in.readAllBytes());
            }
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                Files.writeString(this.configPath, (CharSequence)defaultConfigContent, new OpenOption[0]);
            }
            String currentConfigContent = Files.readString(this.configPath);
            try {
                Yaml yaml = new Yaml();
                currentConfig = (Map)yaml.load(currentConfigContent);
            }
            catch (Exception e) {
                VelocityShield.getInstance().getLogger().error("Failed to parse config", (Throwable)e);
                return;
            }
            this.loadValuesFromConfig(currentConfig);
        }
        catch (IOException e) {
            VelocityShield.getInstance().getLogger().error("Failed to load config", (Throwable)e);
        }
    }

    private void loadValuesFromConfig(Map<String, Object> config) {
        this.proxycheckApiKey = (String)config.getOrDefault("proxycheck-api-key", "YOUR_PROXYCHECK_API_KEY");
        Map kickMessage = config.getOrDefault("kick-message", Map.of());
        this.kickMessageTitle = kickMessage.getOrDefault("title", "<red><bold>VPN Detected!</bold></red>");
        this.kickMessageBody = kickMessage.getOrDefault("message", "<white>Please join without a VPN.</white>\n<white>If this is a false positive, please open a ticket.</white>");
        this.useProxycheckAsPrimary = (Boolean)config.getOrDefault("use-proxycheck-as-primary", true);
        this.enableFallbackService = (Boolean)config.getOrDefault("enable-fallback-service", true);
        this.allowJoinOnApiFailure = (Boolean)config.getOrDefault("allow-join-on-api-failure", true);
        this.enableCache = (Boolean)config.getOrDefault("enable-cache", true);
        this.enableDebug = (Boolean)config.getOrDefault("enable-debug", false);
        this.cacheDuration = ((Number)config.getOrDefault("cache-duration", 10)).longValue();
        this.cacheTimeUnit = (String)config.getOrDefault("cache-time-unit", "SECONDS");
        if (this.proxycheckApiKey.equals("YOUR_PROXYCHECK_API_KEY") && this.useProxycheckAsPrimary) {
            VelocityShield.getInstance().getLogger().warn("===============================================");
            VelocityShield.getInstance().getLogger().warn("VelocityShield is not configured!");
            VelocityShield.getInstance().getLogger().warn("Please set your proxycheck.io API key in config.yml");
            VelocityShield.getInstance().getLogger().warn("Get your API key at: https://proxycheck.io/");
            VelocityShield.getInstance().getLogger().warn("===============================================");
        }
    }

    public void loadWhitelist() {
        this.whitelistedIps = new HashSet<String>();
        if (!Files.exists(this.whitelistPath, new LinkOption[0])) {
            try {
                Files.createFile(this.whitelistPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                VelocityShield.getInstance().getLogger().error("Failed to create whitelist file", (Throwable)e);
            }
        } else {
            try (BufferedReader reader = Files.newBufferedReader(this.whitelistPath);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    this.whitelistedIps.add(line);
                }
            }
            catch (IOException e) {
                VelocityShield.getInstance().getLogger().error("Failed to load whitelist", (Throwable)e);
            }
        }
    }

    public void logVPNDetection(String username, String ip) {
        try {
            String timestamp = LocalDateTime.now().format(DATE_FORMAT);
            String logEntry = String.format("[%s] VPN detected - Username: %s, IP: %s%n", timestamp, username, ip);
            Files.write(this.logPath, logEntry.getBytes(), Files.exists(this.logPath, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            VelocityShield.getInstance().getLogger().error("Failed to write to log file", (Throwable)e);
        }
    }

    public String getProxycheckApiKey() {
        return this.proxycheckApiKey;
    }

    public String getKickMessageTitle() {
        return this.kickMessageTitle;
    }

    public String getKickMessageBody() {
        return this.kickMessageBody;
    }

    public boolean isUseProxycheckAsPrimary() {
        return this.useProxycheckAsPrimary;
    }

    public boolean isEnableFallbackService() {
        return this.enableFallbackService;
    }

    public boolean isAllowJoinOnApiFailure() {
        return this.allowJoinOnApiFailure;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public boolean isIPWhitelisted(String ip) {
        return this.whitelistedIps.contains(ip);
    }

    public void reloadWhitelist() {
        this.loadWhitelist();
    }

    public long getCacheDuration() {
        return this.cacheDuration;
    }

    public String getCacheTimeUnit() {
        return this.cacheTimeUnit;
    }

    public void addToWhitelist(String ip) {
        if (this.whitelistedIps.add(ip)) {
            try {
                Files.write(this.whitelistPath, (ip + "\n").getBytes(), Files.exists(this.whitelistPath, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                VelocityShield.getInstance().getLogger().error("Failed to add IP to whitelist: " + ip, (Throwable)e);
            }
        }
    }

    public void removeFromWhitelist(String ip) {
        if (this.whitelistedIps.remove(ip)) {
            try {
                HashSet<String> lines = new HashSet<String>(Files.readAllLines(this.whitelistPath));
                lines.remove(ip);
                Files.write(this.whitelistPath, lines, new OpenOption[0]);
            }
            catch (IOException e) {
                VelocityShield.getInstance().getLogger().error("Failed to remove IP from whitelist: " + ip, (Throwable)e);
            }
        }
    }

    public void reload() {
        this.loadConfig();
        this.loadWhitelist();
    }
}

