/*
 * Decompiled with CFR 0.152.
 */
package com.pandadevv.VelocityShield;

import com.google.inject.Inject;
import com.pandadevv.VelocityShield.VelocityShield.charts.SingleLineChart;
import com.pandadevv.VelocityShield.VelocityShield.velocity.Metrics;
import com.pandadevv.VelocityShield.config.PluginConfig;
import com.pandadevv.VelocityShield.config.UpdateChecker;
import com.pandadevv.VelocityShield.util.VPNChecker;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.slf4j.Logger;

@Plugin(id="velocityshield", name="VelocityShield", version="1.0.0", description="A VPN detection plugin for Velocity", authors={"PandaDevv"})
public class VelocityShield {
    private static VelocityShield instance;
    private final ProxyServer server;
    private final Logger logger;
    private final velocity.Metrics$Factory metricsFactory;
    private final Path dataDirectory;
    private PluginConfig config;
    private VPNChecker vpnChecker;
    private MiniMessage miniMessage;
    private UpdateChecker updateChecker;
    private final AtomicInteger vpnMitigations = new AtomicInteger(0);

    @Inject
    public VelocityShield(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, velocity.Metrics$Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        instance = this;
        this.miniMessage = MiniMessage.miniMessage();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        int pluginId = 25843;
        Metrics metrics = this.metricsFactory.make(this, pluginId);
        metrics.addCustomChart(new SingleLineChart("vpn_mitigations", () -> this.vpnMitigations.get()));
        this.config = new PluginConfig(this.dataDirectory);
        this.vpnChecker = new VPNChecker(this.config, this.dataDirectory);
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdates();
        CommandManager commandManager = this.server.getCommandManager();
        CommandMeta reloadMeta = commandManager.metaBuilder("velocityshield").aliases(new String[]{"vshield"}).build();
        SimpleCommand reloadCommand = invocation -> {
            if (!invocation.source().hasPermission("velocityshield.reload")) {
                invocation.source().sendMessage(Component.text("You don't have permission to use this command!").color(NamedTextColor.RED));
                return;
            }
            this.config.reload();
            invocation.source().sendMessage(Component.text("Configuration reloaded!").color(NamedTextColor.GREEN));
        };
        CommandMeta whitelistMeta = commandManager.metaBuilder("vshieldwhitelist").aliases(new String[]{"vshieldwl"}).build();
        SimpleCommand whitelistCommand = invocation -> {
            if (!invocation.source().hasPermission("velocityshield.whitelist")) {
                invocation.source().sendMessage(Component.text("You don't have permission to use this command!").color(NamedTextColor.RED));
                return;
            }
            String[] args = (String[])invocation.arguments();
            if (args.length < 2) {
                invocation.source().sendMessage(Component.text("Usage: /vshieldwhitelist <add|remove> <ip>").color(NamedTextColor.RED));
                return;
            }
            String action = args[0].toLowerCase();
            String ip = args[1];
            switch (action) {
                case "add": {
                    this.config.addToWhitelist(ip);
                    invocation.source().sendMessage(Component.text("IP " + ip + " added to whitelist!").color(NamedTextColor.GREEN));
                    break;
                }
                case "remove": {
                    this.config.removeFromWhitelist(ip);
                    invocation.source().sendMessage(Component.text("IP " + ip + " removed from whitelist!").color(NamedTextColor.GREEN));
                    break;
                }
                default: {
                    invocation.source().sendMessage(Component.text("Invalid action! Use 'add' or 'remove'.").color(NamedTextColor.RED));
                }
            }
        };
        commandManager.register(reloadMeta, (Command)reloadCommand);
        commandManager.register(whitelistMeta, (Command)whitelistCommand);
        this.logger.info("VelocityShield has been enabled!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.vpnChecker != null) {
            this.vpnChecker.shutdown();
        }
        this.logger.info("VelocityShield has been disabled!");
    }

    @Subscribe
    public void onPlayerLogin(LoginEvent event) {
        boolean isVPN;
        String ip = event.getPlayer().getRemoteAddress().getAddress().getHostAddress();
        if (event.getPlayer().hasPermission("velocityshield.bypass")) {
            if (this.config.isEnableDebug()) {
                this.logger.info("Player {} has bypass permission, skipping VPN check", (Object)event.getPlayer().getUsername());
            }
            return;
        }
        if (this.config.isIPWhitelisted(ip)) {
            if (this.config.isEnableDebug()) {
                this.logger.info("IP {} is whitelisted, skipping VPN check", (Object)ip);
            }
            return;
        }
        if (this.config.isEnableDebug()) {
            this.logger.info("Player {} connecting from IP: {}", (Object)event.getPlayer().getUsername(), (Object)ip);
        }
        if (isVPN = this.vpnChecker.isVPN(ip).join().booleanValue()) {
            if (this.config.isEnableDebug()) {
                this.logger.info("VPN detected for player {} (IP: {})", (Object)event.getPlayer().getUsername(), (Object)ip);
            }
            this.config.logVPNDetection(event.getPlayer().getUsername(), ip);
            this.vpnMitigations.incrementAndGet();
            Object kickMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(this.miniMessage.deserialize((Object)this.config.getKickMessageTitle()))).append((Component)Component.newline())).append((Component)Component.newline())).append(this.miniMessage.deserialize((Object)this.config.getKickMessageBody()))).build();
            event.setResult(ResultedEvent.ComponentResult.denied((Component)kickMessage));
        } else if (this.config.isEnableDebug()) {
            this.logger.info("No VPN detected for player {} (IP: {})", (Object)event.getPlayer().getUsername(), (Object)ip);
        }
    }

    public static VelocityShield getInstance() {
        return instance;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public PluginConfig getConfig() {
        return this.config;
    }
}

