/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.routes;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import github.scarsz.discordsrv.DiscordSRV;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import ru.padow.discordsrvoauth.Config;
import ru.padow.discordsrvoauth.DiscordSRVOAuth;
import ru.padow.discordsrvoauth.Utils;

public class LinkHandler
implements HttpHandler {
    private Config config = DiscordSRVOAuth.config();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String query = exchange.getRequestURI().getQuery();
        if (query == null || !query.contains("code")) {
            exchange.sendResponseHeaders(400, -1L);
            exchange.close();
            return;
        }
        String code = Utils.queryToMap(query).get("code").replaceAll("[^0-9]", "");
        if (code.length() != 4 || !DiscordSRV.getPlugin().getAccountLinkManager().getLinkingCodes().containsKey(code)) {
            exchange.sendResponseHeaders(400, -1L);
            exchange.close();
            return;
        }
        String token = this.config.getBotToken();
        String redirect_uri = Utils.getBaseURL(this.config, true) + "/callback";
        String url = "https://discord.com/api/oauth2/authorize?client_id=" + this.config.getClientId() + "&redirect_uri=" + URLEncoder.encode(redirect_uri, StandardCharsets.UTF_8) + "&response_type=code&scope=identify" + (token != null && !token.isEmpty() ? "+guilds.join" : "") + "&state=" + code;
        exchange.getResponseHeaders().set("Location", url);
        exchange.sendResponseHeaders(302, -1L);
        exchange.close();
    }
}

