/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.routes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import github.scarsz.discordsrv.DiscordSRV;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import ru.padow.discordsrvoauth.Config;
import ru.padow.discordsrvoauth.DiscordSRVOAuth;
import ru.padow.discordsrvoauth.Utils;

public class CallbackHandler
implements HttpHandler {
    private Config config = DiscordSRVOAuth.config();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String query = exchange.getRequestURI().getQuery();
        if (query == null || !query.contains("code") || !query.contains("state")) {
            exchange.sendResponseHeaders(400, -1L);
            exchange.close();
            return;
        }
        Map<String, String> params = Utils.queryToMap(query);
        final String code = params.get("code");
        String state = params.get("state");
        if (state.length() != 4 || !DiscordSRV.getPlugin().getAccountLinkManager().getLinkingCodes().containsKey(state)) {
            exchange.sendResponseHeaders(403, -1L);
            exchange.close();
            return;
        }
        String tokenResponse = null;
        try {
            tokenResponse = Utils.post("https://discord.com/api/oauth2/token", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("client_id", String.valueOf(CallbackHandler.this.config.getClientId()));
                    this.put("client_secret", CallbackHandler.this.config.getClientSecret());
                    this.put("grant_type", "authorization_code");
                    this.put("code", code);
                    this.put("redirect_uri", Utils.getBaseURL(CallbackHandler.this.config, true) + "/callback");
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String accessToken = JsonParser.parseString(tokenResponse).getAsJsonObject().get("access_token").getAsString();
        String userResponse = null;
        try {
            userResponse = Utils.get("https://discord.com/api/users/@me", accessToken);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JsonObject userJson = JsonParser.parseString((String)userResponse).getAsJsonObject();
        String id = userJson.get("id").getAsString();
        if (id == null || id.isEmpty()) {
            exchange.sendResponseHeaders(400, -1L);
            exchange.close();
            return;
        }
        String token = this.config.getBotToken();
        if (token != null && !token.isEmpty()) {
            try {
                Utils.put("https://discord.com/api/guilds/" + this.config.getGuildId() + "/members/" + id, Map.of("access_token", accessToken));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String response = "<style>@import url(https://fonts.bunny.net/css?family=inter:600);html{color-scheme:dark}body{margin:0}a{font-weight:600;font-size:1.2rem;height:100vh;display:flex;align-items:center;justify-content:center;font-family:Inter,sans-serif}</style><a>" + DiscordSRV.getPlugin().getAccountLinkManager().process(state, id) + "</a>";
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(200, response.getBytes(StandardCharsets.UTF_8).length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response.getBytes());
            os.close();
        }
        exchange.close();
    }
}

