/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.yaml.bukkit;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.yaml.YamlSourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.postprocessor.ConfigPostprocessor;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;

public class YamlBukkitConfigurer
extends Configurer {
    private String commentPrefix = "# ";

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("yml", "yaml");
    }

    @Override
    public boolean isCommentLine(String line) {
        return line.trim().startsWith("#");
    }

    @Override
    public Map<String, Object> load(@NonNull InputStream inputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        Objects.requireNonNull(inputStream, "inputStream is marked non-null but is null");
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        YamlConfiguration config = new YamlConfiguration();
        config.options().pathSeparator('\u001d');
        config.loadFromString(ConfigPostprocessor.of(inputStream).getContext());
        return this.memorySectionToMap((MemorySection)config);
    }

    @Override
    public void write(@NonNull OutputStream outputStream, @NonNull Map<String, Object> data, @NonNull ConfigDeclaration declaration) throws Exception {
        Objects.requireNonNull(outputStream, "outputStream is marked non-null but is null");
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        YamlConfiguration config = new YamlConfiguration();
        config.options().pathSeparator('\u001d');
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
        ConfigPostprocessor.of(config.saveToString()).removeLines(line -> line.startsWith(this.commentPrefix.trim())).removeLinesUntil(line -> line.chars().anyMatch(x -> !Character.isWhitespace(x))).updateContext(ctx -> YamlSourceWalker.of(ctx).insertComments(declaration, this.commentPrefix)).write(outputStream);
    }

    private Map<String, Object> memorySectionToMap(MemorySection section) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            Map<String, Object> value = section.get(key);
            if (value instanceof MemorySection) {
                value = this.memorySectionToMap((MemorySection)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @Generated
    public YamlBukkitConfigurer setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
        return this;
    }
}

