/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class EnumMatcher {
    private static final int DEFAULT_MAX_SUGGESTIONS = 5;

    private EnumMatcher() {
    }

    public static String suggest(String input, Class<? extends Enum<?>> enumClass) {
        String[] names = (String[])Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new);
        return EnumMatcher.suggest(input, names, 5);
    }

    public static String suggest(String input, String[] enumNames, int maxSuggestions) {
        if (enumNames == null || enumNames.length == 0) {
            return "???";
        }
        String inputUpper = input.toUpperCase();
        List sorted = Arrays.stream(enumNames).sorted(Comparator.comparingInt(name -> EnumMatcher.levenshtein(inputUpper, name.toUpperCase()))).limit(maxSuggestions).collect(Collectors.toList());
        boolean truncated = enumNames.length > maxSuggestions;
        int remaining = enumNames.length - sorted.size();
        if (sorted.size() == 1) {
            return truncated ? "Expected " + (String)sorted.get(0) + " (+" + remaining + " more)" : "Expected " + (String)sorted.get(0);
        }
        StringBuilder sb = new StringBuilder("Expected ");
        for (int i = 0; i < sorted.size(); ++i) {
            if (i > 0) {
                sb.append(!truncated && i == sorted.size() - 1 ? " or " : ", ");
            }
            sb.append((String)sorted.get(i));
        }
        if (truncated) {
            sb.append(" (+").append(remaining).append(" more)");
        }
        return sb.toString();
    }

    private static int levenshtein(String a, String b) {
        int i;
        int[][] dp = new int[a.length() + 1][b.length() + 1];
        for (i = 0; i <= a.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= b.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= a.length(); ++i) {
            for (int j = 1; j <= b.length(); ++j) {
                int cost = a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1;
                dp[i][j] = Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + cost);
            }
        }
        return dp[a.length()][b.length()];
    }
}

