/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.toml;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.core.type.TypeReference;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.dataformat.toml.TomlMapper;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class TomlJacksonConfigurer
extends Configurer {
    private static final TypeReference<LinkedHashMap<String, Object>> MAP_TYPE = new TypeReference<LinkedHashMap<String, Object>>(){};
    private static final String NULL_MARKER = "__null__";
    private TomlMapper mapper;
    private int maxSectionDepth = 2;

    public TomlJacksonConfigurer() {
        this.mapper = TomlJacksonConfigurer.createDefaultMapper();
    }

    public TomlJacksonConfigurer(@NonNull TomlMapper mapper) {
        Objects.requireNonNull(mapper, "mapper is marked non-null but is null");
        this.mapper = mapper;
    }

    private static TomlMapper createDefaultMapper() {
        return (TomlMapper)TomlMapper.builder().build();
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList("toml");
    }

    @Override
    public boolean isCommentLine(String line) {
        return line.trim().startsWith("#");
    }

    @Override
    public Object simplify(Object value, GenericsDeclaration genericType, @NonNull SerdesContext serdesContext, boolean conservative) {
        long maxSafeInteger;
        long longValue;
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        if (value == null) {
            return null;
        }
        GenericsDeclaration genericsDeclaration = GenericsDeclaration.of(value);
        if (!(genericsDeclaration.getType() != Long.TYPE && genericsDeclaration.getType() != Long.class || (longValue = ((Long)value).longValue()) <= (maxSafeInteger = 0x20000000000000L) && longValue >= -maxSafeInteger)) {
            return super.simplify(value, genericType, serdesContext, false);
        }
        return super.simplify(value, genericType, serdesContext, conservative);
    }

    @Override
    public Map<String, Object> load(@NonNull InputStream inputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        Objects.requireNonNull(inputStream, "inputStream is marked non-null but is null");
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        Map map = this.mapper.readValue(inputStream, MAP_TYPE);
        this.normalizeNullMarkers(map);
        return map;
    }

    private void normalizeNullMarkers(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (NULL_MARKER.equals(value)) {
                entry.setValue(null);
                continue;
            }
            if (value instanceof Map) {
                this.normalizeNullMarkers((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.normalizeNullMarkersInList((List)value);
        }
    }

    private void normalizeNullMarkersInList(List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (NULL_MARKER.equals(value)) {
                list.set(i, null);
                continue;
            }
            if (value instanceof Map) {
                this.normalizeNullMarkers((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.normalizeNullMarkersInList((List)value);
        }
    }

    @Override
    public void write(@NonNull OutputStream outputStream, @NonNull Map<String, Object> data, @NonNull ConfigDeclaration declaration) throws Exception {
        Objects.requireNonNull(outputStream, "outputStream is marked non-null but is null");
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        StringBuilder sb = new StringBuilder();
        this.writeHeader(sb, declaration);
        Map<Object, Object> normalized = this.convertNullsToMarkers(data);
        String flatToml = this.mapper.writeValueAsString(normalized);
        String sectioned = this.convertToSections(flatToml, declaration);
        sb.append(sectioned);
        outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private Map<Object, Object> convertNullsToMarkers(Map<?, ?> map) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.put(entry.getKey(), this.convertNullValue(entry.getValue()));
        }
        return result;
    }

    private Object convertNullValue(Object value) {
        if (value == null) {
            return NULL_MARKER;
        }
        if (value instanceof Map) {
            return this.convertNullsToMarkers((Map)value);
        }
        if (value instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : (List)value) {
                result.add(this.convertNullValue(item));
            }
            return result;
        }
        return value;
    }

    private void writeHeader(StringBuilder sb, ConfigDeclaration declaration) {
        String[] header = declaration.getHeader();
        if (header != null && header.length > 0) {
            for (String line : header) {
                sb.append("# ").append(line).append("\n");
            }
            sb.append("\n");
        }
    }

    private String convertToSections(String flatToml, ConfigDeclaration declaration) {
        LinkedHashMap sections = new LinkedHashMap();
        for (String line : flatToml.split("\n")) {
            String string = line.trim();
            if (string.isEmpty()) continue;
            int eqIndex = TomlJacksonConfigurer.findEqualsIndex(string);
            if (eqIndex < 0) {
                sections.computeIfAbsent("", key -> new ArrayList()).add(line);
                continue;
            }
            String fullKey = string.substring(0, eqIndex).trim();
            String value = string.substring(eqIndex + 1).trim();
            String[] pathInfo = this.findSectionPath(fullKey, declaration);
            String sectionPath = pathInfo[0];
            String remainingKey = pathInfo[1];
            sections.computeIfAbsent(sectionPath, key -> new ArrayList()).add(remainingKey + " = " + value);
        }
        StringBuilder result = new StringBuilder();
        HashSet<String> commentedPatterns = new HashSet<String>();
        List rootLines = sections.getOrDefault("", Collections.emptyList());
        for (String string : rootLines) {
            String key2 = TomlJacksonConfigurer.extractKey(string);
            if (key2 != null) {
                this.writeCommentsForKey(result, key2, declaration, commentedPatterns);
            }
            result.append(string).append("\n");
        }
        for (Map.Entry entry : sections.entrySet()) {
            String sectionPath = (String)entry.getKey();
            if (sectionPath.isEmpty()) continue;
            List lines = (List)entry.getValue();
            result.append("\n");
            this.writeCommentsForKey(result, sectionPath, declaration, commentedPatterns);
            result.append("[").append(sectionPath).append("]\n");
            for (String line : lines) {
                String key3 = TomlJacksonConfigurer.extractKey(line);
                if (key3 != null) {
                    String fullKey = sectionPath + "." + key3;
                    this.writeCommentsForKey(result, fullKey, declaration, commentedPatterns);
                }
                result.append(line).append("\n");
            }
        }
        return result.toString();
    }

    private void writeCommentsForKey(StringBuilder sb, String key, ConfigDeclaration declaration, Set<String> commentedPatterns) {
        ConfigPath path = ConfigPath.parseFlat(key, declaration);
        List<ConfigPath.PathNode> nodes = path.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Optional<FieldDeclaration> field;
            ConfigPath partialPath;
            String pattern;
            if (!(nodes.get(i) instanceof ConfigPath.PropertyNode) || commentedPatterns.contains(pattern = (partialPath = path.subPath(i)).toPattern()) || !(field = partialPath.resolveFieldDeclaration(declaration)).isPresent()) continue;
            String[] comment = field.get().getComment();
            if (comment != null) {
                for (String line : comment) {
                    if (line.isEmpty()) {
                        sb.append("\n");
                        continue;
                    }
                    if (line.trim().isEmpty()) {
                        sb.append("#\n");
                        continue;
                    }
                    sb.append("# ").append(line).append("\n");
                }
            }
            commentedPatterns.add(pattern);
        }
    }

    private String[] findSectionPath(String dottedKey, ConfigDeclaration declaration) {
        String[] parts = dottedKey.split("\\.");
        if (parts.length == 1 || declaration == null) {
            return new String[]{"", dottedKey};
        }
        int sectionDepth = declaration.findConfigDepth(parts, this.maxSectionDepth);
        if (sectionDepth == 0) {
            return new String[]{"", dottedKey};
        }
        String sectionPath = String.join((CharSequence)".", Arrays.copyOfRange(parts, 0, sectionDepth));
        String remainingKey = String.join((CharSequence)".", Arrays.copyOfRange(parts, sectionDepth, parts.length));
        return new String[]{sectionPath, remainingKey};
    }

    private static int findEqualsIndex(String line) {
        boolean inString = false;
        char stringChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inString) {
                if (c != stringChar || line.charAt(i - 1) == '\\') continue;
                inString = false;
                continue;
            }
            if (c == '\"' || c == '\'') {
                inString = true;
                stringChar = c;
                continue;
            }
            if (c != '=') continue;
            return i;
        }
        return -1;
    }

    private static String extractKey(String line) {
        int eqIndex = TomlJacksonConfigurer.findEqualsIndex(line);
        if (eqIndex > 0) {
            return line.substring(0, eqIndex).trim();
        }
        return null;
    }

    @Generated
    public TomlJacksonConfigurer setMapper(TomlMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    @Generated
    public TomlJacksonConfigurer setMaxSectionDepth(int maxSectionDepth) {
        this.maxSectionDepth = maxSectionDepth;
        return this;
    }
}

