/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToUuidTransformer
extends ObjectTransformer<String, UUID> {
    @Override
    public GenericsPair<String, UUID> getPair() {
        return this.genericsPair(String.class, UUID.class);
    }

    @Override
    public UUID transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return UUID.fromString(data);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected UUID (e.g. 550e8400-e29b-41d4-a716-446655440000)");
        }
    }
}

