/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.math.BigDecimal;
import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToIntegerTransformer
extends ObjectTransformer<String, Integer> {
    @Override
    public GenericsPair<String, Integer> getPair() {
        return this.genericsPair(String.class, Integer.class);
    }

    @Override
    public Integer transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return new BigDecimal(data).intValueExact();
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new IllegalArgumentException("Expected whole number (e.g. 42, -10, 0)");
        }
    }
}

