/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToFloatTransformer
extends ObjectTransformer<String, Float> {
    @Override
    public GenericsPair<String, Float> getPair() {
        return this.genericsPair(String.class, Float.class);
    }

    @Override
    public Float transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return Float.valueOf(Float.parseFloat(data));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected float number (e.g. 3.14, -0.5, 100.0)");
        }
    }
}

