/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.math.BigDecimal;
import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToByteTransformer
extends ObjectTransformer<String, Byte> {
    @Override
    public GenericsPair<String, Byte> getPair() {
        return this.genericsPair(String.class, Byte.class);
    }

    @Override
    public Byte transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return new BigDecimal(data).byteValueExact();
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new IllegalArgumentException("Expected byte number (-128 to 127)");
        }
    }
}

