/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToBooleanTransformer
extends ObjectTransformer<String, Boolean> {
    private static final Set<String> TRUE_VALUES = new HashSet<String>(Arrays.asList("true", "yes", "on", "1", "enabled"));
    private static final Set<String> FALSE_VALUES = new HashSet<String>(Arrays.asList("false", "no", "off", "0", "disabled"));

    @Override
    public GenericsPair<String, Boolean> getPair() {
        return this.genericsPair(String.class, Boolean.class);
    }

    @Override
    public Boolean transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        String lower = data.toLowerCase();
        if (TRUE_VALUES.contains(lower)) {
            return true;
        }
        if (FALSE_VALUES.contains(lower)) {
            return false;
        }
        throw new IllegalArgumentException("Expected true or false");
    }
}

