/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.math.BigInteger;
import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToBigIntegerTransformer
extends ObjectTransformer<String, BigInteger> {
    @Override
    public GenericsPair<String, BigInteger> getPair() {
        return this.genericsPair(String.class, BigInteger.class);
    }

    @Override
    public BigInteger transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return new BigInteger(data);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected precise integer (e.g. 42, -10, 0)");
        }
    }
}

