/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard;

import java.math.BigDecimal;
import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public class StringToBigDecimalTransformer
extends ObjectTransformer<String, BigDecimal> {
    @Override
    public GenericsPair<String, BigDecimal> getPair() {
        return this.genericsPair(String.class, BigDecimal.class);
    }

    @Override
    public BigDecimal transform(@NonNull String data, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        try {
            return new BigDecimal(data);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected precise decimal (e.g. 3.14, -100.50, 0)");
        }
    }
}

