/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public interface TypedKeyWriter {
    public Configurer getConfigurer();

    public SerdesContext getWriterContext(@NonNull String var1);

    public void setRaw(@NonNull String var1, Object var2);

    default public Object getRawOrNull(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return null;
    }

    default public Object set(@NonNull String key, Object value) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Object old = this.getRawOrNull(key);
        value = this.getConfigurer().simplify(value, null, this.getWriterContext(key), true);
        this.setRaw(key, value);
        return old;
    }

    default public Object set(@NonNull String key, Object value, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        Object old = this.getRawOrNull(key);
        value = this.getConfigurer().simplify(value, genericType, this.getWriterContext(key), true);
        this.setRaw(key, value);
        return old;
    }

    default public <T> Object set(@NonNull String key, Object value, @NonNull Class<T> type) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        return this.set(key, value, GenericsDeclaration.of(type));
    }

    default public void setCollection(@NonNull String key, Collection<?> collection, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        if (collection == null) {
            this.setRaw(key, null);
            return;
        }
        Object object = this.getConfigurer().simplifyCollection(collection, genericType, this.getWriterContext(key), true);
        this.setRaw(key, object);
    }

    default public <T> void setCollection(@NonNull String key, Collection<?> collection, @NonNull Class<T> elementType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(elementType, "elementType is marked non-null but is null");
        if (collection == null) {
            this.setRaw(key, null);
            return;
        }
        GenericsDeclaration genericType = GenericsDeclaration.of(collection, Collections.singletonList(elementType));
        this.setCollection(key, collection, genericType);
    }

    default public <T> void setArray(@NonNull String key, T[] array, @NonNull Class<T> elementType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(elementType, "elementType is marked non-null but is null");
        if (array == null) {
            this.setRaw(key, null);
            return;
        }
        this.setCollection(key, Arrays.asList(array), elementType);
    }

    default public void setMap(@NonNull String key, Map<?, ?> map, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        if (map == null) {
            this.setRaw(key, null);
            return;
        }
        Object object = this.getConfigurer().simplifyMap(map, genericType, this.getWriterContext(key), true);
        this.setRaw(key, object);
    }

    default public <K, V> void setMap(@NonNull String key, Map<K, V> map, @NonNull Class<K> keyType, @NonNull Class<V> valueType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(keyType, "keyType is marked non-null but is null");
        Objects.requireNonNull(valueType, "valueType is marked non-null but is null");
        if (map == null) {
            this.setRaw(key, null);
            return;
        }
        GenericsDeclaration genericType = GenericsDeclaration.of(map, Arrays.asList(keyType, valueType));
        this.setMap(key, map, genericType);
    }
}

