/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public interface TypedKeyReader {
    public Configurer getConfigurer();

    public SerdesContext getReaderContext(@NonNull String var1);

    public Object getRaw(@NonNull String var1);

    default public Object getRawOr(@NonNull String key, Object defaultValue) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Object value = this.getRaw(key);
        return value != null ? value : defaultValue;
    }

    default public <T> T get(@NonNull String key, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        Object object = this.getRaw(key);
        return (T)this.getConfigurer().resolveType(object, null, genericType.getType(), genericType, this.getReaderContext(key));
    }

    default public <T> T get(@NonNull String key, @NonNull Class<T> type) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        return this.get(key, GenericsDeclaration.of(type));
    }

    default public <T> T getOr(@NonNull String key, @NonNull Class<T> type, T defaultValue) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        T value = this.get(key, type);
        return value != null ? value : defaultValue;
    }

    default public <T> List<T> getAsList(@NonNull String key, @NonNull Class<T> elementType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(elementType, "elementType is marked non-null but is null");
        GenericsDeclaration genericType = GenericsDeclaration.of(List.class, Collections.singletonList(elementType));
        return (List)this.get(key, genericType);
    }

    default public <T> Set<T> getAsSet(@NonNull String key, @NonNull Class<T> elementType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(elementType, "elementType is marked non-null but is null");
        GenericsDeclaration genericType = GenericsDeclaration.of(Set.class, Collections.singletonList(elementType));
        return (Set)this.get(key, genericType);
    }

    default public <T> Collection<T> getAsCollection(@NonNull String key, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        if (!Collection.class.isAssignableFrom(genericType.getType())) {
            throw new IllegalArgumentException("genericType.type must be a superclass of Collection: " + genericType);
        }
        return (Collection)this.get(key, genericType);
    }

    default public <K, V> Map<K, V> getAsMap(@NonNull String key, @NonNull Class<K> keyType, @NonNull Class<V> valueType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(keyType, "keyType is marked non-null but is null");
        Objects.requireNonNull(valueType, "valueType is marked non-null but is null");
        GenericsDeclaration genericType = GenericsDeclaration.of(Map.class, Arrays.asList(keyType, valueType));
        return (Map)this.get(key, genericType);
    }

    default public <K, V> Map<K, V> getAsMap(@NonNull String key, @NonNull GenericsDeclaration genericType) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(genericType, "genericType is marked non-null but is null");
        if (!Map.class.isAssignableFrom(genericType.getType())) {
            throw new IllegalArgumentException("genericType.type must be a superclass of Map: " + genericType);
        }
        return (Map)this.get(key, genericType);
    }
}

