/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsPair;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.BidirectionalTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectSerializer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.OkaeriSerdes;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesAnnotationResolver;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContextAttachment;

public class SerdesRegistry {
    private final Map<Class<? extends Annotation>, SerdesAnnotationResolver<Annotation, SerdesContextAttachment>> annotationResolverMap = new ConcurrentHashMap<Class<? extends Annotation>, SerdesAnnotationResolver<Annotation, SerdesContextAttachment>>();
    private final List<ObjectSerializer> serializerList = new CopyOnWriteArrayList<ObjectSerializer>();
    private final Map<GenericsPair, ObjectTransformer> transformerMap = new ConcurrentHashMap<GenericsPair, ObjectTransformer>();

    public void add(OkaeriSerdes ... serdes) {
        Objects.requireNonNull(serdes, "serdes is marked non-null but is null");
        for (OkaeriSerdes pack : serdes) {
            pack.register(this);
        }
    }

    public void register(@NonNull ObjectTransformer transformer) {
        Objects.requireNonNull(transformer, "transformer is marked non-null but is null");
        this.transformerMap.put(transformer.getPair(), transformer);
    }

    public void register(@NonNull OkaeriSerdes serdesPack) {
        Objects.requireNonNull(serdesPack, "serdesPack is marked non-null but is null");
        serdesPack.register(this);
    }

    public <L, R> void register(final @NonNull BidirectionalTransformer<L, R> transformer) {
        Objects.requireNonNull(transformer, "transformer is marked non-null but is null");
        final Class<?> originalClass = transformer.getClass();
        this.register(new ObjectTransformer<L, R>(){

            @Override
            public GenericsPair<L, R> getPair() {
                return transformer.getPair();
            }

            @Override
            public R transform(@NonNull L data, @NonNull SerdesContext serdesContext) {
                Objects.requireNonNull(data, "data is marked non-null but is null");
                Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
                return transformer.leftToRight(data, serdesContext);
            }

            @Override
            public Class<?> getOriginalClass() {
                return originalClass;
            }
        });
        this.register(new ObjectTransformer<R, L>(){

            @Override
            public GenericsPair<R, L> getPair() {
                return transformer.getPair().reverse();
            }

            @Override
            public L transform(@NonNull R data, @NonNull SerdesContext serdesContext) {
                Objects.requireNonNull(data, "data is marked non-null but is null");
                Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
                return transformer.rightToLeft(data, serdesContext);
            }

            @Override
            public Class<?> getOriginalClass() {
                return originalClass;
            }
        });
    }

    public void registerWithReversedToString(@NonNull ObjectTransformer transformer) {
        Objects.requireNonNull(transformer, "transformer is marked non-null but is null");
        this.transformerMap.put(transformer.getPair(), transformer);
        final GenericsPair reversePair = transformer.getPair().reverse();
        ObjectTransformer reverseTransformer = new ObjectTransformer(){

            public GenericsPair getPair() {
                return reversePair;
            }

            public Object transform(@NonNull Object data, @NonNull SerdesContext serdesContext) {
                Objects.requireNonNull(data, "data is marked non-null but is null");
                Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
                return data.toString();
            }
        };
        this.transformerMap.put(reversePair, reverseTransformer);
    }

    public void register(@NonNull ObjectSerializer serializer) {
        Objects.requireNonNull(serializer, "serializer is marked non-null but is null");
        this.serializerList.add(serializer);
    }

    public void registerFirst(@NonNull ObjectSerializer serializer) {
        Objects.requireNonNull(serializer, "serializer is marked non-null but is null");
        this.serializerList.add(0, serializer);
    }

    public void registerExclusive(@NonNull Class<?> type, @NonNull ObjectSerializer serializer) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        Objects.requireNonNull(serializer, "serializer is marked non-null but is null");
        this.serializerList.removeIf(ser -> ser.supports(type));
        this.serializerList.add(serializer);
    }

    public ObjectTransformer getTransformer(@NonNull GenericsDeclaration from, @NonNull GenericsDeclaration to) {
        Objects.requireNonNull(from, "from is marked non-null but is null");
        Objects.requireNonNull(to, "to is marked non-null but is null");
        GenericsPair pair = new GenericsPair(from, to);
        return this.transformerMap.get(pair);
    }

    public List<ObjectTransformer> getTransformersFrom(@NonNull GenericsDeclaration from) {
        Objects.requireNonNull(from, "from is marked non-null but is null");
        return this.transformerMap.entrySet().stream().filter(entry -> from.equals(((GenericsPair)entry.getKey()).getFrom())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<ObjectTransformer> getTransformersTo(@NonNull GenericsDeclaration to) {
        Objects.requireNonNull(to, "to is marked non-null but is null");
        return this.transformerMap.entrySet().stream().filter(entry -> to.equals(((GenericsPair)entry.getKey()).getTo())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public boolean canTransform(@NonNull GenericsDeclaration from, @NonNull GenericsDeclaration to) {
        Objects.requireNonNull(from, "from is marked non-null but is null");
        Objects.requireNonNull(to, "to is marked non-null but is null");
        return this.getTransformer(from, to) != null;
    }

    public ObjectSerializer getSerializer(@NonNull Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        for (int i = this.serializerList.size() - 1; i >= 0; --i) {
            ObjectSerializer serializer = this.serializerList.get(i);
            if (!serializer.supports(clazz)) continue;
            return serializer;
        }
        return null;
    }

    public void register(@NonNull SerdesAnnotationResolver<? extends Annotation, ? extends SerdesContextAttachment> annotationResolver) {
        Objects.requireNonNull(annotationResolver, "annotationResolver is marked non-null but is null");
        this.annotationResolverMap.put(annotationResolver.getAnnotationType(), annotationResolver);
    }

    public SerdesAnnotationResolver<Annotation, SerdesContextAttachment> getAnnotationResolver(@NonNull Class<? extends Annotation> annotationType) {
        Objects.requireNonNull(annotationType, "annotationType is marked non-null but is null");
        return this.annotationResolverMap.get(annotationType);
    }

    public SerdesAnnotationResolver<Annotation, SerdesContextAttachment> getAnnotationResolver(@NonNull Annotation annotation) {
        Objects.requireNonNull(annotation, "annotation is marked non-null but is null");
        return this.annotationResolverMap.get(annotation.annotationType());
    }

    public OkaeriSerdes allSerdes() {
        return registry -> {
            this.transformerMap.values().forEach(registry::register);
            this.serializerList.forEach(registry::register);
            this.annotationResolverMap.values().forEach(registry::register);
        };
    }
}

