/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContextAttachment;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContextAttachments;

public class SerdesContext {
    @NonNull
    private final Configurer configurer;
    private final ConfigContext configContext;
    private final FieldDeclaration field;
    private final SerdesContextAttachments attachments;
    @NonNull
    private final ConfigPath path;

    public static SerdesContext of(@NonNull Configurer configurer) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        return SerdesContext.of(configurer, null, null);
    }

    public static SerdesContext of(@NonNull Configurer configurer, ConfigContext configContext, FieldDeclaration field) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        return SerdesContext.of(configurer, configContext, field, field == null ? new SerdesContextAttachments() : field.readStaticAnnotations(configurer), ConfigPath.root());
    }

    public static SerdesContext of(@NonNull Configurer configurer, ConfigContext configContext, FieldDeclaration field, @NonNull SerdesContextAttachments attachments, @NonNull ConfigPath path) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        Objects.requireNonNull(attachments, "attachments is marked non-null but is null");
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return new SerdesContext(configurer, configContext, field, attachments, path);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T extends Annotation> Optional<T> getConfigAnnotation(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        if (this.configContext == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.configContext.getRootConfig().getClass().getAnnotation(type));
    }

    public <T extends Annotation> Optional<T> getFieldAnnotation(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        return this.getField() == null ? Optional.empty() : this.getField().getAnnotation(type);
    }

    public <T extends SerdesContextAttachment> Optional<T> getAttachment(Class<T> type) {
        SerdesContextAttachment attachment = (SerdesContextAttachment)this.attachments.get(type);
        return Optional.ofNullable(attachment);
    }

    public <T extends SerdesContextAttachment> T getAttachment(Class<T> type, T defaultValue) {
        return (T)((SerdesContextAttachment)this.getAttachment(type).orElse(defaultValue));
    }

    public SerdesContext withProperty(@NonNull String name) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        return new SerdesContext(this.configurer, this.configContext, this.field, this.attachments, this.path.property(name));
    }

    public SerdesContext withIndex(int index) {
        return new SerdesContext(this.configurer, this.configContext, this.field, this.attachments, this.path.index(index));
    }

    public SerdesContext withKey(@NonNull Object key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return new SerdesContext(this.configurer, this.configContext, this.field, this.attachments, this.path.key(key));
    }

    public SerdesContext withPath(@NonNull ConfigPath path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return new SerdesContext(this.configurer, this.configContext, this.field, this.attachments, path);
    }

    public SerdesContext withField(FieldDeclaration field) {
        SerdesContextAttachments newAttachments = field == null ? new SerdesContextAttachments() : field.readStaticAnnotations(this.configurer);
        return new SerdesContext(this.configurer, this.configContext, field, newAttachments, this.path);
    }

    @NonNull
    @Generated
    public Configurer getConfigurer() {
        return this.configurer;
    }

    @Generated
    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    @Generated
    public FieldDeclaration getField() {
        return this.field;
    }

    @Generated
    public SerdesContextAttachments getAttachments() {
        return this.attachments;
    }

    @NonNull
    @Generated
    public ConfigPath getPath() {
        return this.path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerdesContext)) {
            return false;
        }
        SerdesContext other = (SerdesContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Configurer this$configurer = this.getConfigurer();
        Configurer other$configurer = other.getConfigurer();
        if (this$configurer == null ? other$configurer != null : !this$configurer.equals(other$configurer)) {
            return false;
        }
        ConfigContext this$configContext = this.getConfigContext();
        ConfigContext other$configContext = other.getConfigContext();
        if (this$configContext == null ? other$configContext != null : !this$configContext.equals(other$configContext)) {
            return false;
        }
        FieldDeclaration this$field = this.getField();
        FieldDeclaration other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        SerdesContextAttachments this$attachments = this.getAttachments();
        SerdesContextAttachments other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        ConfigPath this$path = this.getPath();
        ConfigPath other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SerdesContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configurer $configurer = this.getConfigurer();
        result = result * 59 + ($configurer == null ? 43 : $configurer.hashCode());
        ConfigContext $configContext = this.getConfigContext();
        result = result * 59 + ($configContext == null ? 43 : $configContext.hashCode());
        FieldDeclaration $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        SerdesContextAttachments $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        ConfigPath $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SerdesContext(configurer=" + this.getConfigurer() + ", configContext=" + this.getConfigContext() + ", field=" + this.getField() + ", attachments=" + this.getAttachments() + ", path=" + this.getPath() + ")";
    }

    @Generated
    private SerdesContext(@NonNull Configurer configurer, ConfigContext configContext, FieldDeclaration field, SerdesContextAttachments attachments, @NonNull ConfigPath path) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        Objects.requireNonNull(path, "path is marked non-null but is null");
        this.configurer = configurer;
        this.configContext = configContext;
        this.field = field;
        this.attachments = attachments;
        this.path = path;
    }

    private static class Builder {
        private final SerdesContextAttachments attachments = new SerdesContextAttachments();
        private Configurer configurer;
        private ConfigContext configContext;
        private FieldDeclaration field;
        private ConfigPath path = ConfigPath.root();

        private Builder() {
        }

        public Builder configurer(Configurer configurer) {
            this.configurer = configurer;
            return this;
        }

        public Builder configContext(ConfigContext configContext) {
            this.configContext = configContext;
            return this;
        }

        public Builder field(FieldDeclaration field) {
            this.field = field;
            return this;
        }

        public Builder path(ConfigPath path) {
            this.path = path;
            return this;
        }

        public <A extends SerdesContextAttachment> Builder attach(Class<A> type, A attachment) {
            if (this.attachments.containsKey(type)) {
                throw new IllegalArgumentException("cannot override SerdesContext attachment of type " + type);
            }
            this.attachments.put(type, attachment);
            return this;
        }

        public SerdesContext build() {
            return SerdesContext.of(this.configurer, this.configContext, this.field, this.attachments, this.path);
        }
    }
}

