/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContextAttachment;

public class ConfigPath
implements SerdesContextAttachment {
    public static final ConfigPath ROOT = new ConfigPath(Collections.emptyList());
    private final List<PathNode> nodes;

    public static ConfigPath root() {
        return ROOT;
    }

    public static ConfigPath of(@NonNull String name) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        return ROOT.property(name);
    }

    public static ConfigPath parseFlat(@NonNull String path, @NonNull ConfigDeclaration rootDeclaration) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        Objects.requireNonNull(rootDeclaration, "rootDeclaration is marked non-null but is null");
        if (path.isEmpty()) {
            return ROOT;
        }
        String[] parts = path.split("\\.");
        ConfigPath result = ROOT;
        ConfigDeclaration currentDecl = rootDeclaration;
        GenericsDeclaration pendingElementType = null;
        boolean pendingMapKey = false;
        for (String part : parts) {
            if (pendingMapKey || pendingElementType != null) {
                Integer index = ConfigPath.parseIndex(part);
                result = index != null ? result.index(index) : result.key(part);
                if (pendingElementType.isConfig()) {
                    currentDecl = ConfigDeclaration.of(pendingElementType.getType());
                }
                pendingElementType = null;
                pendingMapKey = false;
                continue;
            }
            result = result.property(part);
            if (currentDecl == null) continue;
            Optional<FieldDeclaration> field = currentDecl.getField(part);
            if (!field.isPresent()) {
                currentDecl = null;
                continue;
            }
            GenericsDeclaration fieldType = field.get().getType();
            if (fieldType.isConfig()) {
                currentDecl = ConfigDeclaration.of(fieldType.getType());
                continue;
            }
            if (ConfigPath.isCollectionLike(fieldType)) {
                pendingElementType = fieldType.getSubtypeAtOrNull(0);
                currentDecl = null;
                continue;
            }
            if (ConfigPath.isMapLike(fieldType)) {
                GenericsDeclaration valueType = fieldType.getSubtypeAtOrNull(1);
                if (valueType != null && valueType.isConfig()) {
                    pendingElementType = valueType;
                    pendingMapKey = true;
                }
                currentDecl = null;
                continue;
            }
            currentDecl = null;
        }
        return result;
    }

    private static Integer parseIndex(String s) {
        try {
            int value = Integer.parseInt(s);
            return value >= 0 ? Integer.valueOf(value) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isCollectionLike(GenericsDeclaration type) {
        return type != null && Collection.class.isAssignableFrom(type.getType());
    }

    private static boolean isMapLike(GenericsDeclaration type) {
        return type != null && Map.class.isAssignableFrom(type.getType());
    }

    public static ConfigPath parse(@NonNull String path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        if (path.isEmpty()) {
            return ROOT;
        }
        ConfigPath result = ROOT;
        int i = 0;
        int len = path.length();
        while (i < len) {
            int end;
            if (path.charAt(i) == '.') {
                ++i;
                continue;
            }
            if (path.charAt(i) == '[') {
                int closeIndex = path.indexOf(93, i);
                if (closeIndex == -1) {
                    throw new IllegalArgumentException("Unclosed bracket in path: " + path);
                }
                String content = path.substring(i + 1, closeIndex);
                if (content.startsWith("\"") && content.endsWith("\"") || content.startsWith("'") && content.endsWith("'")) {
                    String key = content.substring(1, content.length() - 1);
                    result = result.key(key);
                } else {
                    try {
                        int index = Integer.parseInt(content);
                        result = result.index(index);
                    }
                    catch (NumberFormatException e) {
                        result = result.key(content);
                    }
                }
                i = closeIndex + 1;
                continue;
            }
            for (end = i; end < len && path.charAt(end) != '.' && path.charAt(end) != '['; ++end) {
            }
            String propName = path.substring(i, end);
            if (!propName.isEmpty()) {
                result = result.property(propName);
            }
            i = end;
        }
        return result;
    }

    public ConfigPath property(@NonNull String name) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        ArrayList<PathNode> newNodes = new ArrayList<PathNode>(this.nodes);
        newNodes.add(new PropertyNode(name));
        return new ConfigPath(newNodes);
    }

    public ConfigPath index(int index) {
        ArrayList<PathNode> newNodes = new ArrayList<PathNode>(this.nodes);
        newNodes.add(new IndexNode(index));
        return new ConfigPath(newNodes);
    }

    public ConfigPath key(@NonNull Object key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        ArrayList<PathNode> newNodes = new ArrayList<PathNode>(this.nodes);
        newNodes.add(new KeyNode(key));
        return new ConfigPath(newNodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public List<PathNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public PathNode getLastNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1);
    }

    public ConfigPath parent() {
        if (this.nodes.size() <= 1) {
            return ROOT;
        }
        return new ConfigPath(new ArrayList<PathNode>(this.nodes.subList(0, this.nodes.size() - 1)));
    }

    public ConfigPath subPath(int endIndex) {
        if (endIndex < 0 || endIndex >= this.nodes.size()) {
            throw new IndexOutOfBoundsException("endIndex: " + endIndex + ", size: " + this.nodes.size());
        }
        return new ConfigPath(new ArrayList<PathNode>(this.nodes.subList(0, endIndex + 1)));
    }

    public String toString() {
        if (this.nodes.isEmpty()) {
            return "<root>";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nodes.size(); ++i) {
            PathNode node = this.nodes.get(i);
            if (node instanceof PropertyNode) {
                if (i > 0) {
                    sb.append(".");
                }
                sb.append(((PropertyNode)node).getName());
                continue;
            }
            if (node instanceof IndexNode) {
                sb.append("[").append(((IndexNode)node).getIndex()).append("]");
                continue;
            }
            if (!(node instanceof KeyNode)) continue;
            Object key = ((KeyNode)node).getKey();
            sb.append("[");
            if (key instanceof String) {
                sb.append("\"").append(ConfigPath.escapeString((String)key)).append("\"");
            } else {
                sb.append(key);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static String escapeString(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public Optional<FieldDeclaration> resolveFieldDeclaration(@NonNull ConfigDeclaration rootDeclaration) {
        Objects.requireNonNull(rootDeclaration, "rootDeclaration is marked non-null but is null");
        ConfigDeclaration currentDecl = rootDeclaration;
        FieldDeclaration lastField = null;
        for (PathNode node : this.nodes) {
            if (node instanceof PropertyNode) {
                String name = ((PropertyNode)node).getName();
                if (currentDecl == null && lastField != null && ConfigPath.isMapLike(lastField.getType())) {
                    GenericsDeclaration valueType = lastField.getType().getSubtypeAtOrNull(1);
                    currentDecl = valueType != null && valueType.isConfig() ? ConfigDeclaration.of(valueType.getType()) : null;
                    lastField = null;
                    continue;
                }
                if (currentDecl == null) {
                    return Optional.empty();
                }
                Optional<FieldDeclaration> field = currentDecl.getField(name);
                if (!field.isPresent()) {
                    return Optional.empty();
                }
                lastField = field.get();
                currentDecl = ConfigPath.resolveNextDeclaration(lastField.getType());
                continue;
            }
            if (node instanceof IndexNode) {
                if (lastField == null) {
                    return Optional.empty();
                }
                GenericsDeclaration elementType = lastField.getType().getSubtypeAtOrNull(0);
                currentDecl = elementType != null && elementType.isConfig() ? ConfigDeclaration.of(elementType.getType()) : null;
                lastField = null;
                continue;
            }
            if (!(node instanceof KeyNode)) continue;
            if (lastField == null) {
                return Optional.empty();
            }
            GenericsDeclaration valueType = lastField.getType().getSubtypeAtOrNull(1);
            currentDecl = valueType != null && valueType.isConfig() ? ConfigDeclaration.of(valueType.getType()) : null;
            lastField = null;
        }
        return Optional.ofNullable(lastField);
    }

    private static ConfigDeclaration resolveNextDeclaration(GenericsDeclaration type) {
        if (type == null) {
            return null;
        }
        if (type.isConfig()) {
            return ConfigDeclaration.of(type.getType());
        }
        return null;
    }

    public String toPattern() {
        StringBuilder sb = new StringBuilder();
        for (PathNode node : this.nodes) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            if (node instanceof PropertyNode) {
                sb.append(((PropertyNode)node).getName());
                continue;
            }
            if (!(node instanceof IndexNode) && !(node instanceof KeyNode)) continue;
            sb.append("*");
        }
        return sb.toString();
    }

    public String toPattern(@NonNull ConfigDeclaration declaration) {
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        StringBuilder sb = new StringBuilder();
        ConfigDeclaration currentDecl = declaration;
        FieldDeclaration lastField = null;
        for (PathNode node : this.nodes) {
            if (node instanceof PropertyNode) {
                String name = ((PropertyNode)node).getName();
                if (currentDecl == null && lastField != null && ConfigPath.isMapLike(lastField.getType())) {
                    sb.append(sb.length() > 0 ? "." : "").append("*");
                    GenericsDeclaration valueType = lastField.getType().getSubtypeAtOrNull(1);
                    currentDecl = valueType != null && valueType.isConfig() ? ConfigDeclaration.of(valueType.getType()) : null;
                    lastField = null;
                    continue;
                }
                sb.append(sb.length() > 0 ? "." : "").append(name);
                if (currentDecl == null) continue;
                Optional<FieldDeclaration> field = currentDecl.getField(name);
                if (field.isPresent()) {
                    lastField = field.get();
                    GenericsDeclaration fieldType = lastField.getType();
                    currentDecl = fieldType.isConfig() ? ConfigDeclaration.of(fieldType.getType()) : null;
                    continue;
                }
                currentDecl = null;
                lastField = null;
                continue;
            }
            if (node instanceof IndexNode) {
                sb.append(sb.length() > 0 ? "." : "").append("*");
                if (lastField == null) continue;
                GenericsDeclaration elementType = lastField.getType().getSubtypeAtOrNull(0);
                currentDecl = elementType != null && elementType.isConfig() ? ConfigDeclaration.of(elementType.getType()) : null;
                lastField = null;
                continue;
            }
            if (!(node instanceof KeyNode)) continue;
            sb.append(sb.length() > 0 ? "." : "").append("*");
            if (lastField == null) continue;
            GenericsDeclaration valueType = lastField.getType().getSubtypeAtOrNull(1);
            currentDecl = valueType != null && valueType.isConfig() ? ConfigDeclaration.of(valueType.getType()) : null;
            lastField = null;
        }
        return sb.toString();
    }

    @Generated
    private ConfigPath(List<PathNode> nodes) {
        this.nodes = nodes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigPath)) {
            return false;
        }
        ConfigPath other = (ConfigPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PathNode> this$nodes = this.getNodes();
        List<PathNode> other$nodes = other.getNodes();
        return !(this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigPath;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PathNode> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        return result;
    }

    public static class PropertyNode
    implements PathNode {
        private final String name;

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof KeyNode) {
                Object key = ((KeyNode)o).getKey();
                return key instanceof String && this.name.equals(key);
            }
            return o instanceof PropertyNode && this.name.equals(((PropertyNode)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Generated
        public PropertyNode(String name) {
            this.name = name;
        }
    }

    public static class IndexNode
    implements PathNode {
        private final int index;

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }

        @Generated
        public IndexNode(int index) {
            this.index = index;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexNode)) {
                return false;
            }
            IndexNode other = (IndexNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getIndex() == other.getIndex();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IndexNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            return result;
        }
    }

    public static class KeyNode
    implements PathNode {
        private final Object key;

        public Object getKey() {
            return this.key;
        }

        public String toString() {
            if (this.key instanceof String) {
                return "[\"" + this.key + "\"]";
            }
            return "[" + this.key + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.key instanceof String && o instanceof PropertyNode) {
                return this.key.equals(((PropertyNode)o).getName());
            }
            return o instanceof KeyNode && this.key.equals(((KeyNode)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Generated
        public KeyNode(Object key) {
            this.key = key;
        }
    }

    public static interface PathNode {
    }
}

