/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.Header;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.Headers;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.Include;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.Names;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;

public class ConfigDeclaration {
    private static final Map<Class<?>, ConfigDeclaration> DECLARATION_CACHE = new ConcurrentHashMap();
    private Names nameStrategy;
    private String[] header;
    private Map<String, FieldDeclaration> fieldMap;
    private boolean real;
    private Class<?> type;

    public static ConfigDeclaration of(@NonNull Class<?> clazz, OkaeriConfig config) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        return ConfigDeclaration.of(clazz, (Object)config);
    }

    public static ConfigDeclaration of(@NonNull Class<?> clazz, Object object) {
        Include[] subs;
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        ConfigDeclaration template = DECLARATION_CACHE.computeIfAbsent(clazz, klass -> {
            ConfigDeclaration declaration = new ConfigDeclaration();
            declaration.setNameStrategy(ConfigDeclaration.readNames(klass));
            declaration.setHeader(ConfigDeclaration.readHeader(klass));
            declaration.setReal(OkaeriConfig.class.isAssignableFrom((Class<?>)klass));
            declaration.setType((Class<?>)klass);
            return declaration;
        });
        ConfigDeclaration declaration = new ConfigDeclaration();
        declaration.setNameStrategy(template.getNameStrategy());
        declaration.setHeader(template.getHeader());
        declaration.setReal(template.isReal());
        declaration.setType(template.getType());
        declaration.setFieldMap(ConfigDeclaration.readFields(clazz, declaration, object));
        for (Include sub : subs = (Include[])clazz.getDeclaredAnnotationsByType(Include.class)) {
            if (!sub.value().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("@Include can only include classes that " + clazz.getName() + " extends. Cannot include fields from " + sub.value().getName() + " because it is not a superclass of " + clazz.getName());
            }
            LinkedHashMap<String, FieldDeclaration> subFields = ConfigDeclaration.readFields(sub.value(), declaration, object);
            subFields.forEach((key, value) -> {
                if (declaration.getFieldMap().containsKey(key)) {
                    return;
                }
                declaration.getFieldMap().put((String)key, (FieldDeclaration)value);
            });
        }
        return declaration;
    }

    public static ConfigDeclaration of(@NonNull OkaeriConfig config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        return ConfigDeclaration.of(config.getClass(), config);
    }

    public static ConfigDeclaration of(@NonNull Object object) {
        Objects.requireNonNull(object, "object is marked non-null but is null");
        return ConfigDeclaration.of(object.getClass(), object);
    }

    public static ConfigDeclaration of(@NonNull Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        return ConfigDeclaration.of(clazz, null);
    }

    private static String[] readHeader(@NonNull Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        Headers headers = clazz.getAnnotation(Headers.class);
        if (headers != null) {
            ArrayList<String> headerList = new ArrayList<String>();
            for (Header header : headers.value()) {
                headerList.addAll(Arrays.asList(header.value()));
            }
            return headerList.toArray(new String[0]);
        }
        Header header = clazz.getAnnotation(Header.class);
        if (header != null) {
            return header.value();
        }
        return null;
    }

    private static Names readNames(@NonNull Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        Names names = clazz.getAnnotation(Names.class);
        while (names == null) {
            if ((clazz = clazz.getEnclosingClass()) == null) {
                return null;
            }
            names = clazz.getAnnotation(Names.class);
        }
        return names;
    }

    private static LinkedHashMap<String, FieldDeclaration> readFields(@NonNull Class<?> clazz, @NonNull ConfigDeclaration declaration, Object object) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.getName().startsWith("this$")).map(field -> FieldDeclaration.of(declaration, field, object)).filter(Objects::nonNull).collect(Collectors.toMap(FieldDeclaration::getName, field -> field, (u, v) -> {
            throw new IllegalStateException("Duplicate key/field (by name)!\nLeft: " + u + "\nRight: " + v);
        }, LinkedHashMap::new));
    }

    public Optional<FieldDeclaration> getField(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return Optional.ofNullable(this.fieldMap.get(key));
    }

    public GenericsDeclaration getGenericsOrNull(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return this.getField(key).map(FieldDeclaration::getType).orElse(null);
    }

    public Collection<FieldDeclaration> getFields() {
        return this.fieldMap.values();
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    public int findConfigDepth(@NonNull String[] parts, int maxDepth) {
        GenericsDeclaration fieldType;
        Optional<FieldDeclaration> field;
        Objects.requireNonNull(parts, "parts is marked non-null but is null");
        ConfigDeclaration currentDecl = this;
        int depth = 0;
        for (int i = 0; i < parts.length - 1 && i < maxDepth && (field = currentDecl.getField(parts[i])).isPresent() && (fieldType = field.get().getType()).isConfig(); ++i) {
            currentDecl = ConfigDeclaration.of(fieldType.getType());
            depth = i + 1;
        }
        return depth;
    }

    public ConfigDeclaration resolveNestedDeclaration(@NonNull String key, Object value) {
        GenericsDeclaration valueType;
        GenericsDeclaration elementType;
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Optional<FieldDeclaration> field = this.getField(key);
        if (!field.isPresent()) {
            return null;
        }
        GenericsDeclaration fieldType = field.get().getType();
        if (fieldType.isConfig()) {
            return ConfigDeclaration.of(fieldType.getType());
        }
        if (value instanceof List && (elementType = fieldType.getSubtypeAtOrNull(0)) != null && elementType.isConfig()) {
            return ConfigDeclaration.of(elementType.getType());
        }
        if (value instanceof Map && (valueType = fieldType.getSubtypeAtOrNull(1)) != null && valueType.isConfig()) {
            return ConfigDeclaration.of(valueType.getType());
        }
        return null;
    }

    @Generated
    public ConfigDeclaration() {
    }

    @Generated
    public Names getNameStrategy() {
        return this.nameStrategy;
    }

    @Generated
    public String[] getHeader() {
        return this.header;
    }

    @Generated
    public Map<String, FieldDeclaration> getFieldMap() {
        return this.fieldMap;
    }

    @Generated
    public boolean isReal() {
        return this.real;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public void setNameStrategy(Names nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    @Generated
    public void setHeader(String[] header) {
        this.header = header;
    }

    @Generated
    public void setFieldMap(Map<String, FieldDeclaration> fieldMap) {
        this.fieldMap = fieldMap;
    }

    @Generated
    public void setReal(boolean real) {
        this.real = real;
    }

    @Generated
    public void setType(Class<?> type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigDeclaration)) {
            return false;
        }
        ConfigDeclaration other = (ConfigDeclaration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReal() != other.isReal()) {
            return false;
        }
        Names this$nameStrategy = this.getNameStrategy();
        Names other$nameStrategy = other.getNameStrategy();
        if (this$nameStrategy == null ? other$nameStrategy != null : !this$nameStrategy.equals(other$nameStrategy)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getHeader(), other.getHeader())) {
            return false;
        }
        Map<String, FieldDeclaration> this$fieldMap = this.getFieldMap();
        Map<String, FieldDeclaration> other$fieldMap = other.getFieldMap();
        if (this$fieldMap == null ? other$fieldMap != null : !((Object)this$fieldMap).equals(other$fieldMap)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigDeclaration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReal() ? 79 : 97);
        Names $nameStrategy = this.getNameStrategy();
        result = result * 59 + ($nameStrategy == null ? 43 : $nameStrategy.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeader());
        Map<String, FieldDeclaration> $fieldMap = this.getFieldMap();
        result = result * 59 + ($fieldMap == null ? 43 : ((Object)$fieldMap).hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigDeclaration(nameStrategy=" + this.getNameStrategy() + ", header=" + Arrays.deepToString(this.getHeader()) + ", fieldMap=" + this.getFieldMap() + ", real=" + this.isReal() + ", type=" + this.getType() + ")";
    }
}

