/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.postprocessor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class ConfigPostprocessor {
    private String context;

    public static ConfigPostprocessor of(@NonNull InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream is marked non-null but is null");
        ConfigPostprocessor postprocessor = new ConfigPostprocessor();
        postprocessor.setContext(ConfigPostprocessor.readInput(inputStream));
        return postprocessor;
    }

    public static ConfigPostprocessor of(@NonNull String context) {
        Objects.requireNonNull(context, "context is marked non-null but is null");
        ConfigPostprocessor postprocessor = new ConfigPostprocessor();
        postprocessor.setContext(context);
        return postprocessor;
    }

    private static String readInput(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    private static void writeOutput(OutputStream outputStream, String text) {
        PrintStream out = new PrintStream(outputStream, true, StandardCharsets.UTF_8.name());
        try {
            out.print(text);
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    public ConfigPostprocessor write(@NonNull OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream is marked non-null but is null");
        ConfigPostprocessor.writeOutput(outputStream, this.context);
        return this;
    }

    public ConfigPostprocessor removeLines(@NonNull Predicate<String> shouldRemove) {
        Objects.requireNonNull(shouldRemove, "shouldRemove is marked non-null but is null");
        String[] lines = this.context.split("\n");
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            if (shouldRemove.test(line)) continue;
            buf.append(line).append("\n");
        }
        this.context = buf.toString();
        return this;
    }

    public ConfigPostprocessor removeLinesUntil(@NonNull Predicate<String> shouldStop) {
        Objects.requireNonNull(shouldStop, "shouldStop is marked non-null but is null");
        String[] lines = this.context.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!shouldStop.test(line)) continue;
            CharSequence[] remaining = Arrays.copyOfRange(lines, i, lines.length);
            this.context = String.join((CharSequence)"\n", remaining);
            break;
        }
        return this;
    }

    public ConfigPostprocessor updateLines(@NonNull Function<String, String> transform) {
        Objects.requireNonNull(transform, "transform is marked non-null but is null");
        String[] lines = this.context.split("\n");
        StringBuilder buf = new StringBuilder();
        for (String line : lines) {
            buf.append(transform.apply(line)).append("\n");
        }
        this.context = buf.toString();
        return this;
    }

    public ConfigPostprocessor updateContext(@NonNull Function<String, String> transform) {
        Objects.requireNonNull(transform, "transform is marked non-null but is null");
        this.context = transform.apply(this.context);
        return this;
    }

    @Generated
    public ConfigPostprocessor() {
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigPostprocessor)) {
            return false;
        }
        ConfigPostprocessor other = (ConfigPostprocessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigPostprocessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigPostprocessor(context=" + this.getContext() + ")";
    }
}

