/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.migrate.view;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.TypedKeyReader;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.TypedKeyWriter;

public class RawConfigView
implements TypedKeyReader,
TypedKeyWriter {
    private final OkaeriConfig config;
    private String nestedSeparator = "\\.";

    @Override
    public Configurer getConfigurer() {
        return this.config.getConfigurer();
    }

    @Override
    public SerdesContext getReaderContext(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return SerdesContext.of(this.getConfigurer(), this.config.getContext(), null);
    }

    @Override
    public SerdesContext getWriterContext(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return SerdesContext.of(this.getConfigurer(), this.config.getContext(), null);
    }

    @Override
    public Object getRaw(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Map<String, Object> document = this.config.asMap();
        return this.valueExtract(document, key);
    }

    @Override
    public void setRaw(@NonNull String key, Object value) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Map<String, Object> document = this.config.asMap();
        this.valuePut(document, key, value);
        this.config.load(document);
    }

    @Override
    public Object getRawOrNull(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return this.getRaw(key);
    }

    public Object get(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        return this.getRaw(key);
    }

    public boolean exists(@NonNull String key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Map<String, Object> document = this.config.asMap();
        return this.valueExists(document, key);
    }

    public Object remove(@NonNull String key) {
        Map<String, Object> internalState;
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Map<String, Object> document = this.config.asMap();
        Object old = this.valueRemove(document, key);
        if (key.split(this.nestedSeparator).length == 1 && (internalState = this.config.getInternalState()) != null) {
            internalState.remove(key);
        }
        this.config.load(document);
        return old;
    }

    protected boolean valueExists(Map<?, ?> document, String path) {
        String[] split = path.split(this.nestedSeparator);
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            if (i == split.length - 1) {
                return document.containsKey(part);
            }
            Object element = document.get(part);
            if (!(element instanceof Map)) {
                return false;
            }
            document = (Map)element;
        }
        return false;
    }

    protected Object valueExtract(Map<?, ?> document, String path) {
        String[] split = path.split(this.nestedSeparator);
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            Object element = document.get(part);
            if (i == split.length - 1) {
                return element;
            }
            if (!(element instanceof Map)) {
                return null;
            }
            document = (Map)element;
        }
        return null;
    }

    protected Object valuePut(Map<?, ?> document, String path, Object value) {
        String[] split = path.split(this.nestedSeparator);
        LinkedHashMap<String, Object> current = document;
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            if (i == split.length - 1) {
                return current.put(part, value);
            }
            Object element = current.get(part);
            if (element instanceof Map) {
                current = (LinkedHashMap<String, Object>)element;
                continue;
            }
            if (element != null) {
                String elementStr = element.getClass().getSimpleName();
                throw new IllegalArgumentException("Cannot insert '" + path + "': type conflict (ended at index " + i + " [" + part + ":" + elementStr + "])");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            current.put(part, map);
            current = map;
        }
        throw new IllegalArgumentException("Cannot put '" + path + "'");
    }

    protected Object valueRemove(Map<?, ?> document, String path) {
        String[] split = path.split(this.nestedSeparator);
        Map current = document;
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            if (i == split.length - 1) {
                return current.remove(part);
            }
            Object element = current.get(part);
            if (!(element instanceof Map)) {
                return null;
            }
            current = (Map)element;
        }
        return null;
    }

    @Generated
    public RawConfigView(OkaeriConfig config, String nestedSeparator) {
        this.config = config;
        this.nestedSeparator = nestedSeparator;
    }

    @Generated
    public RawConfigView(OkaeriConfig config) {
        this.config = config;
    }
}

