/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.format.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceLocation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;

public class YamlSourceWalker
implements SourceWalker {
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^(\\s*)([^#:\\-][^:]*?):\\s*(.*)$");
    private static final Pattern LIST_ITEM_PATTERN = Pattern.compile("^(\\s*)-\\s*(.*)$");
    private static final Set<String> MULTILINE_INDICATORS = new HashSet<String>(Arrays.asList("|", "|-", ">", ">-", "|+", ">+"));
    private final List<SourceLocation> locations = new ArrayList<SourceLocation>();
    private final Map<ConfigPath, SourceLocation> pathToLocation = new LinkedHashMap<ConfigPath, SourceLocation>();
    private final String content;

    public YamlSourceWalker(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        this.content = content;
        this.parse();
    }

    public static YamlSourceWalker of(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        return new YamlSourceWalker(content);
    }

    @Override
    public SourceLocation findPath(@NonNull ConfigPath path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return this.pathToLocation.get(path);
    }

    public String insertComments(@NonNull ConfigDeclaration declaration, @NonNull String commentPrefix) {
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        Objects.requireNonNull(commentPrefix, "commentPrefix is marked non-null but is null");
        HashSet<String> commentedPatterns = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        String[] header = declaration.getHeader();
        if (header != null) {
            result.append(YamlSourceWalker.formatComment(commentPrefix, header));
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            boolean isTrailingEmpty;
            String pattern;
            SourceLocation location = this.locations.get(i);
            ConfigPath path = location.getConfigPath();
            if (path != null && location.getKey() != null && !commentedPatterns.contains(pattern = path.toPattern(declaration))) {
                String[] comment = YamlSourceWalker.resolveComment(path, declaration);
                if (comment != null) {
                    String commentStr = YamlSourceWalker.formatComment(commentPrefix, comment);
                    result.append(YamlSourceWalker.indent(commentStr, location.getIndent()));
                }
                commentedPatterns.add(pattern);
            }
            result.append(location.getRawLine());
            boolean isLastLine = i == this.locations.size() - 1;
            boolean bl = isTrailingEmpty = isLastLine && location.getRawLine().isEmpty();
            if (isTrailingEmpty) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private static String[] resolveComment(ConfigPath path, ConfigDeclaration declaration) {
        if (path == null || path.isEmpty() || declaration == null) {
            return null;
        }
        Optional<FieldDeclaration> field = path.resolveFieldDeclaration(declaration);
        return field.map(FieldDeclaration::getComment).orElse(null);
    }

    private void parse() {
        String[] rawLines = this.content.split("\n", -1);
        ArrayList<PathEntry> pathStack = new ArrayList<PathEntry>();
        HashMap<Integer, Integer> listIndices = new HashMap<Integer, Integer>();
        boolean inMultiline = false;
        int multilineBaseIndent = 0;
        ConfigPath multilinePath = null;
        int multilineKeyLine = -1;
        int multilineFirstContentLine = -1;
        int multilineFirstContentColumn = -1;
        String multilineFirstContentRawLine = null;
        for (int i = 0; i < rawLines.length; ++i) {
            ConfigPath parentPath;
            String rawLine = rawLines[i];
            int lineNumber = i + 1;
            int indent = YamlSourceWalker.countIndent(rawLine);
            String trimmed = rawLine.trim();
            if (inMultiline) {
                if (!trimmed.isEmpty() && indent <= multilineBaseIndent) {
                    this.updateMultilineLocation(multilinePath, multilineFirstContentLine, multilineFirstContentColumn, multilineFirstContentRawLine, lineNumber - 1);
                    inMultiline = false;
                    multilinePath = null;
                } else {
                    if (multilineFirstContentLine == -1 && !trimmed.isEmpty()) {
                        multilineFirstContentLine = lineNumber;
                        multilineFirstContentColumn = indent;
                        multilineFirstContentRawLine = rawLine;
                    }
                    this.locations.add(SourceLocation.builder().lineNumber(lineNumber).indent(indent).rawLine(rawLine).build());
                    continue;
                }
            }
            if (trimmed.isEmpty()) {
                this.locations.add(SourceLocation.builder().lineNumber(lineNumber).indent(0).rawLine(rawLine).build());
                continue;
            }
            if (trimmed.startsWith("#")) {
                this.locations.add(SourceLocation.builder().lineNumber(lineNumber).indent(indent).rawLine(rawLine).build());
                continue;
            }
            Matcher listMatcher = LIST_ITEM_PATTERN.matcher(rawLine);
            boolean isListItem = listMatcher.matches();
            if (isListItem) {
                while (!pathStack.isEmpty() && ((PathEntry)pathStack.get((int)(pathStack.size() - 1))).indent > indent) {
                    pathStack.remove(pathStack.size() - 1);
                }
            } else {
                while (!pathStack.isEmpty() && ((PathEntry)pathStack.get((int)(pathStack.size() - 1))).indent >= indent) {
                    pathStack.remove(pathStack.size() - 1);
                }
            }
            listIndices.keySet().removeIf(ind -> ind > indent);
            if (isListItem) {
                int listIndent = listMatcher.group(1).length();
                String listContent = listMatcher.group(2);
                int listIndex = listIndices.getOrDefault(listIndent, -1) + 1;
                listIndices.put(listIndent, listIndex);
                parentPath = this.getListParentPath(pathStack, listIndent);
                ConfigPath indexedPath = parentPath.index(listIndex);
                if (listContent.contains(":")) {
                    int colonPos = listContent.indexOf(58);
                    String key = listContent.substring(0, colonPos).trim();
                    String value = listContent.substring(colonPos + 1).trim();
                    ConfigPath fullPath = indexedPath.property(key);
                    int keyColumn = rawLine.indexOf(key, listIndent + 2);
                    int valueColumn = value.isEmpty() ? -1 : rawLine.lastIndexOf(value);
                    SourceLocation location = SourceLocation.builder().lineNumber(lineNumber).keyColumn(keyColumn).indent(listIndent).key(key).value(value.isEmpty() ? null : value).valueColumn(valueColumn).rawLine(rawLine).configPath(fullPath).build();
                    this.locations.add(location);
                    this.pathToLocation.put(fullPath, location);
                    pathStack.add(new PathEntry(indexedPath, listIndent));
                    if (!YamlSourceWalker.isMultilineIndicator(value)) continue;
                    inMultiline = true;
                    multilineBaseIndent = listIndent;
                    multilinePath = fullPath;
                    multilineKeyLine = lineNumber;
                    multilineFirstContentLine = -1;
                    multilineFirstContentColumn = -1;
                    multilineFirstContentRawLine = null;
                    continue;
                }
                int valueColumn = listContent.isEmpty() ? -1 : rawLine.indexOf(listContent, listIndent + 2);
                SourceLocation location = SourceLocation.builder().lineNumber(lineNumber).keyColumn(listIndent + 2).indent(listIndent).value(listContent.isEmpty() ? null : listContent).valueColumn(valueColumn).rawLine(rawLine).configPath(indexedPath).build();
                this.locations.add(location);
                this.pathToLocation.put(indexedPath, location);
                continue;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(rawLine);
            if (keyValueMatcher.matches()) {
                String key = keyValueMatcher.group(2).trim();
                String value = keyValueMatcher.group(3).trim();
                parentPath = this.getParentPath(pathStack);
                ConfigPath fullPath = parentPath.property(key);
                int keyColumn = rawLine.indexOf(key);
                int valueColumn = value.isEmpty() ? -1 : rawLine.lastIndexOf(value);
                SourceLocation location = SourceLocation.builder().lineNumber(lineNumber).keyColumn(keyColumn).indent(indent).key(key).value(value.isEmpty() ? null : value).valueColumn(valueColumn).rawLine(rawLine).configPath(fullPath).build();
                this.locations.add(location);
                this.pathToLocation.put(fullPath, location);
                pathStack.add(new PathEntry(fullPath, indent));
                if (!YamlSourceWalker.isMultilineIndicator(value)) continue;
                inMultiline = true;
                multilineBaseIndent = indent;
                multilinePath = fullPath;
                multilineKeyLine = lineNumber;
                multilineFirstContentLine = -1;
                multilineFirstContentColumn = -1;
                multilineFirstContentRawLine = null;
                continue;
            }
            this.locations.add(SourceLocation.builder().lineNumber(lineNumber).indent(indent).rawLine(rawLine).build());
        }
        if (inMultiline && multilinePath != null) {
            int lastContentLine;
            for (lastContentLine = rawLines.length; lastContentLine > multilineFirstContentLine && lastContentLine - 1 < rawLines.length && rawLines[lastContentLine - 1].trim().isEmpty(); --lastContentLine) {
            }
            this.updateMultilineLocation(multilinePath, multilineFirstContentLine, multilineFirstContentColumn, multilineFirstContentRawLine, lastContentLine);
        }
    }

    private void updateMultilineLocation(ConfigPath path, int contentLineNumber, int contentColumn, String contentRawLine, int contentEndLineNumber) {
        if (path == null) {
            return;
        }
        SourceLocation existing = this.pathToLocation.get(path);
        if (existing == null) {
            return;
        }
        SourceLocation updated = SourceLocation.builder().lineNumber(existing.getLineNumber()).rawLine(existing.getRawLine()).valueColumn(existing.getValueColumn()).value(existing.getValue()).keyColumn(existing.getKeyColumn()).key(existing.getKey()).configPath(existing.getConfigPath()).indent(existing.getIndent()).contentLineNumber(contentLineNumber).contentColumn(contentColumn).contentRawLine(contentRawLine).contentEndLineNumber(contentEndLineNumber).build();
        this.pathToLocation.put(path, updated);
    }

    private ConfigPath getParentPath(List<PathEntry> pathStack) {
        if (pathStack.isEmpty()) {
            return ConfigPath.root();
        }
        return pathStack.get((int)(pathStack.size() - 1)).path;
    }

    private ConfigPath getListParentPath(List<PathEntry> pathStack, int listIndent) {
        if (pathStack.isEmpty()) {
            return ConfigPath.root();
        }
        for (int i = pathStack.size() - 1; i >= 0; --i) {
            List<ConfigPath.PathNode> nodes;
            PathEntry entry = pathStack.get(i);
            if (entry.indent == listIndent && !(nodes = entry.path.getNodes()).isEmpty() && nodes.get(nodes.size() - 1) instanceof ConfigPath.IndexNode) continue;
            return entry.path;
        }
        return ConfigPath.root();
    }

    private static int countIndent(String line) {
        int count = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++count;
                continue;
            }
            if (c != '\t') break;
            count += 2;
        }
        return count;
    }

    private static boolean isMultilineIndicator(String value) {
        return MULTILINE_INDICATORS.contains(value);
    }

    private static String formatComment(String prefix, String[] lines) {
        if (lines == null) {
            return "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String prefixTrimmed = prefix.trim();
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (line.isEmpty()) {
                result.append("\n");
                continue;
            }
            if (line.startsWith(prefixTrimmed)) {
                result.append(line).append("\n");
                continue;
            }
            if (line.trim().isEmpty()) {
                result.append(prefixTrimmed).append("\n");
                continue;
            }
            result.append(prefix).append(line).append("\n");
        }
        return result.toString();
    }

    private static String indent(String text, int spaces) {
        if (spaces <= 0) {
            return text;
        }
        StringBuilder indentStr = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            indentStr.append(" ");
        }
        String indent = indentStr.toString();
        StringBuilder result = new StringBuilder();
        String[] lines = text.split("\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == lines.length - 1 && line.isEmpty()) break;
            if (line.isEmpty()) {
                result.append("\n");
                continue;
            }
            result.append(indent).append(line).append("\n");
        }
        return result.toString();
    }

    @Generated
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Generated
    public Map<ConfigPath, SourceLocation> getPathToLocation() {
        return this.pathToLocation;
    }

    private static class PathEntry {
        final ConfigPath path;
        final int indent;

        PathEntry(ConfigPath path, int indent) {
            this.path = path;
            this.indent = indent;
        }
    }
}

