/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.format.xml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceLocation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;

public class XmlSourceWalker
implements SourceWalker {
    private static final Pattern OPEN_TAG = Pattern.compile("<([a-zA-Z_][a-zA-Z0-9_\\-]*)(?:\\s[^>]*)?>(.*)");
    private static final Pattern CLOSE_TAG = Pattern.compile("</([a-zA-Z_][a-zA-Z0-9_\\-]*)>");
    private static final Pattern SELF_CLOSING_TAG = Pattern.compile("<([a-zA-Z_][a-zA-Z0-9_\\-]*)/>");
    private static final Pattern INLINE_ELEMENT = Pattern.compile("<([a-zA-Z_][a-zA-Z0-9_\\-]*)(?:\\s[^>]*)?>([^<]*)</\\1>");
    private static final Pattern ENTRY_WITH_KEY = Pattern.compile("<entry\\s+key=\"([^\"]+)\"[^>]*>([^<]*)</entry>");
    private static final Pattern ITEM_ELEMENT = Pattern.compile("<item[^>]*>([^<]*)</item>");
    private final Map<ConfigPath, SourceLocation> pathToLocation = new LinkedHashMap<ConfigPath, SourceLocation>();
    private final String rootElement;

    public XmlSourceWalker(@NonNull String content, @NonNull String rootElement) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        Objects.requireNonNull(rootElement, "rootElement is marked non-null but is null");
        this.rootElement = rootElement;
        this.parse(content);
    }

    public static XmlSourceWalker of(@NonNull String content, @NonNull String rootElement) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        Objects.requireNonNull(rootElement, "rootElement is marked non-null but is null");
        return new XmlSourceWalker(content, rootElement);
    }

    @Override
    public SourceLocation findPath(@NonNull ConfigPath path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return this.pathToLocation.get(path);
    }

    private void parse(String content) {
        String[] lines = content.split("\n", -1);
        ArrayDeque<ConfigPath> pathStack = new ArrayDeque<ConfigPath>();
        pathStack.push(ConfigPath.root());
        HashMap<ConfigPath, Integer> listIndices = new HashMap<ConfigPath, Integer>();
        for (int i = 0; i < lines.length; ++i) {
            String rawLine = lines[i];
            int lineNumber = i + 1;
            if (rawLine.trim().isEmpty()) continue;
            this.parseLine(rawLine, lineNumber, pathStack, listIndices);
        }
    }

    private void parseLine(String rawLine, int lineNumber, Deque<ConfigPath> pathStack, Map<ConfigPath, Integer> listIndices) {
        int tagStart;
        int pos = 0;
        while (pos < rawLine.length() && (tagStart = rawLine.indexOf(60, pos)) >= 0) {
            if (rawLine.startsWith("<?", tagStart)) {
                int declEnd = rawLine.indexOf("?>", tagStart);
                pos = declEnd >= 0 ? declEnd + 2 : rawLine.length();
                continue;
            }
            if (rawLine.startsWith("<!--", tagStart)) {
                int commentEnd = rawLine.indexOf("-->", tagStart);
                pos = commentEnd >= 0 ? commentEnd + 3 : rawLine.length();
                continue;
            }
            ConfigPath parentPath = pathStack.peek();
            String remaining = rawLine.substring(tagStart);
            Matcher closeMatcher = CLOSE_TAG.matcher(remaining);
            if (closeMatcher.lookingAt()) {
                ConfigPath current;
                ConfigPath.PathNode lastNode;
                String tagName = closeMatcher.group(1);
                if (!this.rootElement.equals(tagName) && pathStack.size() > 1 && (lastNode = (current = pathStack.peek()).getLastNode()) instanceof ConfigPath.PropertyNode && tagName.equals(((ConfigPath.PropertyNode)lastNode).getName())) {
                    pathStack.pop();
                    listIndices.remove(current);
                }
                pos = tagStart + closeMatcher.end();
                continue;
            }
            Matcher selfClosingMatcher = SELF_CLOSING_TAG.matcher(remaining);
            if (selfClosingMatcher.lookingAt()) {
                String tagName = selfClosingMatcher.group(1);
                if (!"null".equals(tagName) && !this.rootElement.equals(tagName)) {
                    ConfigPath fullPath = parentPath.property(tagName);
                    this.pathToLocation.put(fullPath, SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(tagStart + 1).key(tagName).valueColumn(-1).value(null).build());
                }
                pos = tagStart + selfClosingMatcher.end();
                continue;
            }
            Matcher entryMatcher = ENTRY_WITH_KEY.matcher(remaining);
            if (entryMatcher.lookingAt()) {
                String key = entryMatcher.group(1);
                String value = entryMatcher.group(2);
                ConfigPath fullPath = parentPath.property(key);
                int keyAttrPos = remaining.indexOf("key=\"") + 5;
                int valueStart = remaining.indexOf(">") + 1;
                this.pathToLocation.put(fullPath, SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(tagStart + keyAttrPos).key(key).valueColumn(tagStart + valueStart).value(value).build());
                pos = tagStart + entryMatcher.end();
                continue;
            }
            Matcher itemMatcher = ITEM_ELEMENT.matcher(remaining);
            if (itemMatcher.lookingAt()) {
                int index = listIndices.getOrDefault(parentPath, 0);
                listIndices.put(parentPath, index + 1);
                String value = itemMatcher.group(1);
                ConfigPath fullPath = parentPath.index(index);
                int valueStart = remaining.indexOf(">") + 1;
                this.pathToLocation.put(fullPath, SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(tagStart).key("item").valueColumn(tagStart + valueStart).value(value).build());
                pos = tagStart + itemMatcher.end();
                continue;
            }
            Matcher inlineMatcher = INLINE_ELEMENT.matcher(remaining);
            if (inlineMatcher.lookingAt()) {
                String tagName = inlineMatcher.group(1);
                String value = inlineMatcher.group(2);
                if (!this.rootElement.equals(tagName)) {
                    ConfigPath fullPath = parentPath.property(tagName);
                    int valueStart = remaining.indexOf(">") + 1;
                    this.pathToLocation.put(fullPath, SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(tagStart + 1).key(tagName).valueColumn(tagStart + valueStart).value(value).build());
                }
                pos = tagStart + inlineMatcher.end();
                continue;
            }
            Matcher openMatcher = OPEN_TAG.matcher(remaining);
            if (openMatcher.lookingAt()) {
                String tagName = openMatcher.group(1);
                if (!this.rootElement.equals(tagName)) {
                    pathStack.push(parentPath.property(tagName));
                }
                int closeAngle = remaining.indexOf(62);
                pos = tagStart + closeAngle + 1;
                continue;
            }
            pos = tagStart + 1;
        }
    }
}

